/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Player;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import bwem.Mineral;
import config.FeatureFlags;
import info.BaseData;
import info.ResourceCount;
import info.TechProgression;
import info.UnitTypeCount;
import info.map.GameMap;
import java.util.HashMap;
import java.util.HashSet;
import learning.Decisions;
import planner.Plan;
import planner.PlanState;
import planner.PlanType;
import strategy.openers.Opener;
import strategy.strategies.Strategy;
import strategy.strategies.UnitWeights;
import unit.managed.ManagedUnit;

public class GameState {
    private Player self;
    private BWEM bwem;
    private Race opponentRace;
    private int mineralWorkers;
    private int geyserWorkers;
    private int plannedSupply;
    private int larvaDeadlockDetectedFrame;
    private HashSet<ManagedUnit> gatherers = new HashSet();
    private HashSet<ManagedUnit> mineralGatherers = new HashSet();
    private HashSet<ManagedUnit> gasGatherers = new HashSet();
    private HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments = new HashMap();
    private HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments = new HashMap();
    private HashSet<ManagedUnit> larva = new HashSet();
    private boolean enemyHasCloakedUnits = false;
    private boolean enemyHasHostileFlyers = false;
    private boolean isLarvaDeadlocked = false;
    private boolean isAllIn = false;
    private HashSet<Plan> plansScheduled = new HashSet();
    private HashSet<Plan> plansBuilding = new HashSet();
    private HashSet<Plan> plansMorphing = new HashSet();
    private HashSet<Plan> plansComplete = new HashSet();
    private HashSet<Plan> plansImpossible = new HashSet();
    private HashMap<Unit, Plan> assignedPlannedItems = new HashMap();
    private HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase = new HashMap();
    private HashMap<Base, HashSet<Unit>> baseToThreatLookup = new HashMap();
    private Opener activeOpener;
    private Strategy activeStrategy;
    private UnitWeights unitWeights;
    private boolean defensiveSunk = false;
    private UnitTypeCount unitTypeCount = new UnitTypeCount();
    private TechProgression techProgression = new TechProgression();
    private ResourceCount resourceCount;
    private BaseData baseData;
    private GameMap gameMap;

    public GameState(Player self, BWEM bwem) {
        this.self = self;
        this.bwem = bwem;
        this.resourceCount = new ResourceCount(self);
        this.baseData = new BaseData(bwem.getMap().getBases());
    }

    public void onStart(Decisions decisions, Race opponentRace) {
        Opener opener;
        this.activeOpener = opener = decisions.getOpener();
        this.isAllIn = opener.isAllIn();
        this.activeStrategy = decisions.getStrategy();
        this.unitWeights = this.activeStrategy.getUnitWeights();
        if (FeatureFlags.learnDefensiveSunk) {
            this.defensiveSunk = decisions.isDefensiveSunk();
        }
        this.opponentRace = opponentRace;
    }

    public int numGatherers() {
        return this.gatherers.size();
    }

    public int numLarva() {
        return this.larva.size();
    }

    public int frameCanAffordUnit(UnitType unit, int currentFrame) {
        return this.resourceCount.frameCanAffordUnit(unit, currentFrame, this.mineralGatherers.size(), this.gasGatherers.size());
    }

    public Base reserveBase() {
        return this.baseData.reserveBase();
    }

    public void claimBase(Unit hatchery) {
        if (this.baseData.isBase(hatchery)) {
            return;
        }
        Base newBase = this.baseData.claimBase(hatchery);
        this.addBaseToGameState(hatchery, newBase);
    }

    public void addBaseToGameState(Unit hatchery, Base base) {
        if (base == null) {
            return;
        }
        this.gatherersAssignedToBase.put(base, new HashSet());
        this.baseData.addBase(hatchery, base);
        for (Mineral mineral : base.getMinerals()) {
            this.mineralAssignments.put(mineral.getUnit(), new HashSet());
        }
    }

    public void addMainBase(Unit hatchery, Base base) {
        this.baseData.initializeMainBase(base, this.gameMap);
        this.addBaseToGameState(hatchery, base);
    }

    public void addMacroHatchery(Unit hatchery) {
        this.baseData.addMacroHatchery(hatchery);
    }

    public void removeHatchery(Unit hatchery) {
        if (this.baseData.isBase(hatchery)) {
            Base base = this.baseData.get(hatchery);
            this.gatherersAssignedToBase.remove(base);
            this.baseToThreatLookup.remove(base);
        }
        this.baseData.removeHatchery(hatchery);
    }

    public void cancelPlan(Unit unit, Plan plan) {
        this.plansBuilding.remove(plan);
        this.plansMorphing.remove(plan);
        this.plansImpossible.remove(plan);
        plan.setState(PlanState.CANCELLED);
        this.assignedPlannedItems.remove(unit);
        if (plan.getType() == PlanType.BUILDING) {
            UnitType type = plan.getPlannedUnit();
            this.resourceCount.unreserveUnit(type);
            TilePosition tp = plan.getBuildPosition();
            if (tp != null && this.baseData.isBaseTilePosition(tp)) {
                Base base = this.baseData.baseAtTilePosition(tp);
                this.baseData.cancelReserveBase(base);
            }
        }
    }

    public void completePlan(Unit unit, Plan plan) {
        this.plansBuilding.remove(plan);
        this.plansMorphing.remove(plan);
        plan.setState(PlanState.COMPLETE);
        this.plansComplete.add(plan);
        this.assignedPlannedItems.remove(unit);
    }

    public void setImpossiblePlan(Plan plan) {
        this.plansImpossible.add(plan);
    }

    public boolean canPlanLair() {
        return this.needLair() && this.techProgression.canPlanLair() && this.hasMinHatchForLair();
    }

    public boolean canPlanHive() {
        return this.needHive() && this.techProgression.canPlanHive();
    }

    public boolean canPlanQueensNest() {
        return this.needHive() && this.techProgression.canPlanQueensNest();
    }

    private boolean needLair() {
        boolean unitsNeedLairTech = this.unitWeights.hasUnit(UnitType.Zerg_Mutalisk) || this.unitWeights.hasUnit(UnitType.Zerg_Scourge) || this.unitWeights.hasUnit(UnitType.Zerg_Lurker);
        return unitsNeedLairTech || this.techProgression.needLairForNextEvolutionChamberUpgrades() || this.needHive();
    }

    private boolean needHive() {
        boolean unitsNeedHiveTech = this.unitWeights.hasUnit(UnitType.Zerg_Ultralisk) || this.unitWeights.hasUnit(UnitType.Zerg_Defiler);
        return unitsNeedHiveTech || this.techProgression.needHiveForUpgrades();
    }

    private boolean hasMinHatchForLair() {
        int numHatch = this.baseData.numHatcheries();
        if (this.opponentRace == Race.Zerg) {
            return numHatch > 0;
        }
        return numHatch > 1;
    }

    public Player getSelf() {
        return this.self;
    }

    public BWEM getBwem() {
        return this.bwem;
    }

    public Race getOpponentRace() {
        return this.opponentRace;
    }

    public int getMineralWorkers() {
        return this.mineralWorkers;
    }

    public int getGeyserWorkers() {
        return this.geyserWorkers;
    }

    public int getPlannedSupply() {
        return this.plannedSupply;
    }

    public int getLarvaDeadlockDetectedFrame() {
        return this.larvaDeadlockDetectedFrame;
    }

    public HashSet<ManagedUnit> getGatherers() {
        return this.gatherers;
    }

    public HashSet<ManagedUnit> getMineralGatherers() {
        return this.mineralGatherers;
    }

    public HashSet<ManagedUnit> getGasGatherers() {
        return this.gasGatherers;
    }

    public HashMap<Unit, HashSet<ManagedUnit>> getGeyserAssignments() {
        return this.geyserAssignments;
    }

    public HashMap<Unit, HashSet<ManagedUnit>> getMineralAssignments() {
        return this.mineralAssignments;
    }

    public HashSet<ManagedUnit> getLarva() {
        return this.larva;
    }

    public boolean isEnemyHasCloakedUnits() {
        return this.enemyHasCloakedUnits;
    }

    public boolean isEnemyHasHostileFlyers() {
        return this.enemyHasHostileFlyers;
    }

    public boolean isLarvaDeadlocked() {
        return this.isLarvaDeadlocked;
    }

    public boolean isAllIn() {
        return this.isAllIn;
    }

    public HashSet<Plan> getPlansScheduled() {
        return this.plansScheduled;
    }

    public HashSet<Plan> getPlansBuilding() {
        return this.plansBuilding;
    }

    public HashSet<Plan> getPlansMorphing() {
        return this.plansMorphing;
    }

    public HashSet<Plan> getPlansComplete() {
        return this.plansComplete;
    }

    public HashSet<Plan> getPlansImpossible() {
        return this.plansImpossible;
    }

    public HashMap<Unit, Plan> getAssignedPlannedItems() {
        return this.assignedPlannedItems;
    }

    public HashMap<Base, HashSet<ManagedUnit>> getGatherersAssignedToBase() {
        return this.gatherersAssignedToBase;
    }

    public HashMap<Base, HashSet<Unit>> getBaseToThreatLookup() {
        return this.baseToThreatLookup;
    }

    public Opener getActiveOpener() {
        return this.activeOpener;
    }

    public Strategy getActiveStrategy() {
        return this.activeStrategy;
    }

    public UnitWeights getUnitWeights() {
        return this.unitWeights;
    }

    public boolean isDefensiveSunk() {
        return this.defensiveSunk;
    }

    public UnitTypeCount getUnitTypeCount() {
        return this.unitTypeCount;
    }

    public TechProgression getTechProgression() {
        return this.techProgression;
    }

    public ResourceCount getResourceCount() {
        return this.resourceCount;
    }

    public BaseData getBaseData() {
        return this.baseData;
    }

    public GameMap getGameMap() {
        return this.gameMap;
    }

    public void setSelf(Player self) {
        this.self = self;
    }

    public void setBwem(BWEM bwem) {
        this.bwem = bwem;
    }

    public void setOpponentRace(Race opponentRace) {
        this.opponentRace = opponentRace;
    }

    public void setMineralWorkers(int mineralWorkers) {
        this.mineralWorkers = mineralWorkers;
    }

    public void setGeyserWorkers(int geyserWorkers) {
        this.geyserWorkers = geyserWorkers;
    }

    public void setPlannedSupply(int plannedSupply) {
        this.plannedSupply = plannedSupply;
    }

    public void setLarvaDeadlockDetectedFrame(int larvaDeadlockDetectedFrame) {
        this.larvaDeadlockDetectedFrame = larvaDeadlockDetectedFrame;
    }

    public void setGatherers(HashSet<ManagedUnit> gatherers) {
        this.gatherers = gatherers;
    }

    public void setMineralGatherers(HashSet<ManagedUnit> mineralGatherers) {
        this.mineralGatherers = mineralGatherers;
    }

    public void setGasGatherers(HashSet<ManagedUnit> gasGatherers) {
        this.gasGatherers = gasGatherers;
    }

    public void setGeyserAssignments(HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments) {
        this.geyserAssignments = geyserAssignments;
    }

    public void setMineralAssignments(HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments) {
        this.mineralAssignments = mineralAssignments;
    }

    public void setLarva(HashSet<ManagedUnit> larva) {
        this.larva = larva;
    }

    public void setEnemyHasCloakedUnits(boolean enemyHasCloakedUnits) {
        this.enemyHasCloakedUnits = enemyHasCloakedUnits;
    }

    public void setEnemyHasHostileFlyers(boolean enemyHasHostileFlyers) {
        this.enemyHasHostileFlyers = enemyHasHostileFlyers;
    }

    public void setLarvaDeadlocked(boolean isLarvaDeadlocked) {
        this.isLarvaDeadlocked = isLarvaDeadlocked;
    }

    public void setAllIn(boolean isAllIn) {
        this.isAllIn = isAllIn;
    }

    public void setPlansScheduled(HashSet<Plan> plansScheduled) {
        this.plansScheduled = plansScheduled;
    }

    public void setPlansBuilding(HashSet<Plan> plansBuilding) {
        this.plansBuilding = plansBuilding;
    }

    public void setPlansMorphing(HashSet<Plan> plansMorphing) {
        this.plansMorphing = plansMorphing;
    }

    public void setPlansComplete(HashSet<Plan> plansComplete) {
        this.plansComplete = plansComplete;
    }

    public void setPlansImpossible(HashSet<Plan> plansImpossible) {
        this.plansImpossible = plansImpossible;
    }

    public void setAssignedPlannedItems(HashMap<Unit, Plan> assignedPlannedItems) {
        this.assignedPlannedItems = assignedPlannedItems;
    }

    public void setGatherersAssignedToBase(HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase) {
        this.gatherersAssignedToBase = gatherersAssignedToBase;
    }

    public void setBaseToThreatLookup(HashMap<Base, HashSet<Unit>> baseToThreatLookup) {
        this.baseToThreatLookup = baseToThreatLookup;
    }

    public void setActiveOpener(Opener activeOpener) {
        this.activeOpener = activeOpener;
    }

    public void setUnitWeights(UnitWeights unitWeights) {
        this.unitWeights = unitWeights;
    }

    public void setDefensiveSunk(boolean defensiveSunk) {
        this.defensiveSunk = defensiveSunk;
    }

    public void setUnitTypeCount(UnitTypeCount unitTypeCount) {
        this.unitTypeCount = unitTypeCount;
    }

    public void setTechProgression(TechProgression techProgression) {
        this.techProgression = techProgression;
    }

    public void setResourceCount(ResourceCount resourceCount) {
        this.resourceCount = resourceCount;
    }

    public void setBaseData(BaseData baseData) {
        this.baseData = baseData;
    }

    public void setGameMap(GameMap gameMap) {
        this.gameMap = gameMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameState)) {
            return false;
        }
        GameState other = (GameState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMineralWorkers() != other.getMineralWorkers()) {
            return false;
        }
        if (this.getGeyserWorkers() != other.getGeyserWorkers()) {
            return false;
        }
        if (this.getPlannedSupply() != other.getPlannedSupply()) {
            return false;
        }
        if (this.getLarvaDeadlockDetectedFrame() != other.getLarvaDeadlockDetectedFrame()) {
            return false;
        }
        if (this.isEnemyHasCloakedUnits() != other.isEnemyHasCloakedUnits()) {
            return false;
        }
        if (this.isEnemyHasHostileFlyers() != other.isEnemyHasHostileFlyers()) {
            return false;
        }
        if (this.isLarvaDeadlocked() != other.isLarvaDeadlocked()) {
            return false;
        }
        if (this.isAllIn() != other.isAllIn()) {
            return false;
        }
        if (this.isDefensiveSunk() != other.isDefensiveSunk()) {
            return false;
        }
        Player this$self = this.getSelf();
        Player other$self = other.getSelf();
        if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
            return false;
        }
        BWEM this$bwem = this.getBwem();
        BWEM other$bwem = other.getBwem();
        if (this$bwem == null ? other$bwem != null : !this$bwem.equals(other$bwem)) {
            return false;
        }
        Race this$opponentRace = this.getOpponentRace();
        Race other$opponentRace = other.getOpponentRace();
        if (this$opponentRace == null ? other$opponentRace != null : !((Object)((Object)this$opponentRace)).equals((Object)other$opponentRace)) {
            return false;
        }
        HashSet<ManagedUnit> this$gatherers = this.getGatherers();
        HashSet<ManagedUnit> other$gatherers = other.getGatherers();
        if (this$gatherers == null ? other$gatherers != null : !((Object)this$gatherers).equals(other$gatherers)) {
            return false;
        }
        HashSet<ManagedUnit> this$mineralGatherers = this.getMineralGatherers();
        HashSet<ManagedUnit> other$mineralGatherers = other.getMineralGatherers();
        if (this$mineralGatherers == null ? other$mineralGatherers != null : !((Object)this$mineralGatherers).equals(other$mineralGatherers)) {
            return false;
        }
        HashSet<ManagedUnit> this$gasGatherers = this.getGasGatherers();
        HashSet<ManagedUnit> other$gasGatherers = other.getGasGatherers();
        if (this$gasGatherers == null ? other$gasGatherers != null : !((Object)this$gasGatherers).equals(other$gasGatherers)) {
            return false;
        }
        HashMap<Unit, HashSet<ManagedUnit>> this$geyserAssignments = this.getGeyserAssignments();
        HashMap<Unit, HashSet<ManagedUnit>> other$geyserAssignments = other.getGeyserAssignments();
        if (this$geyserAssignments == null ? other$geyserAssignments != null : !((Object)this$geyserAssignments).equals(other$geyserAssignments)) {
            return false;
        }
        HashMap<Unit, HashSet<ManagedUnit>> this$mineralAssignments = this.getMineralAssignments();
        HashMap<Unit, HashSet<ManagedUnit>> other$mineralAssignments = other.getMineralAssignments();
        if (this$mineralAssignments == null ? other$mineralAssignments != null : !((Object)this$mineralAssignments).equals(other$mineralAssignments)) {
            return false;
        }
        HashSet<ManagedUnit> this$larva = this.getLarva();
        HashSet<ManagedUnit> other$larva = other.getLarva();
        if (this$larva == null ? other$larva != null : !((Object)this$larva).equals(other$larva)) {
            return false;
        }
        HashSet<Plan> this$plansScheduled = this.getPlansScheduled();
        HashSet<Plan> other$plansScheduled = other.getPlansScheduled();
        if (this$plansScheduled == null ? other$plansScheduled != null : !((Object)this$plansScheduled).equals(other$plansScheduled)) {
            return false;
        }
        HashSet<Plan> this$plansBuilding = this.getPlansBuilding();
        HashSet<Plan> other$plansBuilding = other.getPlansBuilding();
        if (this$plansBuilding == null ? other$plansBuilding != null : !((Object)this$plansBuilding).equals(other$plansBuilding)) {
            return false;
        }
        HashSet<Plan> this$plansMorphing = this.getPlansMorphing();
        HashSet<Plan> other$plansMorphing = other.getPlansMorphing();
        if (this$plansMorphing == null ? other$plansMorphing != null : !((Object)this$plansMorphing).equals(other$plansMorphing)) {
            return false;
        }
        HashSet<Plan> this$plansComplete = this.getPlansComplete();
        HashSet<Plan> other$plansComplete = other.getPlansComplete();
        if (this$plansComplete == null ? other$plansComplete != null : !((Object)this$plansComplete).equals(other$plansComplete)) {
            return false;
        }
        HashSet<Plan> this$plansImpossible = this.getPlansImpossible();
        HashSet<Plan> other$plansImpossible = other.getPlansImpossible();
        if (this$plansImpossible == null ? other$plansImpossible != null : !((Object)this$plansImpossible).equals(other$plansImpossible)) {
            return false;
        }
        HashMap<Unit, Plan> this$assignedPlannedItems = this.getAssignedPlannedItems();
        HashMap<Unit, Plan> other$assignedPlannedItems = other.getAssignedPlannedItems();
        if (this$assignedPlannedItems == null ? other$assignedPlannedItems != null : !((Object)this$assignedPlannedItems).equals(other$assignedPlannedItems)) {
            return false;
        }
        HashMap<Base, HashSet<ManagedUnit>> this$gatherersAssignedToBase = this.getGatherersAssignedToBase();
        HashMap<Base, HashSet<ManagedUnit>> other$gatherersAssignedToBase = other.getGatherersAssignedToBase();
        if (this$gatherersAssignedToBase == null ? other$gatherersAssignedToBase != null : !((Object)this$gatherersAssignedToBase).equals(other$gatherersAssignedToBase)) {
            return false;
        }
        HashMap<Base, HashSet<Unit>> this$baseToThreatLookup = this.getBaseToThreatLookup();
        HashMap<Base, HashSet<Unit>> other$baseToThreatLookup = other.getBaseToThreatLookup();
        if (this$baseToThreatLookup == null ? other$baseToThreatLookup != null : !((Object)this$baseToThreatLookup).equals(other$baseToThreatLookup)) {
            return false;
        }
        Opener this$activeOpener = this.getActiveOpener();
        Opener other$activeOpener = other.getActiveOpener();
        if (this$activeOpener == null ? other$activeOpener != null : !this$activeOpener.equals(other$activeOpener)) {
            return false;
        }
        Strategy this$activeStrategy = this.getActiveStrategy();
        Strategy other$activeStrategy = other.getActiveStrategy();
        if (this$activeStrategy == null ? other$activeStrategy != null : !this$activeStrategy.equals(other$activeStrategy)) {
            return false;
        }
        UnitWeights this$unitWeights = this.getUnitWeights();
        UnitWeights other$unitWeights = other.getUnitWeights();
        if (this$unitWeights == null ? other$unitWeights != null : !this$unitWeights.equals(other$unitWeights)) {
            return false;
        }
        UnitTypeCount this$unitTypeCount = this.getUnitTypeCount();
        UnitTypeCount other$unitTypeCount = other.getUnitTypeCount();
        if (this$unitTypeCount == null ? other$unitTypeCount != null : !this$unitTypeCount.equals(other$unitTypeCount)) {
            return false;
        }
        TechProgression this$techProgression = this.getTechProgression();
        TechProgression other$techProgression = other.getTechProgression();
        if (this$techProgression == null ? other$techProgression != null : !((Object)this$techProgression).equals(other$techProgression)) {
            return false;
        }
        ResourceCount this$resourceCount = this.getResourceCount();
        ResourceCount other$resourceCount = other.getResourceCount();
        if (this$resourceCount == null ? other$resourceCount != null : !this$resourceCount.equals(other$resourceCount)) {
            return false;
        }
        BaseData this$baseData = this.getBaseData();
        BaseData other$baseData = other.getBaseData();
        if (this$baseData == null ? other$baseData != null : !this$baseData.equals(other$baseData)) {
            return false;
        }
        GameMap this$gameMap = this.getGameMap();
        GameMap other$gameMap = other.getGameMap();
        return !(this$gameMap == null ? other$gameMap != null : !this$gameMap.equals(other$gameMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GameState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMineralWorkers();
        result = result * 59 + this.getGeyserWorkers();
        result = result * 59 + this.getPlannedSupply();
        result = result * 59 + this.getLarvaDeadlockDetectedFrame();
        result = result * 59 + (this.isEnemyHasCloakedUnits() ? 79 : 97);
        result = result * 59 + (this.isEnemyHasHostileFlyers() ? 79 : 97);
        result = result * 59 + (this.isLarvaDeadlocked() ? 79 : 97);
        result = result * 59 + (this.isAllIn() ? 79 : 97);
        result = result * 59 + (this.isDefensiveSunk() ? 79 : 97);
        Player $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
        BWEM $bwem = this.getBwem();
        result = result * 59 + ($bwem == null ? 43 : $bwem.hashCode());
        Race $opponentRace = this.getOpponentRace();
        result = result * 59 + ($opponentRace == null ? 43 : ((Object)((Object)$opponentRace)).hashCode());
        HashSet<ManagedUnit> $gatherers = this.getGatherers();
        result = result * 59 + ($gatherers == null ? 43 : ((Object)$gatherers).hashCode());
        HashSet<ManagedUnit> $mineralGatherers = this.getMineralGatherers();
        result = result * 59 + ($mineralGatherers == null ? 43 : ((Object)$mineralGatherers).hashCode());
        HashSet<ManagedUnit> $gasGatherers = this.getGasGatherers();
        result = result * 59 + ($gasGatherers == null ? 43 : ((Object)$gasGatherers).hashCode());
        HashMap<Unit, HashSet<ManagedUnit>> $geyserAssignments = this.getGeyserAssignments();
        result = result * 59 + ($geyserAssignments == null ? 43 : ((Object)$geyserAssignments).hashCode());
        HashMap<Unit, HashSet<ManagedUnit>> $mineralAssignments = this.getMineralAssignments();
        result = result * 59 + ($mineralAssignments == null ? 43 : ((Object)$mineralAssignments).hashCode());
        HashSet<ManagedUnit> $larva = this.getLarva();
        result = result * 59 + ($larva == null ? 43 : ((Object)$larva).hashCode());
        HashSet<Plan> $plansScheduled = this.getPlansScheduled();
        result = result * 59 + ($plansScheduled == null ? 43 : ((Object)$plansScheduled).hashCode());
        HashSet<Plan> $plansBuilding = this.getPlansBuilding();
        result = result * 59 + ($plansBuilding == null ? 43 : ((Object)$plansBuilding).hashCode());
        HashSet<Plan> $plansMorphing = this.getPlansMorphing();
        result = result * 59 + ($plansMorphing == null ? 43 : ((Object)$plansMorphing).hashCode());
        HashSet<Plan> $plansComplete = this.getPlansComplete();
        result = result * 59 + ($plansComplete == null ? 43 : ((Object)$plansComplete).hashCode());
        HashSet<Plan> $plansImpossible = this.getPlansImpossible();
        result = result * 59 + ($plansImpossible == null ? 43 : ((Object)$plansImpossible).hashCode());
        HashMap<Unit, Plan> $assignedPlannedItems = this.getAssignedPlannedItems();
        result = result * 59 + ($assignedPlannedItems == null ? 43 : ((Object)$assignedPlannedItems).hashCode());
        HashMap<Base, HashSet<ManagedUnit>> $gatherersAssignedToBase = this.getGatherersAssignedToBase();
        result = result * 59 + ($gatherersAssignedToBase == null ? 43 : ((Object)$gatherersAssignedToBase).hashCode());
        HashMap<Base, HashSet<Unit>> $baseToThreatLookup = this.getBaseToThreatLookup();
        result = result * 59 + ($baseToThreatLookup == null ? 43 : ((Object)$baseToThreatLookup).hashCode());
        Opener $activeOpener = this.getActiveOpener();
        result = result * 59 + ($activeOpener == null ? 43 : $activeOpener.hashCode());
        Strategy $activeStrategy = this.getActiveStrategy();
        result = result * 59 + ($activeStrategy == null ? 43 : $activeStrategy.hashCode());
        UnitWeights $unitWeights = this.getUnitWeights();
        result = result * 59 + ($unitWeights == null ? 43 : $unitWeights.hashCode());
        UnitTypeCount $unitTypeCount = this.getUnitTypeCount();
        result = result * 59 + ($unitTypeCount == null ? 43 : $unitTypeCount.hashCode());
        TechProgression $techProgression = this.getTechProgression();
        result = result * 59 + ($techProgression == null ? 43 : ((Object)$techProgression).hashCode());
        ResourceCount $resourceCount = this.getResourceCount();
        result = result * 59 + ($resourceCount == null ? 43 : $resourceCount.hashCode());
        BaseData $baseData = this.getBaseData();
        result = result * 59 + ($baseData == null ? 43 : $baseData.hashCode());
        GameMap $gameMap = this.getGameMap();
        result = result * 59 + ($gameMap == null ? 43 : $gameMap.hashCode());
        return result;
    }

    public String toString() {
        return "GameState(self=" + this.getSelf() + ", bwem=" + this.getBwem() + ", opponentRace=" + (Object)((Object)this.getOpponentRace()) + ", mineralWorkers=" + this.getMineralWorkers() + ", geyserWorkers=" + this.getGeyserWorkers() + ", plannedSupply=" + this.getPlannedSupply() + ", larvaDeadlockDetectedFrame=" + this.getLarvaDeadlockDetectedFrame() + ", gatherers=" + this.getGatherers() + ", mineralGatherers=" + this.getMineralGatherers() + ", gasGatherers=" + this.getGasGatherers() + ", geyserAssignments=" + this.getGeyserAssignments() + ", mineralAssignments=" + this.getMineralAssignments() + ", larva=" + this.getLarva() + ", enemyHasCloakedUnits=" + this.isEnemyHasCloakedUnits() + ", enemyHasHostileFlyers=" + this.isEnemyHasHostileFlyers() + ", isLarvaDeadlocked=" + this.isLarvaDeadlocked() + ", isAllIn=" + this.isAllIn() + ", plansScheduled=" + this.getPlansScheduled() + ", plansBuilding=" + this.getPlansBuilding() + ", plansMorphing=" + this.getPlansMorphing() + ", plansComplete=" + this.getPlansComplete() + ", plansImpossible=" + this.getPlansImpossible() + ", assignedPlannedItems=" + this.getAssignedPlannedItems() + ", gatherersAssignedToBase=" + this.getGatherersAssignedToBase() + ", baseToThreatLookup=" + this.getBaseToThreatLookup() + ", activeOpener=" + this.getActiveOpener() + ", activeStrategy=" + this.getActiveStrategy() + ", unitWeights=" + this.getUnitWeights() + ", defensiveSunk=" + this.isDefensiveSunk() + ", unitTypeCount=" + this.getUnitTypeCount() + ", techProgression=" + this.getTechProgression() + ", resourceCount=" + this.getResourceCount() + ", baseData=" + this.getBaseData() + ", gameMap=" + this.getGameMap() + ")";
    }
}

