/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.WalkPosition;
import bwem.Area;
import bwem.BWMap;
import bwem.BWMapInitializer;
import bwem.Geyser;
import bwem.Tile;
import java.util.ArrayList;
import java.util.List;

public abstract class Neutral {
    private final Unit bwapiUnit;
    private final Position pos;
    protected TilePosition topLeft;
    private final TilePosition tileSize;
    private final BWMap map;
    private Neutral nextStacked = null;
    private List<WalkPosition> blockedAreas = new ArrayList<WalkPosition>();

    Neutral(Unit unit, BWMap map) {
        this.bwapiUnit = unit;
        this.map = map;
        this.pos = unit.getInitialPosition();
        this.topLeft = unit.getInitialTilePosition();
        this.tileSize = unit.getType().tileSize();
        this.putOnTiles();
    }

    void simulateCPPObjectDestructor() {
        this.removeFromTiles();
        if (this.isBlocking()) {
            BWMapInitializer map = (BWMapInitializer)this.getMap();
            map.onBlockingNeutralDestroyed(this);
        }
    }

    public Unit getUnit() {
        return this.bwapiUnit;
    }

    public Position getCenter() {
        return this.pos;
    }

    public TilePosition getTopLeft() {
        return this.topLeft;
    }

    public TilePosition getBottomRight() {
        return this.topLeft.add(this.tileSize).subtract(new TilePosition(1, 1));
    }

    public TilePosition getSize() {
        return this.tileSize;
    }

    public boolean isBlocking() {
        return !this.blockedAreas.isEmpty();
    }

    void setBlocking(List<WalkPosition> blockedAreas) {
        if (!this.blockedAreas.isEmpty() || blockedAreas.isEmpty()) {
            this.map.asserter.throwIllegalStateException("");
        }
        this.blockedAreas = blockedAreas;
    }

    public List<Area> getBlockedAreas() {
        ArrayList<Area> blockedAreas = new ArrayList<Area>();
        for (WalkPosition w : this.blockedAreas) {
            if (this.getMap().getArea(w) == null) continue;
            blockedAreas.add(this.getMap().getArea(w));
        }
        return blockedAreas;
    }

    public Neutral getNextStacked() {
        return this.nextStacked;
    }

    public Neutral getLastStacked() {
        Neutral topNeutral = this;
        while (topNeutral.getNextStacked() != null) {
            topNeutral = topNeutral.getNextStacked();
        }
        return topNeutral;
    }

    private boolean isSameUnitTypeAs(Neutral neutral) {
        return this.getUnit().getType() == neutral.getUnit().getType();
    }

    private void putOnTiles() {
        if (this.getNextStacked() != null) {
            this.map.asserter.throwIllegalStateException("");
        }
        for (int dy = 0; dy < this.getSize().getY(); ++dy) {
            for (int dx = 0; dx < this.getSize().getX(); ++dx) {
                Tile deltaTile = this.getMap().getData().getTile(this.getTopLeft().add(new TilePosition(dx, dy)));
                if (deltaTile.getNeutral() == null) {
                    deltaTile.addNeutral(this);
                    continue;
                }
                Neutral topNeutral = deltaTile.getNeutral().getLastStacked();
                if (!topNeutral.getTopLeft().equals(this.getTopLeft()) || !topNeutral.getBottomRight().equals(this.getBottomRight())) continue;
                if (this.equals(deltaTile.getNeutral())) {
                    this.map.asserter.throwIllegalStateException("");
                    continue;
                }
                if (this.equals(topNeutral)) {
                    this.map.asserter.throwIllegalStateException("");
                    continue;
                }
                if (topNeutral.getClass().getName().equals(Geyser.class.getName())) {
                    this.map.asserter.throwIllegalStateException("");
                    continue;
                }
                if (!topNeutral.isSameUnitTypeAs(this)) {
                    this.map.asserter.throwIllegalStateException("Stacked Neutral objects have different types: top=" + topNeutral.getClass().getName() + ", this=" + this.getClass().getName());
                    continue;
                }
                if (!topNeutral.getTopLeft().equals(this.getTopLeft())) {
                    this.map.asserter.throwIllegalStateException("Stacked Neutral objects not aligned: top=" + topNeutral.getTopLeft().toString() + ", this=" + this.getTopLeft().toString());
                    continue;
                }
                if (dx != 0 || dy != 0) {
                    this.map.asserter.throwIllegalStateException("");
                    continue;
                }
                topNeutral.nextStacked = this;
                return;
            }
        }
    }

    private void removeFromTiles() {
        for (int dy = 0; dy < this.getSize().getY(); ++dy) {
            for (int dx = 0; dx < this.getSize().getX(); ++dx) {
                Neutral prevStacked;
                Tile tile = this.getMap().getData().getTile(this.getTopLeft().add(new TilePosition(dx, dy)));
                if (tile.getNeutral() == null) {
                    this.map.asserter.throwIllegalStateException("");
                }
                if (tile.getNeutral().equals(this)) {
                    tile.removeNeutral(this);
                    if (this.nextStacked == null) continue;
                    tile.addNeutral(this.nextStacked);
                    continue;
                }
                for (prevStacked = tile.getNeutral(); prevStacked != null && !this.equals(prevStacked.getNextStacked()); prevStacked = prevStacked.getNextStacked()) {
                }
                if (dx != 0 || dy != 0) {
                    this.map.asserter.throwIllegalStateException("");
                }
                if (prevStacked != null) {
                    if (!prevStacked.isSameUnitTypeAs(this) || !prevStacked.getTopLeft().equals(this.getTopLeft())) {
                        this.map.asserter.throwIllegalStateException("");
                    }
                    prevStacked.nextStacked = this.nextStacked;
                }
                this.nextStacked = null;
                return;
            }
        }
        this.nextStacked = null;
    }

    private BWMap getMap() {
        return this.map;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Neutral)) {
            return false;
        }
        Neutral that = (Neutral)object;
        return this.getUnit().getID() == that.getUnit().getID();
    }

    public int hashCode() {
        return this.getUnit().hashCode();
    }
}

