/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Game;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Region
implements Comparable<Region> {
    private final ClientData.RegionData regionData;
    private final Game game;
    private final int id;
    private final int regionGroupID;
    private final Position center;
    private final boolean higherGround;
    private final int defensePriority;
    private final boolean accessible;
    private final int boundsLeft;
    private final int boundsTop;
    private final int boundsRight;
    private final int boundsBottom;
    private Region closestAccessibleRegion;
    private Region closestInaccessibleRegion;
    private List<Region> neighbours;

    Region(ClientData.RegionData regionData, Game game) {
        this.regionData = regionData;
        this.game = game;
        this.id = regionData.getId();
        this.regionGroupID = regionData.islandID();
        this.center = new Position(regionData.getCenter_x(), regionData.getCenter_y());
        this.higherGround = regionData.isHigherGround();
        this.defensePriority = regionData.getPriority();
        this.accessible = regionData.isAccessible();
        this.boundsLeft = regionData.getLeftMost();
        this.boundsTop = regionData.getTopMost();
        this.boundsRight = regionData.getRightMost();
        this.boundsBottom = regionData.getBottomMost();
    }

    void updateNeighbours() {
        int accessibleBestDist = Integer.MAX_VALUE;
        int inaccessibleBestDist = Integer.MAX_VALUE;
        ArrayList<Region> neighbours = new ArrayList<Region>();
        for (int i = 0; i < this.regionData.getNeighborCount(); ++i) {
            Region region = this.game.getRegion(this.regionData.getNeighbors(i));
            neighbours.add(region);
            int d = this.getDistance(region);
            if (region.isAccessible()) {
                if (d >= accessibleBestDist) continue;
                this.closestAccessibleRegion = region;
                accessibleBestDist = d;
                continue;
            }
            if (d >= inaccessibleBestDist) continue;
            this.closestInaccessibleRegion = region;
            inaccessibleBestDist = d;
        }
        this.neighbours = Collections.unmodifiableList(neighbours);
    }

    public int getID() {
        return this.id;
    }

    public int getRegionGroupID() {
        return this.regionGroupID;
    }

    public Position getCenter() {
        return this.center;
    }

    public boolean isHigherGround() {
        return this.higherGround;
    }

    public int getDefensePriority() {
        return this.defensePriority;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public List<Region> getNeighbors() {
        return this.neighbours;
    }

    public int getBoundsLeft() {
        return this.boundsLeft;
    }

    public int getBoundsTop() {
        return this.boundsTop;
    }

    public int getBoundsRight() {
        return this.boundsRight;
    }

    public int getBoundsBottom() {
        return this.boundsBottom;
    }

    public Region getClosestAccessibleRegion() {
        return this.closestAccessibleRegion;
    }

    public Region getClosestInaccessibleRegion() {
        return this.closestInaccessibleRegion;
    }

    public int getDistance(Region other) {
        return this.getCenter().getApproxDistance(other.getCenter());
    }

    public List<Unit> getUnits() {
        return this.getUnits(u -> true);
    }

    public List<Unit> getUnits(UnitFilter pred) {
        return this.game.getUnitsInRectangle(this.getBoundsLeft(), this.getBoundsTop(), this.getBoundsRight(), this.getBoundsBottom(), u -> this.equals(u.getRegion()) && pred.test(u));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.id == region.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Region other) {
        return this.id - other.id;
    }
}

