/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import info.GameState;
import info.UnitTypeCount;
import info.map.GroundPath;
import info.map.MapTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import learning.OpenerRecord;
import learning.OpponentRecord;
import learning.StrategyRecord;
import strategy.openers.Opener;

public class Debug {
    private static int BASE_MINERAL_DISTANCE = 300;
    private BWEM bwem;
    private Game game;
    private Opener opener;
    private OpponentRecord opponentRecord;
    private GameState gameState;

    public Debug(BWEM bwem, Game game, Opener opener, OpponentRecord opponentRecord, GameState gameState) {
        this.bwem = bwem;
        this.game = game;
        this.opener = opener;
        this.opponentRecord = opponentRecord;
        this.gameState = gameState;
    }

    public void onFrame() {
        for (Base b : this.bwem.getMap().getBases()) {
            this.game.drawBoxMap(b.getLocation().toPosition(), b.getLocation().toPosition().add(new Position(127, 95)), Color.Blue);
        }
        this.game.drawTextScreen(4, 8, "Opponent: " + this.opponentRecord.getName() + " " + this.getOpponentRecord(), new Text[0]);
        this.game.drawTextScreen(4, 16, "GameMap: " + this.game.mapFileName(), new Text[0]);
        this.game.drawTextScreen(4, 24, "Opener: " + this.opener.getNameString() + " " + this.getOpenerRecord(), Text.White);
        this.game.drawTextScreen(4, 32, "Strategy: " + this.gameState.getActiveStrategy().getName() + " " + this.getStrategyRecord(), Text.White);
        this.game.drawTextScreen(4, 40, "Frame: " + this.game.getFrameCount(), new Text[0]);
        this.drawUnitCount();
        this.drawBases();
    }

    private void drawUnitCount() {
        int x = 4;
        int y = 128;
        this.game.drawTextScreen(x, y, "Unit Count", new Text[0]);
        UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
        for (Map.Entry<UnitType, Integer> entry : unitTypeCount.getCountLookup().entrySet()) {
            this.game.drawTextScreen(x, y += 8, entry.getKey().toString() + ": " + entry.getValue().toString(), new Text[0]);
        }
    }

    private void drawBases() {
        for (Unit u : this.gameState.getBaseData().baseHatcheries()) {
            this.game.drawCircleMap(u.getPosition(), BASE_MINERAL_DISTANCE, Color.Teal);
        }
    }

    private String getOpenerRecord() {
        OpenerRecord openerRecord = this.opponentRecord.getOpenerRecord().get(this.opener.getNameString());
        return String.format("%s_%s", openerRecord.getWins(), openerRecord.getLosses());
    }

    private String getOpponentRecord() {
        return String.format("%s_%s", this.opponentRecord.getWins(), this.opponentRecord.getLosses());
    }

    private String getStrategyRecord() {
        StrategyRecord strategyRecord = this.opponentRecord.getStrategyRecordMap().get(this.gameState.getActiveStrategy().getName());
        return String.format("%s_%s", strategyRecord.getWins(), strategyRecord.getLosses());
    }

    private void drawAllBasePaths() {
        HashMap<Base, GroundPath> pathMap = this.gameState.getBaseData().getBasePaths();
        for (GroundPath path : pathMap.values()) {
            this.drawPath(path.getPath());
        }
    }

    private void drawPath(List<MapTile> tiles) {
        for (MapTile tile : tiles) {
            TilePosition tp = tile.getTile();
            this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.Yellow);
        }
    }

    private void debugGameMap() {
        for (MapTile mapTile : this.gameState.getGameMap().getHeatMap()) {
            this.game.drawTextMap(mapTile.getTile().getX() * 32 + 8, mapTile.getTile().getY() * 32 + 8, String.valueOf(mapTile.isBuildable()), Text.White);
        }
    }
}

