/*
 * Decompiled with CFR 0.152.
 */
import bwapi.BWClient;
import bwapi.DefaultBWListener;
import bwapi.Game;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import info.GameState;
import info.InformationManager;
import learning.Decisions;
import learning.LearningManager;
import learning.OpponentRecord;
import macro.ProductionManager;
import unit.UnitManager;

public class Bot
extends DefaultBWListener {
    private BWEM bwem;
    private BWClient bwClient;
    private Game game;
    private GameState gameState;
    private Debug debugMap;
    private LearningManager learningManager;
    private ProductionManager economyModule;
    private InformationManager informationManager;
    private UnitManager unitManager;

    @Override
    public void onStart() {
        this.game = this.bwClient.getGame();
        this.bwem = new BWEM(this.game);
        this.bwem.initialize();
        Race opponentRace = this.game.enemy().getRace();
        this.gameState = new GameState(this.game.self(), this.bwem);
        this.learningManager = new LearningManager(opponentRace, this.game.enemy().getName(), this.bwem);
        Decisions decisions = this.learningManager.getDecisions();
        this.gameState.onStart(decisions, opponentRace);
        OpponentRecord opponentRecord = this.learningManager.getOpponentRecord();
        this.informationManager = new InformationManager(this.bwem, this.game, this.gameState);
        this.debugMap = new Debug(this.bwem, this.game, decisions.getOpener(), opponentRecord, this.gameState);
        this.economyModule = new ProductionManager(this.game, this.gameState, decisions.getOpener().getBuildOrder());
        this.unitManager = new UnitManager(this.game, this.informationManager, this.bwem, this.gameState);
    }

    @Override
    public void onFrame() {
        if (this.bwem == null) {
            System.out.print("bwem is null\n");
            return;
        }
        this.informationManager.onFrame();
        this.economyModule.onFrame();
        this.unitManager.onFrame();
        this.debugMap.onFrame();
    }

    @Override
    public void onUnitHide(Unit unit) {
        this.informationManager.onUnitHide(unit);
    }

    @Override
    public void onUnitShow(Unit unit) {
        this.informationManager.onUnitShow(unit);
        this.unitManager.onUnitShow(unit);
    }

    @Override
    public void onUnitComplete(Unit unit) {
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        if (unit.getType() == UnitType.Zerg_Larva) {
            return;
        }
        this.informationManager.onUnitComplete(unit);
        this.economyModule.onUnitComplete(unit);
        this.unitManager.onUnitComplete(unit);
    }

    @Override
    public void onUnitDestroy(Unit unit) {
        this.informationManager.onUnitDestroy(unit);
        if (!unit.getType().isResourceContainer() && unit.getPlayer() != this.game.self()) {
            return;
        }
        this.economyModule.onUnitDestroy(unit);
        this.unitManager.onUnitDestroy(unit);
    }

    @Override
    public void onUnitRenegade(Unit unit) {
        this.informationManager.onUnitRenegade(unit);
        this.economyModule.onUnitRenegade(unit);
    }

    @Override
    public void onUnitMorph(Unit unit) {
        this.informationManager.onUnitMorph(unit);
        this.economyModule.onUnitMorph(unit);
        this.unitManager.onUnitMorph(unit);
    }

    @Override
    public void onEnd(boolean isWinner) {
        this.learningManager.onEnd(isWinner);
    }

    public static void main(String[] args) {
        Bot bot = new Bot();
        bot.bwClient = new BWClient(bot);
        bot.bwClient.startGame();
    }
}

