package Tactic.Tactics

import Lifecycle.With
import Mathematics.Maff
import Mathematics.Shapes.Circle
import Micro.Agency.Intention
import Planning.Predicates.MacroFacts
import Planning.ResourceLocks.LockUnits
import Utilities.UnitCounters.CountEverything
import ProxyBwapi.Races.Zerg
import ProxyBwapi.UnitInfo.FriendlyUnitInfo

class ChillOverlords extends Tactic {
  
  val overlords = new LockUnits(this)
  overlords.matcher = Zerg.Overlord
  overlords.counter = CountEverything

  def launch() {
    if ( ! With.self.isZerg) return
    if (With.self.hasUpgrade(Zerg.OverlordSpeed)) return
    if (MacroFacts.enemyShownCloakedThreat) return

    overlords.acquire()
    overlords.units.foreach(chillOut(_, overlords.units.size))
  }
  
  private def chillOut(overlord: FriendlyUnitInfo, count: Int) {
    val base = Maff.minBy(With.geography.ourBases.map(_.heart.center))(overlord.pixelDistanceSquared)
    val tile = base.map(b => Maff.sample(Circle(Math.sqrt(count).toInt).map(b.tile.add))).getOrElse(With.geography.home)
    overlord.intend(this, new Intention { toTravel = Some(tile.center) })
  }
}
