struct Result
{
	std::string timestamp;
	int start_positions;
	std::string map;
	std::string strategy;
	double duration;
	bool is_win;
	std::string opponent_strategy;
};

class ResultStore : public Singleton<ResultStore>
{
public:
	void init();
	std::string pick_strategy(std::vector<std::string> strategies);
	void apply_result(const std::string& strategy,const std::string& opponent_strategy,bool win);
	void store();
	
private:
	static constexpr char* kComputerPlayerName = "Computer";
	static constexpr double kDecayFactor = 40.0;
	static constexpr double kDecayFactorTournament = 3.0;
	static constexpr double kTargetWinRate = 0.8;
	static constexpr double kPriorGames = 1.5;
	
	char ai_filename_[512];
	char read_filename_[512];
	char write_filename_[512];
	
	std::vector<Result> prepared_results_;
	std::vector<Result> results_;
	
	void init_filenames();
	void read_file();
	void read_prepared_results();
	void read_results();
	static void read_file(FILE *f,std::vector<Result>& results);
	
	std::string pick_strategy_greedy(const std::vector<std::string>& strategies);
	std::string pick_strategy_ucb1(const std::vector<std::string>& strategies);
	static std::string pick_at_random(const std::vector<std::string>& strategies);
	
	static std::string determine_name();
	static int determine_start_positions();
	static std::string determine_map_name();
	static double determine_duration();
};
