#pragma once
#include <BWAPI.h>
#include "WillytBuild.h"
#include "WillytMap.h"
#include "WillytState.h"
#include "WillytEnemy.h"
#include "WillyThreat.h"
#include "Utilities.h"
#include "MapUtilities.h"
#include "MicroUtilities.h"

//2018-03-08: SCV class, first single unit object

class SCV
{
public:

	//general

	SCV(BWAPI::Unit my_unit);
	BWAPI::Unit unit;
	unsigned id;

	//states

	bool is_miner;
	bool is_builder;
	bool is_militia;
	bool is_janitor;
	bool is_repair;
	bool is_scout;
	int prio_transport;
	BWAPI::Position destination;
	
	//methods

	void update();
	void move(BWAPI::Position p);
	void set_attack(BWAPI::Position p);
	void set_swarm(bool immediately);
	void gather(BWAPI::Unit u);
	void set_build_mission(BWAPI::UnitType type, BWAPI::TilePosition &tile);
	void end_build_mission();
	void set_repair_mission(BWAPI::Unit my_unit);

private:

	//private methods

	void mine();
	void update_militia();
	void build();
	void update_repair();
	void check_transport();
	BWAPI::Unit get_target_scv(int r);

	//positions and integers

	BWAPI::Position secure_pos;
	BWAPI::Position attack_pos;

	BWAPI::UnitType build_type;
	BWAPI::Position build_pos;
	BWAPI::TilePosition build_tile;
	int build_queue;
	int build_sqdist;
	int block_count;
	int x0;
	int y0;
	int x1;
	int y1;
	BWAPI::Unit damaged_unit;

	//building auxiliaries

	bool started_construction();
	std::vector<BWAPI::Unit> get_blockers();
	void clear_build_tiles(std::vector<BWAPI::Unit> &my_vec);
	void check_build_block(std::vector<BWAPI::Unit> &my_vec);
	void draw_build_info();
};