#include "SCV.h"

SCV::SCV(BWAPI::Unit my_unit) {
	unit = my_unit;
	id = my_unit->getID();

	is_miner = false;
	is_militia = false;
	is_builder = false;
	is_janitor = false;
	is_repair = false;
	is_scout = false;

	secure_pos = willyt::retreat_pos;
	attack_pos = willyt::gather_pos;

	build_type = BWAPI::UnitTypes::None;
	build_pos = BWAPI::Positions::None;
	build_tile = BWAPI::TilePositions::None;
	build_sqdist = 0;
	build_queue = 0;
	block_count = 0;
	x0 = 0; y0 = 0;
	x1 = 0; y1 = 0;
	damaged_unit = NULL;

	prio_transport = 0;
	destination = BWAPI::Positions::None;
	return;
}



void SCV::update() {
	if (!unit->exists() ||
		unit->isLockedDown() || unit->isMaelstrommed() ||
		unit->isStasised() || unit->getTransport() != NULL) {
		return;
	}
	if (is_builder) {
		build();
	}
	else if(is_repair) {
		update_repair();
	}
	else if (is_militia) {
		update_militia();
	}
	else if (unit->isIdle()) {
		mine();
	}
	if (!unit->isConstructing() &&
		!unit->isGatheringMinerals() &&
		!unit->isGatheringGas()) {
		check_transport();
	}
	return;
}



void SCV::move(BWAPI::Position p) {
	unit->move(p);
	//destination = p;
	return;
}
void SCV::set_attack(BWAPI::Position p) {
	attack_pos = p;
	//destination = p;
	return;
}
void SCV::set_swarm(bool immediately) {
	if (immediately || unit->isIdle())
		set_attack(get_random_position());
	return;
}
void SCV::gather(BWAPI::Unit u) {
	unit->gather(u, false);
	//destination = u->getPosition();
	return;
}



void SCV::mine() {
	BWAPI::Unit my_min = NULL;
	if (!wilbuild::minerals.empty() && BWAPI::Broodwar->getFrameCount() < 4800) {
		my_min = wilbuild::minerals.at(id % wilbuild::minerals.size());
	}
	else if (!wilbuild::minerals.empty()) {
		if (BWAPI::Broodwar->getFrameCount() % 2 == 1) {
			my_min = get_closest(wilbuild::mainland_minerals, unit->getPosition());
		} else {
			my_min = get_closest(wilbuild::minerals, unit->getPosition());
		}
	}
	else if (!wilbuild::all_minerals.empty()) {
		my_min = get_closest(wilbuild::all_minerals, unit->getPosition());
	}
	if (my_min != NULL &&
		unit->canGather(my_min)) {
		if (!has_grd_connection(unit->getPosition(), my_min->getPosition())) {
			move(my_min->getPosition());
		} else {
			gather(my_min);
		}
		is_miner = true;
	}
	//BWAPI::Broodwar->drawTextMap(unit->getPosition(), "start mining");
	return;
}



void SCV::update_militia() {
	BWAPI::Position my_pos = unit->getPosition();
	if (unit->isStartingAttack() || unit->isAttackFrame() ||
		unit->isRepairing() ||
		BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() <= 10) {
		return;
	}
	if ((willyt::avoid_grddef && reaching_area(unit, wilthr::grddef)) ||
		reaching_area(unit, wilthr::grdmap)) {
		unit->move(secure_pos);
		draw_arrow(my_pos, secure_pos, BWAPI::Colors::Green);
		return;
	}
	BWAPI::Unit my_target = get_target_scv(16384);
	if (my_target != NULL &&
		my_target->exists()) {
		unit->attack(my_target);
		draw_arrow(my_pos, my_target->getPosition(), BWAPI::Colors::Red);
	} else if (sqdist(my_pos, attack_pos) > 16384) {
		unit->move(attack_pos);
		draw_arrow(my_pos, attack_pos, BWAPI::Colors::Yellow);
	}
	return;
}



void SCV::set_build_mission(BWAPI::UnitType type, BWAPI::TilePosition &tile) {
	is_miner = false;
	is_builder = true;
	build_type = type;
	build_tile = tile;

	x0 = 32 * tile.x;
	y0 = 32 * tile.y;
	x1 = x0 + 32 * build_type.tileWidth() - 1;
	y1 = y0 + 32 * build_type.tileHeight() - 1;

	build_pos = BWAPI::Position((x0 + x1) / 2, (y0 + y1) / 2);
	build_queue = 128 + 4 * unit->getPosition().getApproxDistance(build_pos);
	build_sqdist = 2304;
	if (type == BWAPI::UnitTypes::Terran_Missile_Turret) { build_queue += 8192; }
	if (type == BWAPI::UnitTypes::Terran_Refinery) { build_sqdist = 9216; }
	block_count = 0;
	wilbuild::planned_builds.push_back(type);
	//BWAPI::Broodwar->printf("SCV build queue: %d", build_queue);
	return;
}
void SCV::end_build_mission() {
	vector_remove(wilbuild::planned_builds, build_type);
	is_builder = false;
	is_janitor = false;
	build_type = BWAPI::UnitTypes::None;
	build_tile = BWAPI::TilePositions::None;
	build_pos = BWAPI::Positions::None;
	build_queue = 0;
	block_count = 0;
	return;
}



void SCV::build() {
	if (build_queue > 128) {
		if (unit->isUnderAttack() ||
			started_construction()) {
			build_queue = 128;
		}
		if (sqdist(unit->getPosition(), build_pos) > build_sqdist &&
			!is_janitor) {
			unit->move(build_pos);
			build_queue -= 1;
			//destination = build_pos;
		}
		else {
			std::vector<BWAPI::Unit> my_blockers = get_blockers();
			clear_build_tiles(my_blockers);
			check_build_block(my_blockers);
			if (is_janitor) {
				build_queue -= 1;
			} else {
				unit->build(build_type, build_tile);
				build_queue -= 8;
			}
			//destination = build_pos;
		}
	}
	else if (build_queue > 0) {
		build_queue -= 1;
		if (build_queue < 96 &&
			!unit->isConstructing()) {
			end_build_mission();
			//BWAPI::Broodwar->printf("SCV abort build mission");
		}
	}
	else {
		end_build_mission();
	}
	draw_build_info();
	return;
}
bool SCV::started_construction() {
	for (BWAPI::Unit u : wilbuild::buildings) {
		if (build_type == u->getType() &&
			build_tile == u->getTilePosition()) {
			return true;
		}
	}
	return false;
}
std::vector<BWAPI::Unit> SCV::get_blockers() {
	std::vector<BWAPI::Unit> v;
	for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsInRectangle(x0, y0, x1, y1)) {
		if (u != unit &&
			!u->isFlying() &&
			!u->getType().isBuilding()) {
			v.push_back(u);
		}
	}
	if (build_type == BWAPI::UnitTypes::Terran_Command_Center) {
		for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsInRectangle(x0 - 96, y0 - 96, x1 + 96, y1 + 96)) {
			if (u->getType().isMineralField() &&
				u->getResources() <= 8) {
				v.push_back(u);
			}
		}
	}
	return v;
}
void SCV::clear_build_tiles(std::vector<BWAPI::Unit> &my_vec) {
	int dx = 0;
	int dy = 0;
	switch ( (BWAPI::Broodwar->getFrameCount() * 128) % 4 ) {
		case 0: dx = +128;
		case 1: dy = +128;
		case 2: dx = -128;
		case 3: dy = -128;
	}
	for (BWAPI::Unit blocker : my_vec) {
		if (blocker->getPlayer() == BWAPI::Broodwar->self()) {
			int x = blocker->getPosition().x + dx;
			int y = blocker->getPosition().y + dy;
			blocker->move(BWAPI::Position(x, y));
		}
		if (blocker->getType().isMineralField() &&
			blocker->getResources() <= 8) {
			if (!unit->isGatheringMinerals()) {
				unit->gather(blocker);
				//BWAPI::Broodwar->printf("clear blocking mineral");
			}
			is_janitor = true;
			return;
		}
		if (blocker->isBurrowed()) {
			if (!unit->isAttacking()) {
				unit->attack(blocker);
				//BWAPI::Broodwar->printf("clear blocking enemy");
			}
			is_janitor = true;
			return;
		}
	}
	is_janitor = false;
	return;
}
void SCV::check_build_block(std::vector<BWAPI::Unit> &my_vec) {
	if (BWAPI::Broodwar->self()->minerals() >= build_type.mineralPrice()  &&
		BWAPI::Broodwar->self()->gas() >= build_type.gasPrice() &&
		unit->canBuild(build_type) &&
		my_vec.empty() &&
		!BWAPI::Broodwar->hasCreep(build_tile)) {
		++block_count;
	}
	if (block_count > 16) {
		wilbuild::blocked_tile = build_tile;
		//BWAPI::Broodwar->printf("Building site blocked by something!");
	}
	return;
}
void SCV::draw_build_info() {
	BWAPI::Broodwar->drawBoxMap(x0, y0, x1, y1, 179, false);
	BWAPI::Broodwar->drawTextMap((BWAPI::Position)build_tile, build_type.c_str());
	BWAPI::Broodwar->drawTextMap(unit->getPosition(), "%d", build_queue);
	//BWAPI::Broodwar->drawLineMap(unit->getPosition(), build_pos, 179);
	return;
}



void SCV::set_repair_mission(BWAPI::Unit my_unit) {
	is_repair = true;
	damaged_unit = my_unit;
	unit->repair(my_unit);
	return;
}
void SCV::update_repair() {
	if (damaged_unit->exists() == false ||
		damaged_unit->getHitPoints() == damaged_unit->getType().maxHitPoints() ||
		(BWAPI::Broodwar->self()->minerals() == 0 && sqdist(unit, damaged_unit) <= 9216)) {
		if (!willyt::hold_bunker) { is_repair = false; }
	}
	if (BWAPI::Broodwar->getFrameCount() - unit->getLastCommandFrame() >= 24 &&
		!unit->isRepairing() &&
		damaged_unit->exists() &&
		damaged_unit->getHitPoints() < damaged_unit->getType().maxHitPoints()) {
		unit->repair(damaged_unit);
	}
	draw_arrow(unit->getPosition(), damaged_unit->getPosition(), BWAPI::Colors::Orange);
	return;
}



void SCV::check_transport() {
	BWAPI::Position p0 = unit->getPosition();
	BWAPI::Position p1;
	if (unit->getTargetPosition().isValid()) { p1 = unit->getTargetPosition(); }
	if (unit->getTarget() != NULL) { p1 = unit->getTarget()->getPosition(); }
	if (!p0.isValid() || !p1.isValid()) { return; }

	if (unit->getTransport() == NULL && !has_grd_connection(p0, p1)) {
		prio_transport++;
	} else {
		prio_transport = 0;
	}
	destination = p1;
	//BWAPI::Broodwar->drawLineMap(p0, p1, BWAPI::Colors::Orange);
	return;
}
BWAPI::Unit SCV::get_target_scv(int r) {
	BWAPI::Unit u = NULL;
	u = get_target_from(wilenemy::tlgg, u, unit->getPosition(), r);
	u = get_target_from(wilenemy::tlga, u, unit->getPosition(), r);
	u = get_target_from(wilenemy::tlg, u, unit->getPosition(), r);
	return u;
}