#include "RaidManager.h"


void RaidManager::update() {
	willyt::go_raiding = evaluate_raiding();
	if (dropship == NULL) {
		if (!wilunits::dropships.empty() &&
			willyt::go_raiding) {
			init();
		}
		return;
	}
	if (!check_raiders()) {
		end();
		return;
	}
	if (state == "load") {
		if (!all_on_board()) {
			load_raiders();
		} else {
			fly_to_next_expo();
			state = "move";
		}
	}
	if (state == "move" && raid_dropship_near(next_pos, 8)) {
		if (enemy_workers_near(next_pos)) {
			dropship->unit->unloadAll();
			state = "raid";
		}
		else if (raid_dropship_near(next_pos, 2) && all_on_board()) {
			fly_to_next_expo();
		}
	}
	if (state == "raid") {
		if (enemy_workers_near(next_pos)) {
			attack_raiders();
		} else {
			load_raiders();
			state = "load";

		}
	}
	BWAPI::Broodwar->drawTextMap(dropship->unit->getPosition(), state.c_str());
	draw_raiders();
	return;
}
void RaidManager::init() {
	dropship = & wilunits::dropships.front();
	dropship->is_raider = true;

	ci = get_expo_index(dropship->unit->getPosition());
	di = ((rand() % 2) * 2) - 1;
	last_pos = wilmap::my_main;

	raiders.clear();
	if (willyt::go_bio) {
		assign_from(wilunits::marines, 4);
		assign_from(wilunits::firebats, 2);
		assign_from(wilunits::medics, 2);
	} else {
		assign_from(wilunits::vultures, 4);
	}
	load_raiders();
	state = "load";
	BWAPI::Broodwar->printf("initialize raid");
	return;
}
void RaidManager::end() {
	for (Fighter2* f : raiders) {
		f->set_raider(false);
		f->set_secure(willyt::gather_pos);
	}
	raiders.clear();
	dropship->is_raider = false;
	dropship = NULL;
	BWAPI::Broodwar->printf("terminate raid");
	return;
}
bool RaidManager::evaluate_raiding() {
	//how many units do we have?
	//where is the enemy army?
	//how may enemy expansions do we know of?
	//how are they fortified?
	return false;
}


void RaidManager::assign_from(std::vector<Fighter2>& my_vec, unsigned i) {
	std::vector<Fighter2>::iterator it = my_vec.begin();
	while (i > 0 && it != my_vec.end()) {
		it->set_raider(true);
		raiders.push_back(&(*it));
		i--;
		it++;
	}
	return;
}
bool RaidManager::check_raiders() {
	std::vector<Fighter2*>::iterator it = raiders.begin();
	while (it != raiders.end()) {
		if (!(*it)->unit->exists()) {
			raiders.erase(it);
		}
		else { it++; }
	}
	if (dropship->unit->exists() && raiders.size() > 0) {
		return true;
	}
	return false;
}
void RaidManager::attack_raiders() {
	for (Fighter2* f : raiders) {
		f->set_target(next_pos);
		f->set_secure(next_pos);
	}
	return;
}


void RaidManager::load_raiders() {
	for (Fighter2* f : raiders)
		if (!f->unit->isLoaded())
			f->set_load(dropship->unit);
	return;
}
bool RaidManager::all_on_board() {
	for (Fighter2* f : raiders)
		if (!f->unit->isLoaded())
			return false;
	return true;
}


int RaidManager::get_expo_index(BWAPI::Position praid) {
	BWAPI::Position pexpo = get_closest(wilmap::aircircle, praid);
	for (unsigned i = 0; i < wilmap::aircircle.size(); i++)
		if (wilmap::aircircle[i] == pexpo)
			return (int)i;
	return 0;
}
void RaidManager::fly_to_next_expo() {
	last_pos = wilmap::flycircle.at(ci % wilmap::flycircle.size());
	ci += di;
	next_pos = wilmap::flycircle.at(ci % wilmap::flycircle.size());
	dropship->unit->move(next_pos);
	return;
}
bool RaidManager::raid_dropship_near(BWAPI::Position my_pos, int s) {
	if (dist(dropship->unit->getPosition(), my_pos) < (s * 32))
		return true;
	return false;
}
bool RaidManager::enemy_workers_near(BWAPI::Position my_pos) {
	for (BWAPI::Player p : BWAPI::Broodwar->enemies())
		for (BWAPI::Unit u : p->getUnits())
			if (u->getType().isWorker() &&
				sqdist(u->getPosition(), my_pos) < 65536)
				return true;
	return false;
}
bool RaidManager::enemy_buildings_near(BWAPI::Position my_pos) {
	for (BWAPI::Player p : BWAPI::Broodwar->enemies())
		for (BWAPI::Unit u : p->getUnits())
			if (u->getType().isBuilding() &&
				sqdist(u->getPosition(), my_pos) < 65536)
				return true;
	return false;
}


void RaidManager::draw_raiders() {
	for (Fighter2* f : raiders)
		if (!f->unit->isLoaded())
			BWAPI::Broodwar->drawLineMap(f->unit->getPosition(), dropship->unit->getPosition(), 135);
	return;
}