#include "MiningManager.h"

void MiningManager::update() {
	check_gas();
	check_min();
}


void MiningManager::check_gas() {
	if (wilbuild::refineries.empty() ||
		!wilbuild::refineries.back()->isCompleted()) {
		return;
	}
	int t = BWAPI::Broodwar->elapsedTime();
	int g = BWAPI::Broodwar->self()->gas();
	int m = BWAPI::Broodwar->self()->minerals();
	unsigned i = 0;
	for (Expo &my_expo : wilexpo::all) {
		i += my_expo.gas_miners.size();
	}
	if (i < 3 * wilbuild::refineries.size()) {
		if (g < t / 4 ||
			g < m / 4) {
			append_gas_miner();
		}
	}
	if (willyt::strategy == 1 &&
		i > 0 &&
		g > m &&
		g > t - 300) {
		remove_gas_miner(0);
	}
	if (willyt::strategy == 3 &&
		BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Tank_Siege_Mode) &&
		i > 0 &&
		g > m &&
		g > t) {
		remove_gas_miner(0);
	}
	if (willyt::strategy == 6 &&
		BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Yamato_Gun) &&
		i > 0 &&
		g > m &&
		g > t) {
		remove_gas_miner(0);
	}
	remove_gas_miner(3);
	return;
}
void MiningManager::start_gas_mining(BWAPI::Unit my_refinery) {
	append_gas_miner();
	return;
}


void MiningManager::append_gas_miner() {
	for (Expo &expo : wilexpo::all) {
		for (BWAPI::Unit &geys : expo.geysers) {
			if (geys->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ||
				geys->isBeingGathered()) {
				continue;
			}
			for (SCV &scv : expo.min_miners) {
				if (scv.unit->isGatheringMinerals() &&
					!scv.unit->isCarryingMinerals()) {
					scv.gather(geys);
					//BWAPI::Broodwar->printf("append scv to gas");
					return;
				}
			}
		}
	}
	return;
}
void MiningManager::remove_gas_miner(int factor) {
	for (Expo &expo : wilexpo::all) {
		if (expo.gas_miners.size() > factor * expo.geysers.size() &&
			expo.gas_miners.front().unit->isCarryingGas() == false) {
			expo.gas_miners.front().unit->stop();
			//BWAPI::Broodwar->printf("remove scv from gas");
			return;
		}
	}
	return;
}


void MiningManager::check_min() {
	std::vector<Expo>::iterator it_over = get_oversaturated_expo();
	std::vector<Expo>::iterator it_undr = get_undrsaturated_expo();
	if (it_over != wilexpo::all.end() &&
		it_undr != wilexpo::all.end()) {
		if (it_over->is_island || it_undr->is_island) {
			it_over->min_miners.front().move(it_undr->posi);
		} else {
			it_over->min_miners.front().gather(it_undr->minerals.front());
		}
		//BWAPI::Broodwar->printf("transfer miner");
	}
}


std::vector<Expo>::iterator MiningManager::get_oversaturated_expo() {
	std::vector<Expo>::iterator it_max = wilexpo::all.end();
	int dn_max = 0;
	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		it->is_oversaturated = false;
		int dn = (it->min_miners.size() - 1) - 2 * it->minerals.size();
		if (it->is_owned &&
			dn > dn_max) {
			dn_max = dn;
			it_max = it;
		}
	}
	if (it_max != wilexpo::all.end()) {
		it_max->is_oversaturated = true;
	}
	return it_max;
}
std::vector<Expo>::iterator MiningManager::get_undrsaturated_expo() {
	std::vector<Expo>::iterator it_max = wilexpo::all.end();
	int dn_max = 0;
	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		it->is_undrsaturated = false;
		int dn = (it->min_miners.size() + 1) - 2 * it->minerals.size();
		if (it->is_owned &&
			dn < dn_max) {
			dn_max = dn;
			it_max = it;
		}
	}
	if (it_max != wilexpo::all.end()) {
		it_max->is_undrsaturated = true;
	}
	return it_max;
}


void MiningManager::check_gather() {
	//for (BWAPI::Unit min : wilbuild::minerals) {
	//	if (min->isBeingGathered()) {
	//		BWAPI::Broodwar->drawCircleMap(min->getPosition(), 8, BWAPI::Colors::Purple, true);
	//	} else {
	//		BWAPI::Broodwar->drawCircleMap(min->getPosition(), 8, BWAPI::Colors::Cyan, true);
	//	}
	//}
	//for (std::vector<SCV>::iterator it = wilunits::scvs.begin(); it != wilunits::scvs.end(); ++it) {
	//	BWAPI::Unit u = it->unit->getOrderTarget();
	//	if (it->is_miner == false && u != NULL && u->getType().isResourceContainer()) {
	//		it->is_miner = true;
	//		BWAPI::Broodwar->drawLineMap(it->unit->getPosition(), u->getPosition(), BWAPI::Colors::White);
	//		BWAPI::Broodwar->drawTextMap(it->unit->getPosition(), "append miner");
	//	}
	//	if ((it->is_miner == true && u == NULL) ||
	//		(it->is_miner == true && !u->getType().isResourceContainer() && !u->getType().isResourceDepot())) {
	//		it->is_miner = false;
	//		BWAPI::Broodwar->drawTextMap(it->unit->getPosition(), "remove miner");
	//	}
	//}
	return;
}