#include "Grouper.h"

namespace wilgroup
{
	std::vector<int> maxsqdist_vec = { 1048576 , 262144 , 65536 };
	std::vector<BWAPI::Unit> player_army = {};
	std::vector<BWAPI::Unit> enemy_army = {};
	BWAPI::Position player_army_pos = BWAPI::Positions::None;
	BWAPI::Position enemy_army_pos = BWAPI::Positions::None;
	int player_army_supply = 0;
	int enemy_army_supply = 0;
}

void update_army_groups() {
	using namespace wilgroup;
	player_army.clear();
	enemy_army.clear();
	BWAPI::Position last_pos = enemy_army_pos;

	//determine player army group

	for (BWAPI::Unit u : BWAPI::Broodwar->self()->getUnits()) {
		if (!u->getType().isBuilding() &&
			!u->getType().isWorker() &&
			!u->getType().isFlyer() &&
			u->getType().supplyRequired() != 0 &&
			u->isCompleted()) {
			player_army.push_back(u);
		}
	}
	if (!player_army.empty()) {
		for (int maxsqdist : maxsqdist_vec) {
			player_army_pos = calculate_center_pos(player_army);
			player_army = reduce_army_group(player_army, player_army_pos, maxsqdist);
		}
	}
	player_army_pos = calculate_center_pos(player_army);
	player_army_supply = calculate_army_supply(player_army);

	//determine enemy army group

	for (BWAPI::Player p : BWAPI::Broodwar->enemies()) {
		for (BWAPI::Unit u : p->getUnits()) {
			if (!u->getType().isBuilding() &&
				!u->getType().isWorker() &&
				!u->getType().isFlyer() &&
				u->getType().supplyRequired() != 0 &&
				u->isCompleted()) {
				enemy_army.push_back(u);
			}
		}
	}
	if (!enemy_army.empty()) {
		for (int maxsqdist : maxsqdist_vec) {
			enemy_army_pos = calculate_center_pos(enemy_army);
			enemy_army = reduce_army_group(enemy_army, enemy_army_pos, maxsqdist);
		}
	}
	enemy_army_pos = calculate_center_pos(enemy_army);
	enemy_army_supply = calculate_army_supply(enemy_army);

	if (enemy_army_pos == BWAPI::Positions::None) {
		enemy_army_pos = last_pos;
	}

	return;
}

BWAPI::Position calculate_center_pos(std::vector<BWAPI::Unit>& my_vec) {
	int s = 0;
	int x = 0;
	int y = 0;
	for (BWAPI::Unit u : my_vec) {
		x += (u->getType().supplyRequired() * u->getPosition().x);
		y += (u->getType().supplyRequired() * u->getPosition().y);
		s += u->getType().supplyRequired();
	}
	if (s != 0) { return BWAPI::Position( x/s , y/s ); }
	return BWAPI::Positions::None;
}

std::vector<BWAPI::Unit> reduce_army_group(std::vector<BWAPI::Unit>& old_vec, BWAPI::Position& my_pos, int& maxsqdist) {
	std::vector<BWAPI::Unit> new_vec = {};
	for (BWAPI::Unit u : old_vec) {
		if (sqdist(u->getPosition(), my_pos) < maxsqdist) {
			new_vec.push_back(u);
		}
	}
	return new_vec;
}

int calculate_army_supply(std::vector<BWAPI::Unit>& my_vec) {
	int s = 0;
	for (BWAPI::Unit u : my_vec) {
		s += u->getType().supplyRequired();
	}
	return s;
}