#include "Flyer.h"


Flyer::Flyer(BWAPI::Unit my_unit) {
	unit = my_unit;
	id = my_unit->getID();
	attack_pos = willyt::gather_pos;
	retreat_pos = willyt::retreat_pos;
	ability_pos = willyt::retreat_pos;
	command_queue = 0;
	retreat_queue = 0;
	ability_queue = 0;
	is_circling = false;
	is_swarming = false;
	is_raider = false;
	ability_target = NULL;
	attack_target = NULL;
	transport_pos = willyt::retreat_pos;

	ic = 0;
	dc = ((rand() % 2) * 2) - 1;
	im = (int)wilmap::aircircle.size();
	for (unsigned i = 0; i < wilmap::aircircle.size(); i++) {
		if (wilmap::aircircle.at(i) == wilmap::my_natu) { ic = (int)i; }
	}
}



//methods

void Flyer::attack() {
	unit->attack(attack_pos);
	command_queue = 128;
	return;
}

void Flyer::swarm(bool immediately) {
	if (immediately || unit->isIdle()) {
		int x = rand() % BWAPI::Broodwar->mapWidth();
		int y = rand() % BWAPI::Broodwar->mapHeight();
		attack_pos = BWAPI::Position{ 32 * x , 32 * y };
		attack();
	}
	return;
}

void Flyer::update_dropship() {
	//if (transport_pos != BWAPI::Positions::None) {
	//	draw_line(transport_pos, BWAPI::Colors::Yellow);
	//}
	return;
}

void Flyer::update_cruiser() {
	if (ability_queue == 0) {
		check_yamato();
	} else {
		ability_queue--;
		draw_line(ability_target, BWAPI::Colors::Blue);
		return;
	}

	if (unit->isAttackFrame()) {
		draw_line(attack_pos, BWAPI::Colors::Red);
		return;
	}

	if (retreat_queue == 0) {
		avoid_airdef();
		draw_line(attack_pos, BWAPI::Colors::Yellow);
	} else {
		retreat_queue--;
		draw_line(retreat_pos, BWAPI::Colors::Green);
		return;
	}

	if (command_queue == 0) {
		if (is_circling) { fly_in_circles(); }
		if (is_swarming) { swarm(false); }
		if (unit->isIdle()) { attack(); }
	} else {
		command_queue--;
	}
	return;
}

void Flyer::update_wraith() {
	if (command_queue > 0) {
		command_queue--;
	} else if (!unit->isAttackFrame()) {
		attack_target = get_target_wraith();
		if (attack_target != NULL) {
			unit->attack(attack_target);
		} else {
			fly_in_circles();
			unit->move(attack_pos);
		}
		command_queue = 20;
	}
	if (attack_target != NULL) { draw_line(attack_target->getPosition(), BWAPI::Colors::Red); }
	else { draw_line(attack_pos, BWAPI::Colors::Yellow); }
	return;
}



//specials

void Flyer::fly_in_circles() {
	if (sqdist(unit->getPosition(), attack_pos) < 16384) {
		ic += dc;
		BWAPI::Position pa = wilmap::aircircle.at((ic) % wilmap::aircircle.size());
		int dx = (rand() % 256) - 128;
		int dy = (rand() % 256) - 128;
		latest_pos = unit->getPosition();
		attack_pos = BWAPI::Position{ pa.x + dx, pa.y + dy };
		attack();
	}
	return;
}

void Flyer::avoid_airdef() {
	BWAPI::TilePosition t0 = BWAPI::TilePosition{ unit->getPosition() };
	BWAPI::TilePosition t1 = BWAPI::TilePosition{ estimate_next_pos(unit, 24) };
	if (wilthr::airdef[t0.y][t0.x] > 0 ||
		wilthr::airdef[t1.y][t1.x] > 0) {
		retreat_pos = linear_interpol_abs(unit->getPosition(), latest_pos, 128);
		unit->move( retreat_pos );
		retreat_queue = 64;
	}
	return;
}

void Flyer::check_yamato() {
	if (BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Yamato_Gun) &&
		unit->getEnergy() >= 150) {
		ability_target = get_target_yamato();
		if (ability_target != NULL &&
			unit->canUseTech(BWAPI::TechTypes::Yamato_Gun, ability_target)) {
			unit->useTech(BWAPI::TechTypes::Yamato_Gun, ability_target);
			ability_pos = ability_target->getPosition();
			ability_queue = 128;
			willyt::target_vector.push_back(ability_target);
			//BWAPI::Broodwar->printf("yamato %s", my_target->getType().c_str());
		}
	}
	return;
}

BWAPI::Unit Flyer::get_target_yamato() {
	using namespace BWAPI::UnitTypes;
	for (BWAPI::Player p : BWAPI::Broodwar->enemies()) {
		for (BWAPI::Unit u : p->getUnits()) {
			BWAPI::UnitType t = u->getType();
			if (t == Zerg_Spore_Colony ||
				t == Terran_Missile_Turret ||
				t == Terran_Bunker ||
				t == Protoss_Photon_Cannon) {
				if (sqdist(unit, u) < 196 &&
					!vector_holds(willyt::target_vector, u)) {
					return u;
				}
			}
			if (t == Zerg_Defiler ||
				t == Zerg_Queen ||
				t == Zerg_Devourer ||
				t == Terran_Goliath ||
				t == Terran_Wraith ||
				t == Terran_Valkyrie ||
				t == Terran_Science_Vessel ||
				t == Terran_Battlecruiser ||
				t == Protoss_Dragoon ||
				t == Protoss_Scout ||
				t == Protoss_Corsair ||
				t == Protoss_Arbiter ||
				t == Protoss_Carrier) {
				if (u->getHitPoints() >= 96 &&
					u->isCompleted() &&
					!u->isLockedDown() &&
					sqdist(unit, u) < 100 &&
					!vector_holds(willyt::target_vector, u)) {
					return u;
				}
			}
		}
	}
	return NULL;
}

BWAPI::Unit Flyer::get_target_wraith() {
	using namespace BWAPI::UnitTypes;
	std::vector<BWAPI::Unit> my_vector;
	for (BWAPI::Player p : BWAPI::Broodwar->enemies()) {
		for (BWAPI::Unit u : p->getUnits()) {
			BWAPI::UnitType t = u->getType();
			if (t == Zerg_Drone ||
				t == Zerg_Overlord ||
				t == Zerg_Queen ||
				t == Zerg_Guardian ||
				t == Terran_SCV ||
				t == Terran_Dropship ||
				t == Terran_Science_Vessel ||
				t == Protoss_Probe ||
				t == Protoss_Shuttle ||
				t == Protoss_Arbiter) {
				my_vector.push_back(u);
			}
		}
	}
	BWAPI::Unit min_unit = get_closest(my_vector, unit->getPosition());
	if (min_unit != NULL &&
		sqdist(min_unit, unit) < 64) {
		return min_unit;
	}
	return NULL;
}


//visualization

void Flyer::draw_line(BWAPI::Position p, BWAPI::Color c) {
	BWAPI::Broodwar->drawLineMap(unit->getPosition(), p, c);
	return;
}
void Flyer::draw_line(BWAPI::Unit u, BWAPI::Color c) {
	if (!u->exists()) { return; }
	BWAPI::Broodwar->drawLineMap(unit->getPosition(), u->getPosition(), c);
	return;
}
void Flyer::draw_text(const char* s, BWAPI::Text::Enum c) {
	BWAPI::Broodwar->drawTextMap(unit->getPosition(), "%c%s", c, s);
	return;
}
