#include "ExpoFinder.h"

void ExpoFinder::check() {
	int t = BWAPI::Broodwar->elapsedTime();
	int g = BWAPI::Broodwar->self()->gas();
	int m = BWAPI::Broodwar->self()->minerals();
	unsigned n_min = 21;
	if (willyt::has_transport) n_min = 27;

	if (wilbuild::minerals.size() < n_min &&
		t > wilbuild::locking_time && m > 400) {
		check_additional_expansion();
	}
	if (any_geyser_available() &&
		t > wilbuild::locking_time && m > 300 && g < m / 2) {
		check_additional_refinery();
	}
	if (t > wilbuild::locking_time) {
		remove_mineral_blocks();
	}
	update_outside_expo();
}

void ExpoFinder::check_additional_expansion() {
	BWAPI::UnitType my_type = BWAPI::UnitTypes::Terran_Command_Center;
	BWAPI::TilePosition enemy_center = calc_enemy_center();
	BWAPI::TilePosition my_tile;
	BWAPI::TilePosition min_tile;
	int my_dist = NULL;
	int min_dist = NULL;
	bool allow_min_only = allow_min_only_expansion();

	for (Expo &my_expo : wilexpo::all) {
		if (my_expo.is_owned ||
			my_expo.is_enemy ||
			(my_expo.is_island && !willyt::has_transport) ||
			(my_expo.is_island && rand() % 2 == 1) ||
			my_expo.minerals.size() < 4) {
			continue;
		}
		if (my_expo.geysers.empty() &&
			!allow_min_only) {
			continue;
		}
		my_tile = my_expo.tile;
		my_dist = get_ground_dist(my_tile);
		if (my_dist < 0) {  my_dist = my_tile.getApproxDistance(wilmap::my_start); }
		my_dist = my_dist - 2 * my_tile.getApproxDistance(enemy_center);

		if (min_dist == NULL ||
			min_dist > my_dist) {
			min_dist = my_dist;
			min_tile = my_tile;
		}
	}
	if (min_tile != BWAPI::TilePositions::Unknown &&
		min_dist != NULL &&
		!vector_holds(wilbuild::planned_builds, my_type)) {
		auto it = choose_scv(min_tile, true, true);
		if (it != wilunits::scvs.end()) {
			it->set_build_mission(my_type, min_tile);
			//BWAPI::Broodwar->printf("build additional expansion");
		}
	}
}

BWAPI::TilePosition ExpoFinder::calc_enemy_center() {
	int x = 16 * BWAPI::Broodwar->mapWidth();
	int y = 16 * BWAPI::Broodwar->mapHeight();
	int q = 32 + 32 * wilenemy::positions.size();
	for (BWAPI::Position &p : wilenemy::positions) {
		x += p.x;
		y += p.y;
	}
	return BWAPI::TilePosition(x/q, y/q);
}

void ExpoFinder::check_additional_refinery() {
	BWAPI::UnitType my_type = BWAPI::UnitTypes::Terran_Refinery;
	BWAPI::TilePosition my_tile = BWAPI::TilePositions::Unknown;

	for (BWAPI::Unit &g : wilbuild::geysers) {
		if (g->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser &&
			g->getResources() >= 500 &&
			g->getTilePosition().isValid()) {
			my_tile = g->getTilePosition();
			if (!willyt::has_transport &&
				get_ground_dist(my_tile) < 0) {
				my_tile = BWAPI::TilePositions::Unknown;
			}
			else { break; }
		}
	}
	if (my_tile != BWAPI::TilePositions::Unknown &&
		!vector_holds(wilbuild::planned_builds, my_type)) {
		auto it = choose_scv(my_tile, true, true);
		if (it != wilunits::scvs.end()) {
			it->set_build_mission(my_type, my_tile);
			//BWAPI::Broodwar->printf("build additional refinery");
		}
	}
}

void ExpoFinder::remove_mineral_blocks() {
	for (BWAPI::Unit n : BWAPI::Broodwar->getNeutralUnits()) {
		if (n->getType().isMineralField() &&
			n->getResources() <= 8 &&
			n->isBeingGathered() == false) {
			auto it = choose_scv(n->getTilePosition(), true, true);
			if (it != wilunits::scvs.end()) {
				it->gather(n);
				//BWAPI::Broodwar->printf("remove zero mineral block");
				return;
			}
		}
	}
}

bool ExpoFinder::allow_min_only_expansion() {
	int min = calc_theo_income_min() + BWAPI::Broodwar->self()->minerals();
	int gas = calc_theo_income_gas() + BWAPI::Broodwar->self()->gas();
	//BWAPI::Broodwar->printf("calculated %d min", min);
	//BWAPI::Broodwar->printf("calculated %d gas", gas);
	if (3 * gas >= min) { return true; }
	return false;
}

bool ExpoFinder::any_geyser_available() {
	for (BWAPI::Unit u : wilbuild::geysers)
		if (u->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser &&
			u->getResources() >= 500 &&
			u->getTilePosition().isValid())
			return true;
	return false;
}

int ExpoFinder::calc_theo_income_min() {
	int i = 0;
	for (BWAPI::Unit m : wilbuild::minerals) {
		if (m->getResources() > 100) { i += 100; }
		else { i += 25; }
	}
	return i;
}

int ExpoFinder::calc_theo_income_gas() {
	int i = 0;
	for (BWAPI::Unit g : wilbuild::geysers) {
		if (g->getResources() > 200) { i += 200; }
		else { i += 50; }
	}
	return i;
}

void ExpoFinder::update_outside_expo() {
	wilenemy::outside_expo_pos.clear();
	for (Expo& expo : wilexpo::all) {
		if (!expo.is_owned &&
			!expo.is_enemy &&
			!expo.is_island &&
			!buildspot_visible(expo.tile)) {
			wilenemy::outside_expo_pos.push_back(expo.posi);
		}
	}
	return;
}
