#pragma once
#include <BWAPI.h>

// Remember not to use "Broodwar" in any global class constructor!

class EggBot : public BWAPI::AIModule
{
public:
	// Virtual functions for callbacks, leave these as they are.
	virtual void onStart();
	//virtual void onEnd(bool isWinner);
	virtual void onFrame();
	virtual void onSendText(std::string text);
	virtual void onReceiveText(BWAPI::Player player, std::string text);
	//virtual void onPlayerLeft(BWAPI::Player player);
	//virtual void onNukeDetect(BWAPI::Position target);
	//virtual void onUnitDiscover(BWAPI::Unit unit);
	//virtual void onUnitEvade(BWAPI::Unit unit);
	//virtual void onUnitShow(BWAPI::Unit unit);
	//virtual void onUnitHide(BWAPI::Unit unit);
	//virtual void onUnitCreate(BWAPI::Unit unit);
	virtual void onUnitDestroy(BWAPI::Unit unit);
	//virtual void onUnitMorph(BWAPI::Unit unit);
	//virtual void onUnitRenegade(BWAPI::Unit unit);
	//virtual void onSaveGame(std::string gameName);
	//virtual void onUnitComplete(BWAPI::Unit unit);
	
	// These values are used to initialize our bot and track the state of the game.
	bool scouting = false;
	BWAPI::Unit scout = NULL;
	BWAPI::Unit builder = NULL;
	int scoutIdleTimer = 0;
	int townTimer = 0;
	int forgeTimer = 0;
	int cannonTimer = 0;
	int giveUpTimer = 0;
	int gatewayTimer = 0;
	std::vector<BWAPI::TilePosition> baseLocations;
	std::vector<BWAPI::TilePosition> patrolLocations;
	int patrolIndex = 0;
	std::map<int, BWAPI::Position> enemyUnits;
	BWAPI::TilePosition enemyBaseLocation;
	BWAPI::TilePosition homeBaseLocation;
	BWAPI::Position rushPylonLocation;
	bool foundEnemy = false;
	bool seenEnemyUnit = false;
	int numProbes = 4;
	bool building = false;
	BWAPI::Unit gatewayRef;
	bool townPylon = false;
	bool rushPylon = false;
	bool forge = false;
	bool gateway = false;
	int numCannons = 0;
	int numGateways = 0;
	int numPylons = 0;
	int numZealots = 0;
	int numZealotRush = 6;
	bool probeStopped = false;
	bool constructBuilding(BWAPI::Unit unit, BWAPI::UnitType type);
	void EggBot::avoidUnit(BWAPI::Unit target, BWAPI::Unit other, int distance);
};
