#include "WillytState.h"

namespace willyt
{
	int strategy = 1;
	int test_strategy = 0;
	bool show_info = true;
	bool is_vs_human = false;

	unsigned time = 0;

	int attack_supply = 15;
	int mining_supply = 20;

	bool is_swarming = false;
	bool first_attack = false;
	bool is_choke_def = false;

	bool go_bio = true;
	int max_bio_upgrade = 3;
	bool fast_expand = true;
	bool siege_started = false;

	bool has_natural = false;
	bool go_islands = false;
	bool has_transport = false;
	bool go_raiding = false;
	bool blocked_mainchoke = false;
	unsigned available_scans = 0;

	bool rush_alert = false;
	bool eight_rax = false;
	bool need_turrets = false;
	bool need_turrets_2 = false;
	bool need_detection = false;
	bool stim_allowed = false;
	bool avoid_grddef = false;
	bool proxy_alert = false;
	bool proxy_prod_alert = false;
	bool hold_bunker = false;
	bool guard_siege = false;

	BWAPI::Position retreat_pos = BWAPI::Positions::None;
	BWAPI::Position gather_pos = BWAPI::Positions::None;
	BWAPI::Position def_target_pos = BWAPI::Positions::None;
	BWAPI::Position att_target_pos = BWAPI::Positions::None;
	BWAPI::Position leader_pos = BWAPI::Positions::None;
	BWAPI::Position siege_pos = BWAPI::Positions::None;
	BWAPI::Position enemy_natural_pos = BWAPI::Positions::None;

	std::vector<BWAPI::Unit> target_vector;
}


void StateManager::update(int n_min, int n_gas, int n_ds) {
	using namespace willyt;

	//attack supply treshold
	int a = (BWAPI::Broodwar->elapsedTime() / 30) + (15 * BWAPI::Broodwar->enemies().size()) - 15;
	if (a < 15) { a = 15; }
	if (a > 60) { a = 60; }

	switch (strategy) {
	case 1: attack_supply = a;		break;
	case 2: attack_supply = a + 6;	break;
	case 3: attack_supply = a + 12; break;
	case 6: attack_supply = a + 6;	break;
	}

	//mining supply treshold
	int m = 2 * n_min + 3 * n_gas + 3;
	if (strategy == 1 && BWAPI::Broodwar->getFrameCount() < 14400) { m = 24; }
	if (m > 60) { m = 60; }
	mining_supply = m;

	//other stuff
	if (strategy == 3) { go_bio = false; }
	if (strategy == 1) { fast_expand = false; }
	target_vector.clear();

	//transport evaluation
	has_transport = false;
	if (n_ds > 0) { has_transport = true; }
	return;
}