#include "Trainer.h"

void Trainer::init() {
	scv_rax_count = 11;
	tank_ratio = 5;
	goli_ratio = 1;
	if (willyt::strategy == 1) {
		scv_rax_count = 10;
		if (wilenemy::race == BWAPI::Races::Zerg) {
			willyt::eight_rax = true;
			scv_rax_count = 8;
		}
	}
	if (willyt::strategy == 3) {
		tank_ratio = 3;
		if (wilenemy::race == BWAPI::Races::Zerg) {
			tank_ratio = 2;
		}
	}
	return;
}

void Trainer::train() {
	count_unit_supplies();
	build_addons(wilbuild::commandcenters, BWAPI::UnitTypes::Terran_Comsat_Station);
	build_addons(wilbuild::starports, BWAPI::UnitTypes::Terran_Control_Tower);

	if (willyt::strategy != 6) {
		build_addons(wilbuild::sciencefacs, BWAPI::UnitTypes::Terran_Covert_Ops);
	} else {
		build_addons(wilbuild::sciencefacs, BWAPI::UnitTypes::Terran_Physics_Lab);
	}
	if ((willyt::strategy == 1 || willyt::strategy == 2) &&
		3 * count_addon(wilbuild::factories, 0) / 2 < wilbuild::factories.size()) {
		build_addons(wilbuild::factories, BWAPI::UnitTypes::Terran_Machine_Shop);
	}
	if (willyt::strategy == 3 &&
		2 * count_addon(wilbuild::factories, 0) < wilbuild::factories.size()) {
		build_addons(wilbuild::factories, BWAPI::UnitTypes::Terran_Machine_Shop);
	}

	if (!wilbuild::commandcenters.empty() &&
		BWAPI::Broodwar->self()->minerals() >= 50) {
		BWAPI::Unit my_cc = find_idle(wilbuild::commandcenters);
		if (my_cc) { train_commandc(my_cc); }
	}
	if (!wilbuild::barracks.empty() &&
		!saving_for_expo() &&
		BWAPI::Broodwar->self()->minerals() >= 100) {
		BWAPI::Unit my_rax = find_idle(wilbuild::barracks);
		if (my_rax) { train_barracks(my_rax); }
	}
	if (willyt::strategy != 6 &&
		!wilbuild::factories.empty() &&
		!saving_for_expo() &&
		BWAPI::Broodwar->self()->minerals() >= 100) {
		train_factories();
	}
	if (!wilbuild::starports.empty() &&
		!saving_for_expo() &&
		BWAPI::Broodwar->self()->minerals() >= 100) {
		BWAPI::Unit my_sta = find_idle(wilbuild::starports);
		if (my_sta) { train_starports(my_sta); }
	}
}

void Trainer::train_commandc(BWAPI::Unit my_cc) {
	if (wilunits::tcount_scv < willyt::mining_supply &&
		!wait_workers()) {
		my_cc->train(BWAPI::UnitTypes::Terran_SCV);
		return;
	}
}

void Trainer::train_barracks(BWAPI::Unit my_rax) {
	if (is_spooky()) {
		my_rax->train(BWAPI::UnitTypes::Terran_Ghost);
		return;
	}
	if (willyt::go_bio &&
		wilbuild::academies.size() > 0 &&
		wilbuild::academies.front()->isCompleted() &&
		BWAPI::Broodwar->self()->gas() >= 25) {
		if (5 * wilunits::tcount_medic < wilunits::tcount_marine + wilunits::tcount_firebat) {
			my_rax->train(BWAPI::UnitTypes::Terran_Medic);
			return;
		}
		if (need_a_light()) {
			my_rax->train(BWAPI::UnitTypes::Terran_Firebat);
			return;
		}
	}
	if (need_rines()) {
		my_rax->train(BWAPI::UnitTypes::Terran_Marine);
		return;
	}
}

void Trainer::train_factories() {
	BWAPI::Unit facaddon = find_idle_addon(wilbuild::factories);
	BWAPI::Unit facnaked = find_idle_naked(wilbuild::factories);
	if (count_naked(wilbuild::factories, 0) == 0) { facnaked = facaddon; }

	if (can_build_goliath()) {
		if (facnaked && need_missiles_normal()) {
			facnaked->train(BWAPI::UnitTypes::Terran_Goliath);
			return;
		}
		if (facnaked && need_missiles_urgent()) {
			facnaked->train(BWAPI::UnitTypes::Terran_Goliath);
			return;
		}
		if (facaddon && need_missiles_urgent()) {
			facaddon->train(BWAPI::UnitTypes::Terran_Goliath);
			return;
		}
	}
	if (facnaked && bring_it_on()) {
		facnaked->train(BWAPI::UnitTypes::Terran_Vulture);
		return;
	}
	if (facaddon && !saving_for_siege()) {
		facaddon->train(BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode);
		return;
	}
}

void Trainer::train_starports(BWAPI::Unit my_sta) {
	if ((willyt::strategy != 6 || wilunits::cruisers.size() > 0) &&
		//willyt::go_islands &&
		wilunits::dropships.size() == 0) {
		my_sta->train(BWAPI::UnitTypes::Terran_Dropship);
		return;
	}
	//if (willyt::strategy != 6 &&
	//	wilunits::wraiths.size() < 2) {
	//	my_sta->train(BWAPI::UnitTypes::Terran_Wraith);
	//	return;
	//}
	if (willyt::strategy == 6 &&
		wilbuild::physicslabs.size() > 0 &&
		wilbuild::physicslabs.front()->isCompleted()) {
		my_sta->train(BWAPI::UnitTypes::Terran_Battlecruiser);
		return;
	}
}



BWAPI::Unit Trainer::find_idle(std::vector<BWAPI::Unit> my_list) {
	for (BWAPI::Unit &my_unit : my_list)
		if (my_unit->isCompleted() && my_unit->isIdle() && !my_unit->isLifted())
			return my_unit;
	return NULL;
}
BWAPI::Unit Trainer::find_idle_addon(std::vector<BWAPI::Unit> my_list) {
	for (BWAPI::Unit& my_unit : my_list)
		if (my_unit->isCompleted() && my_unit->isIdle() && !my_unit->isLifted() &&
			my_unit->getAddon() != NULL)
			return my_unit;
	return NULL;
}
BWAPI::Unit Trainer::find_idle_naked(std::vector<BWAPI::Unit> my_list) {
	for (BWAPI::Unit &my_unit : my_list)
		if (my_unit->isCompleted() && my_unit->isIdle() && !my_unit->isLifted() &&
			my_unit->getAddon() == NULL)
			return my_unit;
	return NULL;
}



bool Trainer::need_a_light() {
	int f = 4;
	if (wilenemy::race != BWAPI::Races::Terran &&
		wilenemy::small_percentage >= 75 &&
		willyt::strategy != 6)
		f = 1;
	if (f * wilunits::tcount_firebat < wilunits::tcount_marine)
		return true;
	else
		return false;
}
bool Trainer::need_rines() {
	if (willyt::rush_alert)
		return true;
	if (saving_for_academy_refinery() ||
		saving_for_refinery())
		return false;
	if (willyt::strategy == 3 &&
		(BWAPI::Broodwar->elapsedTime() >= 600 ||
		wilunits::tcount_marine >= 4 ||
		(willyt::avoid_grddef && willyt::proxy_alert)))
		return false;
	if (willyt::strategy == 6 &&
		wilunits::tcount_marine >= 12 &&
		wilbuild::starports.size() >= 3)
		return false;
	return true;
}



bool Trainer::need_missiles_normal() {
	if (wilunits::goliaths.size() * tank_ratio < wilunits::siegetanks.size() * goli_ratio)
		return true;
	if (wilunits::goliaths.size() == 0 && wilenemy::supply_air > 0)
		return true;
	return false;
}
bool Trainer::need_missiles_urgent() {
	if (wilenemy::air_percentage >= 50)
		return true;
	return false;
}
bool Trainer::can_build_goliath() {
	if (!wilbuild::armories.empty() && wilbuild::armories.front()->isCompleted())
		return true;
	return false;
}



bool Trainer::bring_it_on() {
	if (wilunits::vultures.size() < wilunits::siegetanks.size() &&
		BWAPI::Broodwar->self()->minerals() >= BWAPI::Broodwar->elapsedTime() / 2 &&
		BWAPI::Broodwar->self()->minerals() >= BWAPI::Broodwar->self()->gas() * 2)
		return true;
	if (willyt::strategy == 3 &&
		BWAPI::Broodwar->elapsedTime() < 900 &&
		!wilbuild::machineshops.empty() &&
		(wilunits::siegetanks.size() >= 2 || wilenemy::race == BWAPI::Races::Zerg) &&
		wilunits::vultures.size() < 2)
		return true;
	return false;
}
bool Trainer::is_spooky() {
	if (wilbuild::covertops.size() > 0 &&
		wilbuild::covertops.front()->isCompleted() &&
		(int)(200 * wilunits::ghosts.size()) < BWAPI::Broodwar->self()->gas())
		return true;
	return false;
}



bool Trainer::saving_for_expo() {
	if (BWAPI::Broodwar->elapsedTime() > 720 &&
		BWAPI::Broodwar->self()->minerals() < 500 &&
		wilunits::tcount_scv >= willyt::mining_supply &&
		wilbuild::minerals.size() < 12)
		return true;
	if (willyt::fast_expand &&
		wilbuild::commandcenters.size() < 2)
		return true;
	return false;
}
bool Trainer::saving_for_academy_refinery() {
	if (wilbuild::academies.size() + wilbuild::refineries.size() < 2 &&
		!wilbuild::geysers.empty() &&
		willyt::strategy == 1 &&
		BWAPI::Broodwar->self()->supplyUsed() >= 42)
		return true;
	return false;
}
bool Trainer::saving_for_refinery() {
	if (wilbuild::refineries.empty() &&
		!wilbuild::geysers.empty() &&
		willyt::fast_expand &&
		willyt::strategy == 3 &&
		wilenemy::race != BWAPI::Races::Zerg &&
		wilenemy::supply_army == 0)
		return true;
	return false;
}
bool Trainer::saving_for_siege() {
	if (willyt::strategy == 3 &&
		!willyt::siege_started)
		return true;
	return false;
}



void Trainer::build_addons(std::vector<BWAPI::Unit> my_vec, BWAPI::UnitType my_addon) {
	for (BWAPI::Unit &my_unit : my_vec) {
		if (my_unit->isCompleted() &&
			my_unit->isIdle() &&
			!my_unit->getAddon() &&
			my_unit->canBuildAddon()) {
			my_unit->buildAddon(my_addon);
			return;
		}
	}
}
unsigned Trainer::count_addon(std::vector<BWAPI::Unit> my_vec, int i) {
	for (BWAPI::Unit& my_unit : my_vec)
		if (my_unit->isCompleted() && my_unit->getAddon() != NULL)
			i++;
	return i;
}
unsigned Trainer::count_naked(std::vector<BWAPI::Unit> my_vec, int i) {
	for (BWAPI::Unit& my_unit : my_vec)
		if (my_unit->isCompleted() && my_unit->getAddon() == NULL)
			i++;
	return i;
}



bool Trainer::wait_workers() {
	if (willyt::strategy == 1 && wilunits::tcount_scv >= 10) {
		int su = BWAPI::Broodwar->self()->supplyUsed(BWAPI::Races::Terran);
		int st = BWAPI::Broodwar->self()->supplyTotal(BWAPI::Races::Terran);
		if (st - su <= 4) {
			//BWAPI::Broodwar->printf("Halt SCV production.");
			return true;
		}
	}
	if (wilbuild::barracks.empty() && wilunits::tcount_scv >= scv_rax_count &&
		BWAPI::Broodwar->self()->minerals() < 200) {
		return true;
	}
	if (wilbuild::factories.empty() && wilunits::tcount_scv >= 18 &&
		willyt::strategy == 3 && !willyt::fast_expand) {
		return true;
	}
	if (wilbuild::commandcenters.size() < 2 && wilunits::tcount_scv >= scv_fe_count &&
		willyt::fast_expand &&
		BWAPI::Broodwar->self()->minerals() < 450) {
		return true;
	}
	return false;
}

