#include "Scout.h"

Scout::Scout() {
	did_scout = false;
	BWAPI::Unit my_unit = NULL;
	BWAPI::Position my_next = BWAPI::Positions::None;
	int my_increment = 0;
	int scout_queue = 0;
}

void Scout::update() {
	if (!did_scout && my_unit != NULL)
	{
		if (BWAPI::Broodwar->isVisible( BWAPI::TilePosition{ my_next } )) {
			vector_remove(wilmap::unscouted , my_next);
			//BWAPI::Broodwar->printf("unscouted mains left: %d", wilmap::unscouted.size());
			if (!wilmap::unscouted.empty())
			{
				my_next = wilmap::unscouted.back();
				my_unit->move( my_next );
				//BWAPI::Broodwar->printf("change scouting target");
			} else {
				did_scout = true;
				my_next = wilmap::my_natu;
				my_unit->move( my_next );
				//BWAPI::Broodwar->printf("terminate scouting");
			}
		}
		if (wilenemy::positions.empty() &&
			wilmap::unscouted.size() == 1) {
			wilenemy::positions.push_back(wilmap::unscouted.back());
			//BWAPI::Broodwar->printf("enemy can only be one way");
		}
		BWAPI::Broodwar->drawTextMap(my_unit->getPosition(), "tourist");
	}
	safe_sum(scout_queue, -1);
	if (my_unit != NULL && scout_queue == 0 && wilenemy::sem != -1)
	{
		did_scout = true;
		my_next = get_circle_pos(my_increment);
		my_increment = (my_increment + 1) % 24;
		if (my_next.isValid()) {
			scout_queue = dist(my_unit->getPosition(), my_next) / 8;
		} else {
			my_next = wilmap::my_natu;
			scout_queue = 24;
		}
		my_unit->move(my_next);
		//BWAPI::Broodwar->printf("pos: %d %d, queue: %d", my_next.x, my_next.y, scout_queue);
	}
	return;
}

void Scout::assign(BWAPI::Unit unit) {
	if (!did_scout && my_unit == NULL &&
		!wilmap::unscouted.empty()) {
		my_unit = unit;
		my_next = wilmap::unscouted.back();
		my_unit->move(my_next);
		for (SCV &scv : wilunits::scvs)
			if (scv.unit == unit)
				scv.is_scout = true;
		//BWAPI::Broodwar->printf("initiate scouting with completion");
		//BWAPI::Broodwar->printf("unscouted mains left: %d", wilmap::unscouted.size());
	}
	return;
}

BWAPI::Position Scout::get_circle_pos(int i) {
	for (int j = 13; j > 3; j--) {
		int x = (j * wilmap::cdx24[i]) + wilmap::main_pos[wilenemy::sem].x;
		int y = (j * wilmap::cdy24[i]) + wilmap::main_pos[wilenemy::sem].y;
		if (x > 0 && x < wilmap::wp &&
			y > 0 && y < wilmap::hp &&
			wilmap::build_map[y / 32][x / 32] &&
			wilmap::maindistarray[wilenemy::sem][y / 32][x / 32] < 32) {
			return BWAPI::Position{ x, y };
		}
	}
	return BWAPI::Positions::None;
}