#include "ReadWrite.h"
#include <iostream>
#include <fstream>
#include <ctime>
#include <iterator>

std::vector<std::string> read_logfile() {
	const char* my_path = ".\\bwapi-data\\read\\willytlog.txt";
	//const char* my_path = "K:\\bwapi\\willyttest.txt";
	std::vector<std::string> my_data;
	std::string my_line;

	//open read file with exeption
	std::ifstream my_file(my_path);
	if (!my_file) { return my_data; }

	//read file content into vector
	while (std::getline(my_file, my_line)) { my_data.push_back(my_line); }

	return my_data;
}

const char* write_logfile(std::string ename, std::string erace, int strat, bool iswin) {
	const char* my_path = ".\\bwapi-data\\write\\willytlog.txt";
	//const char* my_path = "K:\\bwapi\\willyttest.txt";
	std::vector<std::string> my_data = read_logfile();

	//assemble new entry
	std::string my_line;
	my_line += write_date() + ",";
	my_line += ename + ",";
	my_line += erace.substr(0,1) + ",";
	my_line += "0" + std::to_string(strat) + ",";
	my_line += iswin ? "1" : "0";
	my_data.push_back(my_line);

	//open write file with exeption
	std::ofstream my_file(my_path);
	if (!my_file) { return "unable to write log file";  }

	//write vector content into file
	std::ostream_iterator<std::string> output_iterator(my_file, "\n");
	std::copy(my_data.begin(), my_data.end(), output_iterator);

	return my_path;
}

std::string write_date() {
	//generate string components of the date
	std::time_t timer = std::time(0);
	std::tm*    tinfo = std::localtime(&timer);
	std::string syear = std::to_string(tinfo->tm_year + 1900);
	std::string smont = std::to_string(tinfo->tm_mon + 1);
	std::string smday = std::to_string(tinfo->tm_mday);
	if (smont.length() == 1) { smont.insert(0, "0"); }
	if (smday.length() == 1) { smday.insert(0, "0"); }
	return (syear + smont + smday);
}

void write_frame(int n) {
	const char* my_path = "D:\\bwapi\\willytframe.txt";
	std::ofstream my_file(my_path);
	if (!my_file) { return; }
	my_file << n;
}

void write_string(std::string s) {
	const char* my_path = "D:\\bwapi\\willytframe.txt";
	std::ofstream my_file(my_path);
	if (!my_file) { return; }
	my_file << s;
}