#pragma once
#include <BWAPI.h>
#include "WillytState.h"
#include "WillytUnits.h"
#include "WillytMap.h"
#include "Utilities.h"

//2018-08-25: initiate manager for vulture raid on expansions
//2020-06-18: vulture raids now done via mining missions
//			  rewrite to manage drop play: biosquads or vultures

struct RaidManager
{
public:
	void init();
	void end();
	void update();

private:
	Flyer* dropship = NULL;
	std::vector<Fighter2*> raiders = {};
	std::string state = "none";
	int ci = 0;
	int di = 0;
	BWAPI::Position last_pos = BWAPI::Positions::None;
	BWAPI::Position next_pos = BWAPI::Positions::None;

	bool evaluate_raiding();

	void assign_from(std::vector<Fighter2>& my_vec, unsigned i);
	bool check_raiders();
	void attack_raiders();
	void load_raiders();
	bool all_on_board();
	int get_expo_index(BWAPI::Position praid);
	void fly_to_next_expo();
	bool raid_dropship_near(BWAPI::Position my_pos, int s);
	bool enemy_workers_near(BWAPI::Position my_pos);
	bool enemy_buildings_near(BWAPI::Position my_pos);

	void draw_raiders();
};