#include "MicroUtilities.h"


bool reaching_area(BWAPI::Unit my_unit, int(&my_map)[1024][1024]) {
	BWAPI::Position p0 = my_unit->getPosition();
	BWAPI::Position p1 = estimate_next_pos(my_unit, 16);
	if (my_map[p0.y / 8][p0.x / 8] > 0) return true;
	if (my_map[p1.y / 8][p1.x / 8] > 0) return true;
	return false;
}



BWAPI::Unit get_target_from(std::vector<BWAPI::Unit>& v, BWAPI::Unit u, BWAPI::Position p, int r) {
	if (u != NULL) return u;
	u = get_closest(v, p);
	if (u != NULL && sqdist(p, u->getPosition()) < r) return u;
	return NULL;
}
BWAPI::Unit get_maximum_target(std::vector<BWAPI::Unit>& v, BWAPI::TilePosition t, int r) {
	BWAPI::Unit max_unit = NULL;
	int max_hp = 0;
	for (BWAPI::Unit u : v) {
		if (sqdist(u->getTilePosition(), t) <= r &&
			!vector_holds(willyt::target_vector, u) &&
			max_hp < u->getHitPoints() + u->getShields()) {
			max_hp = u->getHitPoints() + u->getShields();
			max_unit = u;
		}
	}
	return max_unit;
}



BWAPI::Position get_random_pos(std::vector<BWAPI::TilePosition>& my_vec) {
	BWAPI::TilePosition my_tile = BWAPI::TilePositions::None;
	if (!my_vec.empty()) {
		int i = rand() % my_vec.size();
		if (BWAPI::Broodwar->getUnitsOnTile(my_vec[i]).empty()) {
			my_tile = my_vec[i];
		}
	}
	if (my_tile != BWAPI::TilePositions::None) {
		return BWAPI::Position(32 * my_tile.x + 16, 32 * my_tile.y + 16);
	}
	return BWAPI::Positions::None;
}
BWAPI::Position get_mine_position() {
	int x = 0;
	int y = 0;
	int n = wilenemy::outside_expo_pos.size();
	if (n > 0 && rand() % 3 == 0) {
		BWAPI::Position p = wilenemy::outside_expo_pos[rand() % n];
		x = rand() % 12 - 6 + p.x / 32;
		y = rand() % 11 - 6 + p.y / 32;
	}
	else if (BWAPI::Broodwar->getFrameCount() < 14400) {
		x = rand() % 32 - 16 + wilmap::my_entrance.x;
		y = rand() % 32 - 16 + wilmap::my_entrance.y;
	}
	else {
		x = rand() % wilmap::wt;
		y = rand() % (wilmap::ht - 1);
	}
	if (x != 0 && y != 0 &&
		!BWAPI::Broodwar->isVisible(x, y) &&
		get_ground_dist(x, y) > 0 &&
		wilmap::build_map[y][y] == false) {
		return BWAPI::Position(32 * x + 16, 32 * y + 16);
	}
	return BWAPI::Positions::None;
}



BWAPI::Position choose_defense_siegetile() {
	if (!willyt::has_natural) { return get_random_pos(wilmap::my_maindefvec); }
	if (willyt::has_natural) { return get_random_pos(wilmap::my_natudefvec); }
	return BWAPI::Positions::None;
}
bool check_defense_siegetile(BWAPI::TilePosition t) {
	if (!willyt::has_natural && wilmap::maindefmap[t.y][t.x]) { return true; }
	if (willyt::has_natural && wilmap::natudefmap[t.y][t.x]) { return true; }
	return false;
}



void draw_arrow(BWAPI::Position p0, BWAPI::Position p1, BWAPI::Color c) {
	if (sqdist(p0, p1) <= 65536) {
		BWAPI::Broodwar->drawLineMap(p0, p1, c);
	} else {
		BWAPI::Broodwar->drawLineMap(p0, linear_interpol_abs(p0, p1, 128), c);
	}
	return;
}