#pragma once
#include <BWAPI.h>
#include "WillytState.h"
#include "WillytMap.h"
#include "WillyThreat.h"
#include "Utilities.h"
#include "MapUtilities.h"


//2019-11-15: Flyer class


class Flyer
{
public:

	//general

	Flyer(BWAPI::Unit my_unit);
	BWAPI::Unit unit;
	unsigned id;

	//states

	bool is_circling;
	bool is_swarming;
	bool is_raider;

	//circle

	int ic;
	int dc;
	int im;

	//methods

	void attack();
	void swarm(bool immediatly);
	void update_dropship();
	void update_cruiser();
	void update_wraith();
	BWAPI::Position transport_pos;

private:

	//Positions

	BWAPI::Position attack_pos;
	BWAPI::Position latest_pos;
	BWAPI::Position retreat_pos;
	BWAPI::Position ability_pos;
	int command_queue;
	int retreat_queue;
	int ability_queue;

	//specials

	void fly_in_circles();
	void avoid_airdef();
	void check_yamato();
	BWAPI::Unit ability_target;
	BWAPI::Unit get_target_yamato();
	BWAPI::Unit attack_target;
	BWAPI::Unit get_target_wraith();

	//visualization

	void draw_line(BWAPI::Position p, BWAPI::Color c);
	void draw_line(BWAPI::Unit u, BWAPI::Color c);
	void draw_text(const char* s, BWAPI::Text::Enum c);

};