#pragma once
#include <BWAPI.h>
#include "WillytState.h"
#include "WillytEnemy.h"
#include "WillyThreat.h"
#include "Utilities.h"
#include "MicroUtilities.h"

//2019-12-12: rewriting of fighter class for more independent behaviour

class Fighter2
{
public:

	//general

	Fighter2(BWAPI::Unit my_unit);
	BWAPI::Unit unit;
	unsigned id;

	//methods

	void update();
	void set_target(BWAPI::Position my_position);
	void set_swarm(bool immediately);
	void set_raider(bool status);
	void set_secure(BWAPI::Position my_position);
	void set_load(BWAPI::Unit my_transport);

	//specials

	void check_stim();
	void check_fallb();
	void check_flare();
	void check_lockd();
	void check_cloak();

	//mechanicals

	void check_siege();
	void check_mines();

	//exception

	bool is_raider;

private:

	//booleans

	bool is_onlygrd;
	bool is_support;
	bool specials_allowed;
	bool changed_attack_pos;

	//positions

	int attack_sqdst;
	int retreat_sqdst;
	BWAPI::TilePosition tile;
	BWAPI::Position posi;
	BWAPI::Position secure_pos;
	BWAPI::Position attack_pos;
	BWAPI::Position special_pos;

	//queues

	int attack_queue;
	int special_queue;
	int spider_mine_count;
	int command_frames;

	//targeting

	BWAPI::Unit target;
	BWAPI::Unit get_target_all(int r);
	BWAPI::Unit get_target_heal();
	BWAPI::Unit get_target_siege();
	BWAPI::Unit get_target_goliath();
	BWAPI::Unit get_target_vulture();

};