#include "ExpoManager.h"

void ExpoManager::init() {
	init_all_resources();
	fill_build_map_with_expos();
	determine_islands();
	determine_natu_all();
	determine_defs_all();
	determine_expo_circle();
	willyt::go_islands = decide_islands();
	return;
}

void ExpoManager::occupy_expo(BWAPI::TilePosition &tile) {
	for (Expo &my_expo : wilexpo::all) {
		if (my_expo.tile == tile) {
			my_expo.is_owned = true;
			my_expo.is_constructing = true;
			//BWAPI::Broodwar->printf("Occupying expo at [%d, %d].", tile.x, tile.y);
		}
	}
	if (willyt::has_natural == false &&
		wilmap::natu_tiles[wilmap::mm].x == tile.x + 1 &&
		wilmap::natu_tiles[wilmap::mm].y == tile.y + 1) {
		willyt::has_natural = true;
		//BWAPI::Broodwar->printf("Occupying the natural expansion!");
	}
	return;
}

void ExpoManager::desert_expo(BWAPI::TilePosition &tile) {
	for (Expo &my_expo : wilexpo::all) {
		if (my_expo.tile == tile) {
			for (BWAPI::Unit &my_min : my_expo.minerals) {
				vector_remove(wilbuild::minerals, my_min);
				vector_remove(wilbuild::mainland_minerals, my_min);
			}
			for (BWAPI::Unit &my_gey : my_expo.geysers) {
				vector_remove(wilbuild::geysers, my_gey);
				vector_remove(wilbuild::mainland_geysers, my_gey);
			}
			my_expo.is_owned = false;
			my_expo.is_constructing = false;
			//BWAPI::Broodwar->printf("Deserting expo at [%d, %d].", tile.x, tile.y);
		}
	}
	return;
}

void ExpoManager::append_expo_resources(Expo& my_expo) {
	for (BWAPI::Unit& my_min : my_expo.minerals) {
		if (my_min->exists()) {
			wilbuild::minerals.push_back(my_min);
			if (!my_expo.is_island) { wilbuild::mainland_minerals.push_back(my_min); }
		}
	}
	for (BWAPI::Unit& my_gey : my_expo.geysers) {
		if (my_gey->exists()) {
			wilbuild::geysers.push_back(my_gey);
			if (!my_expo.is_island) { wilbuild::mainland_geysers.push_back(my_gey); }
		}
	}
	return;
}

void ExpoManager::destroy_mineral(BWAPI::Unit my_min) {
	set_map_area_unit(wilmap::build_map, my_min, true);
	vector_remove(wilbuild::all_minerals, my_min);
	vector_remove(wilbuild::all_mintiles, my_min->getTilePosition());

	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		if (vector_holds(it->minerals, my_min)) {
			vector_remove(it->minerals, my_min);
			vector_remove(it->min_tiles, my_min->getTilePosition());
			if (it->is_owned) {
				vector_remove(wilbuild::minerals, my_min);
				vector_remove(wilbuild::mainland_minerals, my_min);
			}
			//BWAPI::Broodwar->printf("mineral patch mined out");
			return;
		}
	}
	return;
}

void ExpoManager::destroy_geyser(BWAPI::Unit my_gas) {
	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		if (vector_holds(it->geysers, my_gas)) {
			vector_remove(it->geysers, my_gas);
			if (it->is_owned) { vector_remove(wilbuild::geysers, my_gas); }
			//BWAPI::Broodwar->printf("destroyed: refinery/extractor/assimilator");
			return;
		}
	}
	return;
}

void ExpoManager::rebuild_geyser(BWAPI::Unit my_gas) {
	if (BWAPI::Broodwar->getFrameCount() == 0) { return; } //dont do it on start
	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		if (vector_holds(it->gas_tiles, my_gas->getTilePosition())) {
			it->geysers.push_back(my_gas);
			if (it->is_owned) { wilbuild::geysers.push_back(my_gas); }
			//BWAPI::Broodwar->printf("reinstalling drivers for Resource_Vespene_Geyser");
			return;
		}
	}
	return;
}

void ExpoManager::set_enemy_expo(BWAPI::TilePosition tile, bool status) {
	for (Expo& my_expo : wilexpo::all) {
		if (my_expo.tile == tile) {
			my_expo.is_enemy = status;
			return;
		}
	}
	return;
}




void ExpoManager::update(std::vector<SCV> scvs) {
	for (std::vector<Expo>::iterator it = wilexpo::all.begin(); it != wilexpo::all.end(); ++it) {
		if (it->is_constructing) { check_construction(*it); }
		if (it->is_owned) { update_miners(*it, scvs); }
	}
	return;
}

void ExpoManager::check_construction(Expo& my_expo) {
	if (all_visible(my_expo.min_tiles) &&
		all_visible(my_expo.gas_tiles)) {
		for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsOnTile(my_expo.tile)) {
			if (u->getType() == BWAPI::UnitTypes::Terran_Command_Center &&
				u->getHitPoints() > 750) {
				my_expo.is_constructing = false;
				append_expo_resources(my_expo);
			}
		}
	}
	return;
}

void ExpoManager::update_miners(Expo& my_expo, std::vector<SCV> scvs) {
	my_expo.min_miners.clear();
	my_expo.gas_miners.clear();
	for (SCV& scv : scvs) {
		if (scv.unit->exists() &&
			sqdist(scv.unit->getPosition(), my_expo.posi) < 65536) {
			if (scv.unit->isGatheringMinerals()) { my_expo.min_miners.push_back(scv); }
			if (scv.unit->isGatheringGas()) { my_expo.gas_miners.push_back(scv); }
		}
	}
	return;
}

void ExpoManager::correct() {
	for (std::vector<Expo>::iterator expo = wilexpo::all.begin(); expo != wilexpo::all.end(); ++expo)
	{
		if (expo->minerals.empty() == false &&
			all_visible(expo->min_tiles) == true &&
			all_existing(expo->minerals) == false)
		{
			expo->minerals.clear();
			for (BWAPI::TilePosition t : expo->min_tiles)
				for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsOnTile(t))
					if (u->getType().isMineralField())
						expo->minerals.push_back(u);
			//BWAPI::Broodwar->printf("EXPO: recounting %d mineral field(s)", expo->minerals.size());
		}
		if (expo->gas_tiles.empty() == false &&
			all_visible(expo->gas_tiles) == true &&
			expo->geysers.size() < expo->gas_tiles.size())
		{
			expo->geysers.clear();
			for (BWAPI::TilePosition t : expo->gas_tiles)
				for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsOnTile(t))
					if (u->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ||
						u->getType().isRefinery())
						expo->geysers.push_back(u);
			//BWAPI::Broodwar->printf("EXPO: recounting %d vespene geyser(s)", expo->geysers.size());
		}

		if (expo->is_enemy &&
			BWAPI::Broodwar->isVisible(expo->tile) &&
			BWAPI::Broodwar->getUnitsOnTile(expo->tile).empty()) {
			expo->is_enemy = false;
			//BWAPI::Broodwar->printf("EXPO: enemy expo disappeared");
		}
	}
	return;
}

bool ExpoManager::all_visible(std::vector<BWAPI::TilePosition> &v) {
	for (BWAPI::TilePosition t : v)
		if (!BWAPI::Broodwar->isVisible(t))
			return false;
	return true;
}

bool ExpoManager::all_existing(std::vector<BWAPI::Unit> &v) {
	for (BWAPI::Unit u : v)
		if (!u->exists())
			return false;
	return true;
}

void ExpoManager::init_all_resources() {
	using namespace wilbuild;
	for (BWAPI::Unit m : BWAPI::Broodwar->getStaticMinerals()) {
		all_minerals.push_back(m);
		all_mintiles.push_back(m->getTilePosition());
	}
	for (BWAPI::Unit g : BWAPI::Broodwar->getStaticGeysers()) {
		all_geysers.push_back(g);
		all_gastiles.push_back(g->getTilePosition());
	}
	return;
}

bool ExpoManager::decide_islands() {
	for (Expo &expo : wilexpo::all) {
		if (expo.is_island) { return true; }
	}
	return false;
}
