#include "BunkerManager.h"

void BunkerManager::update() {
	if (wilbuild::bunkers.empty()) { return; }
	safe_substract(bunker_queue, 1);

	if (wilenemy::supply_near_bunkers > 0) {
		check_load();
		bunker_queue = 16;
	}
	if (bunker_queue == 0) {
		check_unload();
	}
	if (bunker_queue > 0 &&
		wilenemy::supply_near_bunkers == 0 &&
		!wilenemy::intruders.empty()) {
		check_unload();
	}
	return;
}

void BunkerManager::check_load() {
	for (BWAPI::Unit &bunker : wilbuild::bunkers) {
		if (bunker->isCompleted() &&
			bunker->getSpaceRemaining() > 0) {
			load_bunker(bunker);
			//BWAPI::Broodwar->printf("bunker LOAD");
		}
	}
	return;
}

void BunkerManager::check_unload() {
	for (BWAPI::Unit &bunker : wilbuild::bunkers) {
		if (bunker->getSpaceRemaining() < 4) {
			bunker->unloadAll();
			//BWAPI::Broodwar->printf("bunker UNLOAD");
		}
	}
	return;
}

void BunkerManager::load_bunker(BWAPI::Unit bunker) {
	int i = 0;
	for (auto &marine : wilunits::marines) {
		if (i < 4 &&
			marine.unit->exists() &&
			marine.unit->isCompleted() &&
			!marine.unit->isLoaded() &&
			sqdist(marine.unit, bunker) < 256) {
			marine.unit->load(bunker);
			//marine.retreat_queue = 96;
			++i;
		}
	}
	return;
}

int BunkerManager::count_bunker_units() {
	int i = 0;
	for (BWAPI::Unit &bunker : wilbuild::bunkers) {
		i += (4 - bunker->getSpaceRemaining());
	}
	return i;
}

