#include "ArmyPositions.h"

void calculate_army_positions() {
	using namespace wilmap;
	for (int i = 0; i < mn; i++) {

		//initial guess for main defense positions
		//BWAPI::Position p2 = linear_interpol_abs(main_choke_pos[i], main_pos[i], +192);
		//BWAPI::Position p3 = linear_interpol_abs(main_choke_pos[i], natu_pos[i], -192);
		//main_def_pos[i] = BWAPI::Position{ (p2.x + p3.x) / 2 , (p2.y + p3.y) / 2 };

		//initial guess for natu defense positions
		//if (natu_pos[i].getApproxDistance(natu_choke_pos[i]) >= 480) {
		//	natu_def_pos[i] = linear_interpol_abs(natu_pos[i], natu_choke_pos[i], +192);
		//} else {
		//	natu_def_pos[i] = linear_interpol_rel(natu_pos[i], natu_choke_pos[i], 0.5f);
		//}

		//modify defense positions to fit 6x6 area
		main_def_pos[i] = find_def_area(main_choke_pos[i], main_choke_pos[i], i);
		natu_def_pos[i] = find_def_area(natu_choke_pos[i], natu_pos[i], i);
		
		//modify and choose defense building tiles
		main_def_pos[i] = sort_def_area(main_def_pos[i], main_choke_pos[i], main_def_tile[i]);
		natu_def_pos[i] = sort_def_area(natu_def_pos[i], natu_choke_pos[i], natu_def_tile[i]);

	}
	my_main_def = main_def_pos[mm];
	my_natu_def = natu_def_pos[mm];
	my_entrance = BWAPI::TilePosition{ linear_interpol_rel(my_natu, center_pos, 0.4f) };
	willyt::retreat_pos = calculate_retreat_pos(my_main);

	//armycircle = create_circle_vector(natu_choke_pos[mm], 256);
	//BWAPI::Broodwar->printf("calculate army positions");
	return;
}

BWAPI::Position find_def_area(BWAPI::Position cp, BWAPI::Position bp, int i) {
	int x0 = cp.x / 32;
	int y0 = cp.y / 32;
	int xmin = 0;
	int ymin = 0;
	int dmin = 1024;
	int dgroundmax = wilmap::maindistarray[i][y0][x0];
	if (dgroundmax == -1) { dgroundmax = 256; }

	for (int x = x0-12; x <= x0+12; x++) {
		for (int y = y0-12; y <= y0+12; y++)
		{
			int dground = wilmap::maindistarray[i][y][x];
			int dchoke = dist(cp, BWAPI::Position(32 * x, 32 * y));
			int dbase = dist(bp, BWAPI::Position(32 * x, 32 * y));
			int d = dground + dchoke + dbase;

			if (dground != -1 &&
				dground < dgroundmax &&
				dchoke >= 96 &&
				dbase >= 96 &&
				check_buildable(x - 3, y - 3, 6, 6) &&
				d < dmin)
			{
				dmin = d;
				xmin = x;
				ymin = y;
			}
		}
	}
	return BWAPI::Position(32 * xmin, 32 * ymin);
}

BWAPI::Position sort_def_area(BWAPI::Position dp, BWAPI::Position cp, BWAPI::TilePosition(&dt)[2]) {
	int xc = cp.x / 32;
	int yc = cp.y / 32;
	int xd = dp.x / 32;
	int yd = dp.y / 32;
	std::vector<std::pair<int, BWAPI::TilePosition>> my_vec;
	my_vec.push_back(std::make_pair( sqdist(xc, yc, xd-1, yd-1), BWAPI::TilePosition(xd-1, yd-1) ));
	my_vec.push_back(std::make_pair( sqdist(xc, yc, xd+1, yd-1), BWAPI::TilePosition(xd+1, yd-1) ));
	my_vec.push_back(std::make_pair( sqdist(xc, yc, xd-1, yd+1), BWAPI::TilePosition(xd-1, yd+1) ));
	my_vec.push_back(std::make_pair( sqdist(xc, yc, xd+1, yd+1), BWAPI::TilePosition(xd+1, yd+1) ));
	sort(my_vec.begin(), my_vec.end());

	dt[0] = BWAPI::TilePosition(my_vec[0].second.x - 1, my_vec[0].second.y - 1); //bunker
	dt[1] = BWAPI::TilePosition(my_vec[1].second.x - 1, my_vec[1].second.y - 1); //turret
	if (dt[0].y == dt[1].y &&
		dt[0].x == dt[1].x - 2) {
		dt[0].x--;
	}
	if (dt[0].y != dt[1].y &&
		dt[0].x == xd) {
		dt[0].x--;
	}
	int xn = 16 * (my_vec[2].second.x + my_vec[3].second.x);
	int yn = 16 * (my_vec[2].second.y + my_vec[3].second.y);
	return BWAPI::Position(xn, yn);
}

BWAPI::Position fill_def_area(BWAPI::Position dp, BWAPI::Position cp, BWAPI::TilePosition(&dt)[2]) {
	int dx = cp.x - dp.x;
	int dy = cp.y - dp.y;
	int x = dp.x / 32;
	int y = dp.y / 32;
	//............horizontal case............
	if (abs(dx) >= abs(dy)) {
		if (dx > 0) {
			dt[0] = BWAPI::TilePosition(x - 1, y - 2);
			dt[1] = BWAPI::TilePosition(x - 1, y + 0);
			return BWAPI::Position(32*x - 64, 32*y);
		}
		else {
			dt[0] = BWAPI::TilePosition(x - 2, y - 2);
			dt[1] = BWAPI::TilePosition(x - 2, y + 0);
			return BWAPI::Position(32*x + 64, 32*y);
		}
	}
	//............vertical case............
	else { 
		if (dy > 0) {
			dt[0] = BWAPI::TilePosition(x - 3, y);
			dt[1] = BWAPI::TilePosition(x + 0, y);
			return BWAPI::Position(32*x, 32*y - 64);
		}
		else {
			dt[0] = BWAPI::TilePosition(x - 3, y - 2);
			dt[1] = BWAPI::TilePosition(x + 0, y - 2);
			return BWAPI::Position(32*x, 32*y + 64);
		}
	}
	return dp;
}

BWAPI::Position calculate_retreat_pos(BWAPI::Position my_pos) {
	int i = 0;
	int x = 0;
	int y = 0;
	for (BWAPI::Unit my_min : BWAPI::Broodwar->getMinerals()) {
		if (sqdist(my_pos, my_min->getPosition()) < 65536) {
			x += my_min->getPosition().x;
			y += my_min->getPosition().y;
			i += 1;
		}
	}
	if (i > 0) { return linear_interpol_abs(my_pos, BWAPI::Position{ x/i, y/i }, 96); }
	return my_pos;
}

BWAPI::Position find_gathering_pos(BWAPI::Position p1, BWAPI::Position p2) {
	int d1 = get_ground_dist(p1);
	int d2 = get_ground_dist(p2);
	if (d1 == -1) { d1 = d2 + 24; }
	if (d2 == -1) { d2 = d1 - 24; }
	int dm = (d1 + d2) / 2;

	BWAPI::Position min_pos = wilmap::center_pos;
	int min_dist = 67108864;

	for (int y = 0; y < wilmap::ht; y++) {
		for (int x = 0; x < wilmap::wt; x++)
		{
			if (min_dist > abs(get_ground_dist(x, y) - dm) &&
				get_ground_dist(x, y) > d1 &&
				get_ground_dist(x, y) < d2 &&
				wilmap::walk_map[y - 2][x - 1] &&
				wilmap::walk_map[y + 2][x + 1] &&
				wilmap::walk_map[y + 1][x - 2] &&
				wilmap::walk_map[y - 1][x + 2])
			{
				min_dist = abs(get_ground_dist(x, y) - dm);
				min_pos = BWAPI::Position{ 32 * x + 16 , 32 * y + 16 };
			}
		}
	}

	if (min_pos != wilmap::center_pos) {
		BWAPI::Broodwar->printf("found gather position");
	}
	return min_pos;
}





//BWAPI::TilePosition tn = get_center_tile(willyt::natu_pos);
//BWAPI::TilePosition t1 = find_path_min(8, willyt::dist_map[tn.y][tn.x] - 8);
//BWAPI::TilePosition t2 = find_path_min(willyt::dist_map[t1.y][t1.x] + 16, willyt::dist_map[tn.y][tn.x] + 24);
//clear_map_bool(willyt::choke_map);
//
//if (t1) {
//	std::vector<int> v1;
//	flood_fill_choke(t1.x, t1.y, willyt::space_map[t1.y][t1.x] + 3, v1);
//	main_choke_pos = get_center(v1);
//	my_main_def = find_def_area(tmc, 0, dist_map[tmc.y][tmc.x] - 6);
//	my_main_def = fill_def_area(BWAPI::Position(tmc), my_main_def, main_def_tiles);
//}
//
//if (t2) {
//	std::vector<int> v2;
//	flood_fill_choke(t2.x, t2.y, willyt::space_map[t2.y][t2.x] + 3, v2);
//	natu_choke_pos = get_center(v2);
//	my_natu_def = find_def_area(tnc, 0, dist_map[tnc.y][tnc.x] - 6);
//	my_natu_def = fill_def_area(BWAPI::Position(tnc), my_natu_def, natu_def_tiles);
//}

//BWAPI::TilePosition ArmyPositions::find_path_min(int d0, int d1) {
//	BWAPI::TilePosition tmin = BWAPI::TilePositions::None;
//	BWAPI::TilePosition t = get_center_tile(willyt::start_pos);
//	int cmin = 1024;
//	int d = 0;
//	while (d <= d1) {
//		t = path_fore(t);
//		if (d >= d0 &&
//			cmin > willyt::space_map[t.y][t.x]) {
//			cmin = willyt::space_map[t.y][t.x];
//			tmin = t;
//		}
//		if (d == willyt::dist_map[t.y][t.x]) { break; }
//		else { d = willyt::dist_map[t.y][t.x]; }
//	}
//	return tmin;
//}
//
//BWAPI::TilePosition ArmyPositions::path_fore(BWAPI::TilePosition t) {
//	int x = t.x;
//	int y = t.y;
//	int i = willyt::dist_map[y][x];
//	if (willyt::path_map[y + 1][x + 1] == i + 3) { return BWAPI::TilePosition(x + 1, y + 1); }
//	if (willyt::path_map[y - 1][x + 1] == i + 3) { return BWAPI::TilePosition(x + 1, y - 1); }
//	if (willyt::path_map[y + 1][x - 1] == i + 3) { return BWAPI::TilePosition(x - 1, y + 1); }
//	if (willyt::path_map[y - 1][x - 1] == i + 3) { return BWAPI::TilePosition(x - 1, y - 1); }
//	if (willyt::path_map[y + 1][x] == i + 2) { return BWAPI::TilePosition(x, y + 1); }
//	if (willyt::path_map[y - 1][x] == i + 2) { return BWAPI::TilePosition(x, y - 1); }
//	if (willyt::path_map[y][x + 1] == i + 2) { return BWAPI::TilePosition(x + 1, y); }
//	if (willyt::path_map[y][x - 1] == i + 2) { return BWAPI::TilePosition(x - 1, y); }
//	return t;
//}
//
//void ArmyPositions::flood_fill_choke(int x, int y, int z, std::vector<int> &v) {
//	if (willyt::space_map[y][x] != -1 &&
//		willyt::space_map[y][x] <= z &&
//		willyt::choke_map[y][x] == false) {
//		willyt::choke_map[y][x] = true;
//		v.push_back(x);
//		v.push_back(y);
//		flood_fill_choke(x + 1, y, z, v);
//		flood_fill_choke(x, y + 1, z, v);
//		flood_fill_choke(x - 1, y, z, v);
//		flood_fill_choke(x, y - 1, z, v);
//	}
//}

//BWAPI::Position ArmyPositions::get_center(std::vector<int> &v) {
//	int x = 0;
//	int y = 0;
//	for (std::vector<int>::iterator it = v.begin(); it != v.end(); it += 2) {
//		x += *it;
//		y += *(it + 1);
//	}
//	if (v.size() == 0) { return BWAPI::Positions::None; }
//	return BWAPI::Position(16 + 64 * x / v.size(), 16 + 64 * y / v.size());
//}






//void MapAnalysis::create_width_map() {
//	clear_map_int(willyt::width_map);
//	BWAPI::Position pm = willyt::start_pos;
//	BWAPI::Position pn = willyt::natu_pos;
//	BWAPI::TilePosition tm = BWAPI::TilePosition(pm.x/32 - 1, pm.y/32);
//	BWAPI::TilePosition tn = BWAPI::TilePosition(pn.x/32 - 1, pn.y/32);
//	BWAPI::TilePosition t0;
//	BWAPI::TilePosition t1 = tm;
//	BWAPI::TilePosition t2 = path_fore(tm);
//	int n = 0;
//
//	while (n < 128) {
//		t0 = t1;
//		t1 = t2;
//		t2 = path_fore(t2);
//
//		int dx1 = t1.x - t0.x;
//		int dy1 = t1.y - t0.y;
//		int dx2 = t2.x - t1.x;
//		int dy2 = t2.y - t1.y;
//
//		willyt::width_map[t1.y][t1.x] = (measure_width(t1, dx1, dy1) + measure_width(t1, dx2, dy2)) / 2;
//		if ( n == willyt::dist_map[t1.y][t1.x] ) { return; }
//		else { n = willyt::dist_map[t1.y][t1.x]; }
//	}
//}

//int MapAnalysis::measure_width(BWAPI::TilePosition t, int dx, int dy) {
//	int i = 0;
//	if (dx != 0 && dy != 0) {
//		i += 3;
//		i += measure_side(t, -dy, +dx, 3);
//		i += measure_side(t, +dy, -dx, 3);
//	}
//	else {
//		i += 2;
//		i += measure_side(t, -dy, +dx, 2);
//		i += measure_side(t, +dy, -dx, 2);
//	}
//	return i;
//}

//int MapAnalysis::measure_side(BWAPI::TilePosition t, int dx, int dy, int di) {
//	int i = 0;
//	for (int n = 1; n <= 24/di; n++) {
//		if (willyt::walk_map[t.y + n * dy][t.x + n * dx]) { i += di; }
//		else { break; }
//	}
//	return i;
//}