#include "ArmyManager.h"

void ArmyManager::update() {

	int n = wilunits::sup_bio + wilunits::sup_mech;
	int d = wilunits::sup_bio + wilunits::sup_mech + wilunits::sup_mil + 2 * wilbuild::bunkers.size();
	bool should_attack = decide_attack(n);
	bool under_attack = check_base_under_attack();

	update_siegetank_influence();
	willyt::siege_pos = calc_tank_center();
	willyt::guard_siege = check_siege_guarding();
	willyt::stim_allowed = check_stim_medics();

	willyt::gather_pos = get_gathering_position();
	willyt::def_target_pos = get_defending_target_position(wilenemy::intruders);
	willyt::att_target_pos = get_attacking_target_position(should_attack);

	willyt::is_swarming = check_swarming(should_attack);
	willyt::is_choke_def = check_main_or_natu_choke_defense();
	check_militia(under_attack, d, wilenemy::intruder_totstr);
	check_cohesion(n);

	if (willyt::def_target_pos == BWAPI::Positions::None &&
		willyt::att_target_pos == BWAPI::Positions::None &&
		willyt::is_swarming == false) {
		army_attack(willyt::gather_pos);
	}
	if (willyt::def_target_pos != BWAPI::Positions::None &&
		willyt::att_target_pos == BWAPI::Positions::None) {
		army_split(willyt::def_target_pos, willyt::gather_pos, wilenemy::intruder_totstr, wilenemy::intruder_airstr);
	}
	if (willyt::def_target_pos == BWAPI::Positions::None &&
		willyt::att_target_pos != BWAPI::Positions::None) {
		army_attack(willyt::att_target_pos);
	}
	if (willyt::def_target_pos != BWAPI::Positions::None &&
		willyt::att_target_pos != BWAPI::Positions::None) {
		army_split(willyt::def_target_pos, willyt::att_target_pos, wilenemy::intruder_totstr, wilenemy::intruder_airstr);
	}
	return;
}





bool ArmyManager::decide_attack(int n) {
	if ((willyt::att_target_pos != BWAPI::Positions::None && n >= willyt::attack_supply - 6) ||
		(willyt::att_target_pos == BWAPI::Positions::None && n >= willyt::attack_supply))
		return true;
	return false;
}

BWAPI::Position ArmyManager::get_gathering_position() {
	if (wilbuild::bunkers.size() > 0 && (willyt::rush_alert || willyt::proxy_alert))
		return wilbuild::bunkers.front()->getPosition();
	if (wilbuild::commandcenters.size() >= 2)
		return wilmap::my_natu_def;
	return wilmap::my_main_def;
}

BWAPI::Position ArmyManager::get_defending_target_position(std::vector<BWAPI::Unit>& my_vec) {
	if (hold_back_siegetank())
		return wilmap::my_main_def;
	BWAPI::Unit my_enemy = choose_enemy_from(my_vec);
	if (my_enemy != NULL)
		return estimate_next_pos(my_enemy, 24);
	return BWAPI::Positions::None;
}

BWAPI::Position ArmyManager::get_attacking_target_position(bool my_cond) {
	if (my_cond && !wilenemy::positions.empty())
		return choose_enemy_building(wilenemy::positions, wilenemy::main_pos);
	if (my_cond)
		return choose_enemy_unit();
	return BWAPI::Positions::None;
}

bool ArmyManager::check_swarming(bool my_cond) {
	if (my_cond && willyt::att_target_pos == BWAPI::Positions::None) {
		army_swarm(!willyt::is_swarming);
		return true;
	}
	return false;
}

void ArmyManager::check_militia(bool is_under_attack, int def_strength, int intr_strength) {

	if (willyt::rush_alert) {
		if (wilunits::sup_mil < 2 &&
			BWAPI::Broodwar->getFrameCount() >= 3000) {
			call_militia(2);
		}
		if (!is_under_attack &&
			wilunits::sup_mil > 2) {
			stop_militia();
		}
	}

	if (!willyt::hold_bunker &&
		is_under_attack &&
		def_strength < 12 &&
		def_strength < intr_strength) {
		call_militia(intr_strength - def_strength);
	}
	if (willyt::strategy == 1 &&
		willyt::first_attack == false &&
		willyt::att_target_pos != BWAPI::Positions::None) {
		willyt::first_attack = true;
		call_militia(7);
		create_repulsive_field_at_enemy_natural();
		//BWAPI::Broodwar->sendText("It's go time!");
	}
	if (wilunits::sup_mil > 0 &&
		!willyt::rush_alert &&
		!is_under_attack &&
		(BWAPI::Broodwar->elapsedTime() > 900 ||
		willyt::avoid_grddef ||
		willyt::att_target_pos == BWAPI::Positions::None)) {
		stop_militia();
		//BWAPI::Broodwar->sendText("stop militia");
	}
}

//void ArmyManager::check_defend(int d, int a, BWAPI::Unit enemy_attacker) {
//	using namespace willyt;
//
//	//defend if units in base
//	if (enemy_attacker && enemy_attacker->exists()) {
//		def_target_pos = estimate_next_pos(enemy_attacker, 24);
//	} else {
//		def_target_pos = BWAPI::Positions::None;
//	}
//
//	//high alert when attack on base
//	//call militia for help if needed
//	//under_attack = base_under_attack();
//	if (under_attack && d < 12 && d < a) {
//		call_militia(a - d);
//	}
//}

//void ArmyManager::check_attack(int n) {
//	using namespace willyt;
//
//	//determine attack state based on army supply
//	//choose attack target
//	//buildings, units, swarming
//	if (n >= attack_supply || 
//		(n + 6 >= attack_supply &&
//		att_target_pos != BWAPI::Positions::None)) {
//		if (true) {
//			att_target_pos = choose_enemy_building(wilenemy::positions, wilenemy::main_pos);
//		}
//		if (att_target_pos == BWAPI::Positions::None) {
//			att_target_pos = choose_enemy_unit();
//		}
//		if (att_target_pos == BWAPI::Positions::None) {
//			army_swarm(!is_swarming);
//			is_swarming = true;
//		} else {
//			is_swarming = false;
//		}
//		army_queue = 32;
//	} else {
//		att_target_pos = BWAPI::Positions::None;
//	}
//}

void ArmyManager::check_cohesion(int &n) {
	using namespace willyt;

	leader_pos = BWAPI::Positions::None;
	if (att_target_pos != BWAPI::Positions::None &&
		def_target_pos == BWAPI::Positions::None &&
		!is_swarming &&
		strategy != 6) {
		leader_pos = calc_leading_pos(att_target_pos);
	}
	if (leader_pos) {
		int a = count_around(leader_pos, 320);
		if (a < 20 && 2 * a < n) {
			att_target_pos = leader_pos;
			//army_queue = 8;
			//Broodwar->printf("Get together!");
		}
	}

	clear_repulsive_field_at_enemy_natural();
	return;
}





	//if (army_queue > 0) {
	//	army_queue--;
	//	if (willyt::att_target_pos != BWAPI::Positions::None ||
	//		willyt::def_target_pos != BWAPI::Positions::None) {
	//		return;
	//	}
	//}
	//else {
	//	army_queue = 16;
	//	//do everything
	//}

//void ArmyManager::check_cruisers() {
//	int dc = ((rand() % 2) * 2) - 1;
//	int i = 0;
//	for (auto &c : wilunits::cruisers) {
//		if (!c.is_swarming &&
//			!c.is_circling) { ++i; }
//	}
//	if (i >= 4) {
//		for (auto &c : wilunits::cruisers) {
//			if (!c.is_swarming &&
//				!c.is_circling) {
//				c.is_circling = true;
//				c.dc = dc;
//			}
//			BWAPI::Broodwar->printf("new battlecruiser attack group going %d", dc);
//		}
//	}
//	for (auto &c : wilunits::cruisers) {
//		if (abs(c.ic) > c.im) {
//			c.is_circling = false;
//			c.is_swarming = true;
//		}
//	}
//	return;
//}

//void ArmyManager::update_positions() {
//	int x = 0;
//	int y = 0;
//	int i = 0;
//	for (BWAPI::Unit &unit : willyt::commandcenters) {
//		x += unit->getPosition().x;
//		y += unit->getPosition().y;
//		++i;
//	}
//	for (BWAPI::Unit &unit : willyt::bunkers) {
//		x += unit->getPosition().x;
//		y += unit->getPosition().y;
//		++i;
//	}
//	if (i > 0) { gather_pos = BWAPI::Position{ x / i, y / i }; }
//	else { gather_pos = willyt::start_pos; }
//	//BWAPI::Broodwar->printf("Updating defense position.");
//}