#include "ArmyAttacker.h"

void army_attack(BWAPI::Position pos) {
	using namespace wilunits;

	for (SCV &s : scvs)				if (s.is_militia)	s.set_attack(pos);
	for (Fighter2 &m : marines)		if (!m.is_raider)	m.set_target(pos);
	for (Fighter2 &f : firebats)	if (!f.is_raider)	f.set_target(pos);
	for (Fighter2 &m : medics)		if (!m.is_raider)	m.set_target(pos);
	for (Fighter2 &g : ghosts)		if (!g.is_raider)	g.set_target(pos);
	for (Fighter2 &s : siegetanks)	if (!s.is_raider)	s.set_target(pos);
	for (Fighter2 &g : goliaths)	if (!g.is_raider)	g.set_target(pos);
	for (Fighter2 &v : vultures)	if (!v.is_raider)	v.set_target(pos);
	return;
}
void army_swarm(bool imm) {
	using namespace wilunits;

	for (SCV &s : scvs)				if (s.is_militia)	s.set_swarm(imm);
	for (Fighter2 &m : marines)		if (!m.is_raider)	m.set_swarm(imm);
	for (Fighter2 &f : firebats)	if (!f.is_raider)	f.set_swarm(imm);
	for (Fighter2 &m : medics)		if (!m.is_raider)	m.set_swarm(imm);
	for (Fighter2 &g : ghosts)		if (!g.is_raider)	g.set_swarm(imm);
	for (Fighter2 &t : siegetanks)	if (!t.is_raider)	t.set_swarm(imm);
	for (Fighter2 &g : goliaths)	if (!g.is_raider)	g.set_swarm(imm);
	for (Fighter2 &v : vultures)	if (!v.is_raider)	v.set_swarm(imm);
	return;
}


void army_split(BWAPI::Position& dpos, BWAPI::Position& apos, int enemytotstr, int enemyairstr) {
	using namespace wilunits;

	int aa = marines.size() + medics.size() / 2 + ghosts.size() + 2 * goliaths.size();
	int ag = sup_mil + firebats.size() + medics.size() / 2 + 2 * siegetanks.size() + 2 * vultures.size();
	float qa = 0.5;
	float qg = 0.5;

	if (enemytotstr >= 2 * enemyairstr) {						//just send of every unit
		if (aa + ag > 0) {
			qa = enemytotstr / (float)(aa + ag);
			qg = enemytotstr / (float)(aa + ag);
		}
	} else {													//only send anti air
		if (aa > 0) {
			qa = enemytotstr / (float)(aa);
			qg = 0.0;
			if (qa > 1.5) { qg = 0.5; }
		}
	}

	int d_marine  = 1 + (int)(qa * marines.size());
	int d_medic   = 1 + (int)(qa * medics.size());
	int d_ghost   = 1 + (int)(qa * ghosts.size());
	int d_goliath = 1 + (int)(qa * goliaths.size());

	int d_militia = 1 + (int)(qg * sup_mil);
	int d_firebat = 1 + (int)(qg * firebats.size());
	int d_sietank = 1 + (int)(qg * siegetanks.size());
	int d_vulture = 1 + (int)(qg * vultures.size());

	for (std::vector<SCV>::reverse_iterator it = scvs.rbegin(); it != scvs.rend(); ++it)
		if (it->is_militia)
			it->set_attack(decide_split(d_militia, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = marines.rbegin(); it != marines.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_marine, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = firebats.rbegin(); it != firebats.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_firebat, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = medics.rbegin(); it != medics.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_medic, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = ghosts.rbegin(); it != ghosts.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_ghost, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = siegetanks.rbegin(); it != siegetanks.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_sietank, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = goliaths.rbegin(); it != goliaths.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_goliath, dpos, apos));
	for (std::vector<Fighter2>::reverse_iterator it = vultures.rbegin(); it != vultures.rend(); ++it)
		if (!it->is_raider)
			it->set_target(decide_split(d_vulture, dpos, apos));

	//BWAPI::Broodwar->printf("defense fraction: %4.2f air, %4.2f grd", qa, qg);
	return;
}


BWAPI::Position decide_split(int& count, BWAPI::Position& dpos, BWAPI::Position& apos) {
	--count;
	if (count > -1) { return(dpos); }
	else { return(apos); }
}


//if (is_air) {
//	int g = goliaths.size();
//	float f = 0.0;
//	if (g > 0) { f = 2 * n / (float)g; }
//	d_goliath = 1 + (int)(f * a);
//	d_marine_ = 1 + (int)((a - f * a) * 0.83);
//	d_medic__ = 1 + (int)((a - f * a) * 0.17);
//	d_ghost__ = 1 + (int)((a - f * a) * 0.5); //i have no clue what i am doing here :-)
//	d_militia = 0;
//	d_firebat = 0;
//	d_sietank = 0;
//	d_vulture = 0;
//}
//else {
//	float q = 0.0;
//	if (n + m > 0) { q = a / (float)(n + m); } //20200428 found it turned around :-O
//	d_militia = 1 + (int)(q * m);
//	d_marine_ = 1 + (int)(q * marines.size());
//	d_firebat = 1 + (int)(q * firebats.size());
//	d_medic__ = 1 + (int)(q * medics.size());
//	d_ghost__ = 1 + (int)(q * ghosts.size());
//	d_sietank = 1 + (int)(q * siegetanks.size() / 2);
//	d_goliath = 1 + (int)(q * goliaths.size() / 2);
//	d_vulture = 1 + (int)(q * vultures.size() / 2);
//}
//BWAPI::Broodwar->printf("army split: %d to %d", n, a);
//BWAPI::Broodwar->printf("marines: %d of %d", d_marine_, marines.size());