/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.util;

public class MathUtils {
    private MathUtils() {
    }

    public static double distanceBetween(int left1, int top1, int right1, int bottom1, int left2, int top2, int right2, int bottom2) {
        return MathUtils.distanceWithDelta(MathUtils.calculateDelta(left1, right1, left2, right2), MathUtils.calculateDelta(top1, bottom1, top2, bottom2));
    }

    public static int estimateDistanceBetween(int x1, int y1, int x2, int y2) {
        return MathUtils.estimateDistanceWithDelta(x2 - x1, y2 - y1);
    }

    public static int estimateDistanceBetween(int left1, int top1, int right1, int bottom1, int left2, int top2, int right2, int bottom2) {
        return MathUtils.estimateDistanceWithDelta(MathUtils.calculateDelta(top1, bottom1, top2, bottom2), MathUtils.calculateDelta(left1, right1, left2, right2));
    }

    private static int calculateDelta(int topLeft1, int bottomRight1, int topLeft2, int bottomRight2) {
        int xDist = topLeft1 - bottomRight2;
        if (xDist < 0 && (xDist = topLeft2 - bottomRight1) < 0) {
            return 0;
        }
        return xDist;
    }

    private static int estimateDistanceWithDelta(int dx, int dy) {
        int min = Math.abs(dx);
        int max = Math.abs(dy);
        if (max < min) {
            int t = max;
            max = min;
            min = t;
        }
        if (min < max >> 2) {
            return max;
        }
        int minCalc = 3 * min >> 3;
        return (minCalc >> 5) + minCalc + max - (max >> 4) - (max >> 6);
    }

    private static double distanceWithDelta(int dx, int dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }
}

