/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.util;

import java.awt.image.ColorModel;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.BWAPI4J;
import org.openbw.bwapi4j.net.lingala.zip4j.core.ZipFile;
import org.openbw.bwapi4j.net.lingala.zip4j.exception.ZipException;
import org.openbw.bwapi4j.util.system.OSType;
import org.openbw.bwapi4j.util.system.SystemUtils;

public class DependencyManager {
    private static final Logger logger = LogManager.getLogger();
    private static final String SYSTEM_PROPERTY_JAVA_LIBRARY_PATH_ID = "java.library.path";

    public void extractDependencies(BWAPI4J.BridgeType bridgeType) {
        try {
            URL jarURL = BW.class.getProtectionDomain().getCodeSource().getLocation();
            Path jarFile = Paths.get(jarURL.toURI());
            Path cwd = this.getCurrentWorkingDirectory();
            if (Files.isRegularFile(jarFile, new LinkOption[0]) && !Files.isDirectory(jarFile, new LinkOption[0]) && jarFile.toString().endsWith(".jar")) {
                logger.debug("Extracting dependencies from: " + jarFile.toString());
                ZipFile jar = new ZipFile(jarFile.toFile());
                this.extractFileIfNotExists(jar, SystemUtils.resolvePlatformLibraryFilename(bridgeType.getLibraryName()), cwd.toString());
                for (String externalLibrary : this.getExternalLibraryNames()) {
                    this.extractFileIfNotExists(jar, SystemUtils.resolvePlatformLibraryFilename(externalLibrary), cwd.toString());
                }
            }
        }
        catch (Exception e) {
            logger.fatal("Failed to extract dependencies from JAR.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void extractFileIfNotExists(ZipFile zipFile, String sourceFilename, String targetDirectory) throws ZipException {
        Path targetFile = Paths.get(targetDirectory, sourceFilename);
        if (!(Files.isRegularFile(targetFile, new LinkOption[0]) || Files.isDirectory(targetFile, new LinkOption[0]) || Files.exists(targetFile, new LinkOption[0]))) {
            zipFile.extractFile(sourceFilename, targetDirectory);
        }
    }

    public void loadSharedLibraries(BWAPI4J.BridgeType bridgeType, boolean extractBridgeDependencies) {
        logger.info("jvm: {} ({}-bit)", (Object)System.getProperty("java.version"), (Object)System.getProperty("sun.arch.data.model"));
        logger.info("os: {}", (Object)System.getProperty("os.name"));
        logger.debug("cwd: {}", (Object)this.getCurrentWorkingDirectory().toString());
        logger.debug("user directory: {}", (Object)System.getProperty("user.dir"));
        logger.debug("bot directory: {}", (Object)BW.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        logger.debug("library path: " + this.getLibraryPath());
        logger.debug("bridge type: " + bridgeType.toString());
        OSType osType = OSType.computeType();
        if (osType.equals((Object)OSType.MAC)) {
            ColorModel.getRGBdefault();
        }
        List<String> sharedLibraries = this.getSharedLibraryNames(bridgeType);
        try {
            this.loadLibraries(sharedLibraries);
        }
        catch (UnsatisfiedLinkError e1) {
            this.addLibraryPath(this.getCurrentWorkingDirectory().toAbsolutePath().toString());
            if (extractBridgeDependencies) {
                this.extractDependencies(bridgeType);
            }
            try {
                this.loadLibraries(sharedLibraries);
            }
            catch (UnsatisfiedLinkError e2) {
                logger.fatal("Could not load shared libraries.", (Throwable)e2);
                e2.printStackTrace();
                System.exit(1);
            }
        }
        logger.info("Successfully loaded shared libraries.");
    }

    private void loadLibraries(List<String> libraries) {
        for (String library : libraries) {
            System.loadLibrary(library);
        }
    }

    private List<String> getSharedLibraryNames(BWAPI4J.BridgeType bridgeType) {
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add(bridgeType.getLibraryName());
        libraries.addAll(this.getExternalLibraryNames());
        return libraries;
    }

    private List<String> getExternalLibraryNames() {
        ArrayList<String> libNames = new ArrayList<String>();
        if (SystemUtils.isWindowsPlatform()) {
            // empty if block
        }
        return libNames;
    }

    private Path getCurrentWorkingDirectory() {
        return Paths.get("", new String[0]).toAbsolutePath();
    }

    private void forceLibraryPathReload() throws NoSuchFieldException, IllegalAccessException {
        Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
        sysPathsField.setAccessible(true);
        sysPathsField.set(null, null);
    }

    private String getLibraryPath() {
        return System.getProperty(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH_ID);
    }

    private void setLibraryPath(String path) {
        try {
            this.forceLibraryPathReload();
            System.setProperty(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH_ID, path);
            logger.info("Changed library path to: {}", (Object)this.getLibraryPath());
        }
        catch (Exception e) {
            logger.error("Could not modify library path to: " + path, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void addLibraryPath(String path) {
        try {
            String currentLibraryPath = this.getLibraryPath();
            if (SystemUtils.isPathFoundInPathVariable(path, currentLibraryPath)) {
                logger.warn("The specified path already exists in library path: " + path);
                return;
            }
            logger.info("Adding library path: {}", (Object)path);
            String libraryPathDelimiter = File.pathSeparator;
            String newLibraryPath = currentLibraryPath + (!currentLibraryPath.endsWith(libraryPathDelimiter) ? libraryPathDelimiter : "") + path;
            this.setLibraryPath(newLibraryPath);
        }
        catch (Exception e) {
            logger.error("Could not add library path: " + path, (Throwable)e);
            e.printStackTrace();
        }
    }
}

