/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.Building;

public interface ResearchingFacility
extends Building {
    public boolean isUpgrading();

    public boolean isResearching();

    public boolean cancelResearch();

    public boolean cancelUpgrade();

    public boolean canResearch(TechType var1);

    public boolean canUpgrade(UpgradeType var1);

    public boolean research(TechType var1);

    public boolean upgrade(UpgradeType var1);

    public UpgradeInProgress getUpgradeInProgress();

    public ResearchInProgress getResearchInProgress();

    public static class ResearchInProgress {
        public static final ResearchInProgress NONE = new ResearchInProgress(TechType.None, 0);
        private final TechType researchType;
        private final int remainingResearchTime;

        protected ResearchInProgress(TechType researchType, int remainingResearchTime) {
            this.researchType = researchType;
            this.remainingResearchTime = remainingResearchTime;
        }

        public int getRemainingResearchTime() {
            return this.remainingResearchTime;
        }

        public TechType getResearchType() {
            return this.researchType;
        }
    }

    public static class UpgradeInProgress {
        public static final UpgradeInProgress NONE = new UpgradeInProgress(UpgradeType.None, 0);
        private final UpgradeType upgradeType;
        private final int remainingUpgradeTime;

        protected UpgradeInProgress(UpgradeType upgradeType, int remainingUpgradeTime) {
            this.upgradeType = upgradeType;
            this.remainingUpgradeTime = remainingUpgradeTime;
        }

        public UpgradeType getUpgradeType() {
            return this.upgradeType;
        }

        public int getRemainingUpgradeTime() {
            return this.remainingUpgradeTime;
        }
    }
}

