/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.type;

import org.openbw.bwapi4j.type.IdMapperHelper;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.type.WithId;

public enum TechType implements WithId
{
    Stim_Packs(0),
    Lockdown(1),
    EMP_Shockwave(2),
    Spider_Mines(3),
    Scanner_Sweep(4),
    Tank_Siege_Mode(5),
    Defensive_Matrix(6),
    Irradiate(7),
    Yamato_Gun(8),
    Cloaking_Field(9),
    Personnel_Cloaking(10),
    Burrowing(11),
    Infestation(12),
    Spawn_Broodlings(13),
    Dark_Swarm(14),
    Plague(15),
    Consume(16),
    Ensnare(17),
    Parasite(18),
    Psionic_Storm(19),
    Hallucination(20),
    Recall(21),
    Stasis_Field(22),
    Archon_Warp(23),
    Restoration(24),
    Disruption_Web(25),
    Unused_26(26),
    Mind_Control(27),
    Dark_Archon_Meld(28),
    Feedback(29),
    Optical_Flare(30),
    Maelstrom(31),
    Lurker_Aspect(32),
    Unused_33(33),
    Healing(34),
    None(44),
    Nuclear_Strike(45),
    Unknown(46),
    MAX(47);

    int iD;
    Race race;
    int mineralPrice;
    int gasPrice;
    int researchTime;
    int energyCost;
    UnitType whatResearches;
    WeaponType weaponType;
    boolean targetsUnit;
    boolean targetsPosition;
    Order order;
    UnitType requiredUnit;

    private TechType(int id) {
        this.iD = id;
    }

    public static TechType withId(int id) {
        return IdMapper.techTypesForId[id];
    }

    @Override
    public int getId() {
        return this.iD;
    }

    public Race getRace() {
        return this.race;
    }

    public int mineralPrice() {
        return this.mineralPrice;
    }

    public int gasPrice() {
        return this.gasPrice;
    }

    public int researchTime() {
        return this.researchTime;
    }

    public int energyCost() {
        return this.energyCost;
    }

    public UnitType whatResearches() {
        return this.whatResearches;
    }

    public WeaponType getWeapon() {
        return this.weaponType;
    }

    public boolean targetsUnit() {
        return this.targetsUnit;
    }

    public boolean targetsPosition() {
        return this.targetsPosition;
    }

    public Order getOrder() {
        return this.order;
    }

    public UnitType requiredUnit() {
        return this.requiredUnit;
    }

    private static class IdMapper {
        static final TechType[] techTypesForId = (TechType[])IdMapperHelper.toIdTypeArray(TechType.class);

        private IdMapper() {
        }
    }
}

