/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.org.xguzm.pathfinding.grid.finders;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openbw.bwapi4j.org.xguzm.pathfinding.BHeap;
import org.openbw.bwapi4j.org.xguzm.pathfinding.Heuristic;
import org.openbw.bwapi4j.org.xguzm.pathfinding.NavigationGraph;
import org.openbw.bwapi4j.org.xguzm.pathfinding.NavigationNode;
import org.openbw.bwapi4j.org.xguzm.pathfinding.PathFinder;
import org.openbw.bwapi4j.org.xguzm.pathfinding.Util;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.NavigationGridGraph;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.NavigationGridGraphNode;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.finders.GridFinderOptions;
import org.openbw.bwapi4j.org.xguzm.pathfinding.grid.heuristics.EuclideanDistance;

public class JumpPointFinder<T extends NavigationGridGraphNode>
implements PathFinder<T> {
    BHeap<T> openList;
    private GridFinderOptions options;
    int jobId;
    private Heuristic euclideanDist = new EuclideanDistance();

    public JumpPointFinder(Class<T> clazz, GridFinderOptions options) {
        this.options = options;
        this.openList = new BHeap(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null || o2 == null) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return (int)(o1.getF() - o2.getF());
            }
        });
    }

    @Override
    public List<T> findPath(T startNode, T endNode, NavigationGraph<T> grid) {
        Util.validateNotNull(startNode, "Start node cannot be null");
        Util.validateNotNull(endNode, "End node cannot be null");
        if (this.jobId == Integer.MAX_VALUE) {
            this.jobId = 0;
        }
        int job = ++this.jobId;
        startNode.setG(0.0f);
        startNode.setF(0.0f);
        this.openList.clear();
        this.openList.add(startNode);
        startNode.setParent(null);
        startNode.setOpenedOnJob(job, this.getClass());
        while (this.openList.size > 0) {
            NavigationGridGraphNode node = (NavigationGridGraphNode)this.openList.pop();
            node.setClosedOnJob(job, this.getClass());
            if (node == endNode) {
                return Util.backtrace(endNode);
            }
            this.identifySuccesors(node, (NavigationGridGraph)grid, job, startNode, endNode);
        }
        return null;
    }

    public List<T> findPath(int startX, int startY, int endX, int endY, NavigationGridGraph<T> grid) {
        return this.findPath(grid.getCell(startX, startY), grid.getCell(endX, endY), grid);
    }

    private void identifySuccesors(T node, NavigationGridGraph<T> graph, int job, T start, T end) {
        List<T> neightbors = this.getNeighbors(node, graph);
        for (NavigationGridGraphNode neighbor : neightbors) {
            boolean isDiagonalJump;
            NavigationGridGraphNode jumpPoint = this.jump(neighbor, node, graph, start, end);
            if (jumpPoint == null || jumpPoint.getClosedOnJob(this.getClass()) == job) continue;
            boolean bl = isDiagonalJump = jumpPoint.getX() != node.getX() && jumpPoint.getY() != node.getY();
            if (isDiagonalJump && !this.options.allowDiagonal) continue;
            float distance = this.euclideanDist.calculate(jumpPoint, (NavigationNode)node);
            float ng = node.getG() + distance;
            if (jumpPoint.getOpenedOnJob(this.getClass()) == job && !(ng < neighbor.getG())) continue;
            float prevf = jumpPoint.getF();
            jumpPoint.setG(ng);
            jumpPoint.setH(this.options.heuristic.calculate(jumpPoint, (NavigationNode)end));
            jumpPoint.setF(neighbor.getG() + neighbor.getH());
            jumpPoint.setParent((NavigationNode)node);
            if (jumpPoint.getOpenedOnJob(this.getClass()) != job) {
                this.openList.add(jumpPoint);
                jumpPoint.setOpenedOnJob(job, this.getClass());
                continue;
            }
            this.openList.updateNode(neighbor, neighbor.getF() - prevf);
        }
    }

    private List<T> getNeighbors(T node, NavigationGridGraph<T> grid) {
        NavigationGridGraphNode parent = (NavigationGridGraphNode)node.getParent();
        if (parent != null) {
            int px = parent.getX();
            int py = parent.getY();
            int x = node.getX();
            int y = node.getY();
            int dx = this.clamp(-1, 1, x - px);
            int dy = this.clamp(-1, 1, y - py);
            int n = this.options.isYDown ? -1 : 1;
            ArrayList<T> neighbors = new ArrayList<T>();
            boolean allowDiagonal = this.allowedDiagonalMovement(node, dx, dy *= n, grid);
            if (dx != 0 && dy != 0) {
                if (grid.isWalkable(x, y + dy)) {
                    neighbors.add(grid.getCell(x, y + dy));
                }
                if (grid.isWalkable(x + dx, y)) {
                    neighbors.add(grid.getCell(x + dx, y));
                }
                if (grid.isWalkable(x, y + dy) || grid.isWalkable(x + dx, y)) {
                    neighbors.add(grid.getCell(x + dx, y + dy));
                }
                if (!grid.isWalkable(x - dx, y) && grid.isWalkable(x, y + dy)) {
                    neighbors.add(grid.getCell(x - dx, y + dy));
                }
                if (!grid.isWalkable(x, y - dy) && grid.isWalkable(x + dx, y)) {
                    neighbors.add(grid.getCell(x + dx, y - dy));
                }
            } else if (dx == 0) {
                if (grid.isWalkable(x, y + dy)) {
                    neighbors.add(grid.getCell(x, y + dy));
                    if (allowDiagonal && !grid.isWalkable(x + 1, y)) {
                        neighbors.add(grid.getCell(x + 1, y + dy));
                    }
                    if (allowDiagonal && !grid.isWalkable(x - 1, y)) {
                        neighbors.add(grid.getCell(x - 1, y + dy));
                    }
                }
                if (!allowDiagonal) {
                    if (grid.isWalkable(x + 1, y)) {
                        neighbors.add(grid.getCell(x + 1, y));
                    }
                    if (grid.isWalkable(x - 1, y)) {
                        neighbors.add(grid.getCell(x - 1, y));
                    }
                }
            } else {
                if (grid.isWalkable(x + dx, y)) {
                    neighbors.add(grid.getCell(x + dx, y));
                    if (allowDiagonal && !grid.isWalkable(x, y + 1)) {
                        neighbors.add(grid.getCell(x + dx, y + 1));
                    }
                    if (allowDiagonal && !grid.isWalkable(x, y - 1)) {
                        neighbors.add(grid.getCell(x + dx, y - 1));
                    }
                }
                if (!allowDiagonal) {
                    if (grid.isWalkable(x, y + 1)) {
                        neighbors.add(grid.getCell(x, y + 1));
                    }
                    if (grid.isWalkable(x, y - 1)) {
                        neighbors.add(grid.getCell(x, y - 1));
                    }
                }
            }
            return neighbors;
        }
        return grid.getNeighbors(node, this.options);
    }

    private T jump(T node, T parent, NavigationGridGraph<T> grid, T start, T end) {
        T nextJump;
        int x = node.getX();
        int y = node.getY();
        int parentX = parent.getX();
        int parentY = parent.getY();
        int dx = x - parentX;
        int dy = y - parentY;
        dy *= this.options.isYDown ? -1 : 1;
        if (!grid.isWalkable(x, y)) {
            return null;
        }
        if (x == end.getX() && y == end.getY()) {
            return grid.getCell(x, y);
        }
        boolean allowDiagonal = this.allowedDiagonalMovement(node, dx, dy, grid);
        if (dx != 0 && dy != 0 ? grid.isWalkable(x - dx, y + dy) && !grid.isWalkable(x - dx, y) || grid.isWalkable(x + dx, y - dy) && !grid.isWalkable(x, y - dy) : (dx != 0 ? allowDiagonal && (grid.isWalkable(x + dx, y + 1) && !grid.isWalkable(x, y + 1) || grid.isWalkable(x + dx, y - 1) && !grid.isWalkable(x, y - 1)) : allowDiagonal && (grid.isWalkable(x + 1, y + dy) && !grid.isWalkable(x + 1, y) || grid.isWalkable(x - 1, y + dy) && !grid.isWalkable(x - 1, y)))) {
            return node;
        }
        if (dx != 0 && dy != 0) {
            if (grid.isWalkable(x + dx, y)) {
                return this.jump(grid.getCell(x + dx, y), node, grid, start, end);
            }
            if (grid.isWalkable(x, y + dy)) {
                return this.jump(grid.getCell(x, y + dy), node, grid, start, end);
            }
        }
        if (grid.isWalkable(x + dx, y + dy) && (nextJump = this.jump(grid.getCell(x + dx, y + dy), node, grid, start, end)) != null) {
            return nextJump;
        }
        if (!allowDiagonal) {
            if (dx == 0 && (grid.isWalkable(x, y + 1) || grid.isWalkable(x, y - 1))) {
                return node;
            }
            if (dy == 0 && (grid.isWalkable(x + 1, y) || grid.isWalkable(x - 1, y))) {
                return node;
            }
        }
        return null;
    }

    int clamp(int min, int max, int val) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    boolean allowedDiagonalMovement(T node, int dx, int dy, NavigationGridGraph<T> grid) {
        if (this.options.allowDiagonal) {
            if (!this.options.dontCrossCorners) {
                return true;
            }
            if (dx != 0 && dy != 0) {
                return true;
            }
            if (dx == 0) {
                return (grid.isWalkable(node.getX() + 1, node.getY()) || grid.isWalkable(node.getX() - 1, node.getY())) && grid.isWalkable(node.getX(), node.getY() + dy);
            }
            return (grid.isWalkable(node.getX(), node.getY() + 1) || grid.isWalkable(node.getX(), node.getY() - 1)) && grid.isWalkable(node.getX() + dx, node.getY());
        }
        return false;
    }
}

