/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.WalkPosition;

public class TilePosition {
    public static final int SIZE_IN_PIXELS = 32;
    private final int x;
    private final int y;

    public TilePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public TilePosition(WalkPosition walkPosition) {
        this.x = walkPosition.getX() * 8 / 32;
        this.y = walkPosition.getY() * 8 / 32;
    }

    public TilePosition(Position position) {
        this.x = position.getX() / 32;
        this.y = position.getY() / 32;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getDistance(TilePosition position) {
        double dx = this.getX() - position.getX();
        double dy = this.getY() - position.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public WalkPosition toWalkPosition() {
        int x = this.getX() * 32 / 8;
        int y = this.getY() * 32 / 8;
        return new WalkPosition(x, y);
    }

    public Position toPosition() {
        int x = this.getX() * 32;
        int y = this.getY() * 32;
        return new Position(x, y);
    }

    public TilePosition add(TilePosition tilePosition) {
        int x = this.getX() + tilePosition.getX();
        int y = this.getY() + tilePosition.getY();
        return new TilePosition(x, y);
    }

    public TilePosition subtract(TilePosition tilePosition) {
        int x = this.getX() - tilePosition.getX();
        int y = this.getY() - tilePosition.getY();
        return new TilePosition(x, y);
    }

    public TilePosition multiply(TilePosition tilePosition) {
        int x = this.getX() * tilePosition.getX();
        int y = this.getY() * tilePosition.getY();
        return new TilePosition(x, y);
    }

    public TilePosition divide(TilePosition tilePosition) {
        int x = this.getX() / tilePosition.getX();
        int y = this.getY() / tilePosition.getY();
        return new TilePosition(x, y);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TilePosition)) {
            return false;
        }
        TilePosition tilePosition = (TilePosition)object;
        if (this.getX() != tilePosition.getX()) {
            return false;
        }
        return this.getY() == tilePosition.getY();
    }

    public int hashCode() {
        return this.getX() * 2048 + this.getY();
    }
}

