/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.BwError;
import org.openbw.bwapi4j.type.GameType;
import org.openbw.bwapi4j.type.Key;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.util.BridgeUtils;
import org.openbw.bwapi4j.util.Cache;

public final class InteractionHandler {
    private static final Logger logger = LogManager.getLogger();
    private final BW bw;
    private int screenPositionX;
    private int screenPositionY;
    private int screenSizeX;
    private int screenSizeY;
    private int mousePositionX;
    private int mousePositionY;
    private int frameCount;
    private int fps;
    private double averageFPS;
    private boolean latComEnabled;
    private int remainingLatencyFrames;
    private int latencyFrames;
    private int latency;
    private int selfId;
    private int enemyId;
    private int gameTypeId;
    private boolean isReplay;
    private boolean isPaused;
    private int apm;
    private int apm_including_selects;
    private Cache<List<Player>> getAlliesCache;
    private Cache<List<Player>> getEnemiesCache;
    private Cache<List<Position>> getNukeDotsCache;

    InteractionHandler(BW bw) {
        this.bw = bw;
        this.resetCache();
    }

    void resetCache() {
        this.getAlliesCache = new Cache<List>(this::allies_from_native, this);
        this.getEnemiesCache = new Cache<List>(this::enemies_from_native, this);
        this.getNukeDotsCache = new Cache<List>(this::getNukeDotsData, this);
    }

    void update(int[] data) {
        this.screenPositionX = data[CacheIndex.SCREEN_POSITION_X.ordinal()];
        this.screenPositionY = data[CacheIndex.SCREEN_POSITION_Y.ordinal()];
        this.screenSizeX = data[CacheIndex.SCREEN_SIZE_X.ordinal()];
        this.screenSizeY = data[CacheIndex.SCREEN_SIZE_Y.ordinal()];
        this.mousePositionX = data[CacheIndex.MOUSE_POSITION_X.ordinal()];
        this.mousePositionY = data[CacheIndex.MOUSE_POSITION_Y.ordinal()];
        this.frameCount = data[CacheIndex.FRAME_COUNT.ordinal()];
        this.fps = data[CacheIndex.FPS.ordinal()];
        this.averageFPS = BridgeUtils.parsePreservedDouble(data[CacheIndex.AVERAGE_FPS.ordinal()]);
        this.latComEnabled = data[CacheIndex.LATCOM_ENABLED.ordinal()] == 1;
        this.remainingLatencyFrames = data[CacheIndex.REMAINING_LATENCY_FRAMES.ordinal()];
        this.latencyFrames = data[CacheIndex.LATENCY_FRAMES.ordinal()];
        this.latency = data[CacheIndex.LATENCY.ordinal()];
        this.selfId = data[CacheIndex.SELF_ID.ordinal()];
        this.enemyId = data[CacheIndex.ENEMY_ID.ordinal()];
        this.gameTypeId = data[CacheIndex.GAME_TYPE_ID.ordinal()];
        this.isReplay = data[CacheIndex.IS_REPLAY.ordinal()] == 1;
        this.isPaused = data[CacheIndex.IS_PAUSED.ordinal()] == 1;
        this.apm = data[CacheIndex.APM.ordinal()];
        this.apm_including_selects = data[CacheIndex.APM_INCLUDING_SELECTS.ordinal()];
    }

    public void createUnit(Player owner, UnitType type, int posX, int posY) {
        this.bw.createUnit(owner, type, posX, posY);
    }

    public void killUnit(Unit unit) {
        this.bw.killUnit(unit);
    }

    public Player self() {
        return this.bw.getPlayer(this.selfId);
    }

    public Player enemy() {
        return this.bw.getPlayer(this.enemyId);
    }

    public List<Player> allies() {
        return this.getAlliesCache.get();
    }

    private native int[] allies_native();

    private List<Player> allies_from_native() {
        int[] data = this.allies_native();
        return this.parsePlayers(data);
    }

    public List<Player> enemies() {
        return this.getEnemiesCache.get();
    }

    private native int[] enemies_native();

    private List<Player> enemies_from_native() {
        int[] data = this.enemies_native();
        return this.parsePlayers(data);
    }

    private List<Player> parsePlayers(int[] data) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (int i = 0; i < data.length; ++i) {
            int playerId = data[i];
            Player player = this.bw.getPlayer(playerId);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    private native int getLastError_native();

    public BwError getLastError() {
        int lastErrorId = this.getLastError_native();
        return BwError.values()[lastErrorId];
    }

    public Position getScreenPosition() {
        return new Position(this.screenPositionX, this.screenPositionY);
    }

    private native void setScreenPosition_native(int var1, int var2);

    public void setScreenPosition(Position position) {
        this.setScreenPosition_native(position.getX(), position.getY());
    }

    public Position getScreenSize() {
        return new Position(this.screenSizeX, this.screenSizeY);
    }

    public Position getMousePosition() {
        return new Position(this.mousePositionX, this.mousePositionY);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFPS() {
        return this.fps;
    }

    public double getAverageFPS() {
        return this.averageFPS;
    }

    public boolean isLatComEnabled() {
        return this.latComEnabled;
    }

    public int getRemainingLatencyFrames() {
        return this.remainingLatencyFrames;
    }

    public int getLatencyFrames() {
        return this.latencyFrames;
    }

    public int getLatency() {
        return this.latency;
    }

    public GameType getGameType() {
        return GameType.values()[this.gameTypeId];
    }

    public boolean isReplay() {
        return this.isReplay;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getAPM() {
        return this.apm;
    }

    public int getAPM(boolean includeSelects) {
        return includeSelects ? this.apm_including_selects : this.apm;
    }

    public List<Unit> getSelectedUnits() {
        return this.bw.getAllUnits().stream().filter(Unit::isSelected).collect(Collectors.toList());
    }

    public boolean isKeyPressed(Key key) {
        return this.getKeyState(key.getValue());
    }

    private native boolean getKeyState(int var1);

    public native void leaveGame();

    public void sendTextAndLog(String text) {
        logger.info(text);
        this.sendText(text);
    }

    public native void printf(String var1);

    public native void sendText(String var1);

    public native void setLocalSpeed(int var1);

    public native void enableLatCom(boolean var1);

    public native void enableUserInput();

    public native void enableCompleteMapInformation();

    public native long getRandomSeed();

    public native void setFrameSkip(int var1);

    public native void pauseGame();

    public native void resumeGame();

    public native void restartGame();

    public native void setGUI(boolean var1);

    private native int[] getNukeDotsData_native();

    private List<Position> getNukeDotsData() {
        ArrayList<Position> nukeDotPositions = new ArrayList<Position>();
        int[] data = this.getNukeDotsData_native();
        int index = 0;
        while (index < data.length) {
            int x = data[index++];
            int y = data[index++];
            Position nukeDotPosition = new Position(x, y);
            nukeDotPositions.add(nukeDotPosition);
        }
        return nukeDotPositions;
    }

    public List<Position> getNukeDots() {
        return this.getNukeDotsCache.get();
    }

    private static enum CacheIndex {
        SCREEN_POSITION_X,
        SCREEN_POSITION_Y,
        SCREEN_SIZE_X,
        SCREEN_SIZE_Y,
        MOUSE_POSITION_X,
        MOUSE_POSITION_Y,
        FRAME_COUNT,
        FPS,
        AVERAGE_FPS,
        LATCOM_ENABLED,
        REMAINING_LATENCY_FRAMES,
        LATENCY_FRAMES,
        LATENCY,
        GAME_TYPE_ID,
        IS_REPLAY,
        IS_PAUSED,
        APM,
        APM_INCLUDING_SELECTS,
        SELF_ID,
        ENEMY_ID;

    }
}

