/*
 * Decompiled with CFR 0.152.
 */
package org.iaie.btree.task;

import ecgberht.GameState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iaie.btree.BehavioralTree;

public abstract class Task {
    protected final List<Task> children;
    private final String name;
    protected GameState gameState;
    protected BehavioralTree.State state = BehavioralTree.State.READY;

    public Task(String name, GameState gh) {
        this.name = name;
        this.children = new ArrayList<Task>();
        this.gameState = gh;
    }

    public Task(String name, GameState gh, Task ... tasks) {
        this(name, gh);
        this.children.addAll(Arrays.asList(tasks));
    }

    public String getName() {
        return this.name;
    }

    public void addChild(Task task) {
        this.children.add(task);
    }

    public Task getChild(int i) {
        return this.children.get(i);
    }

    public final void running() {
        this.state = BehavioralTree.State.RUNNING;
    }

    public final void success() {
        this.state = BehavioralTree.State.SUCCESS;
    }

    public final void failure() {
        this.state = BehavioralTree.State.FAILURE;
    }

    public abstract BehavioralTree.State run();
}

