/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Util;

import ecgberht.Ecgberht;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Set;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Medic;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.ScienceVessel;
import org.openbw.bwapi4j.unit.Unit;

public class UtilMicro {
    public static void attack(MobileUnit attacker, Position pos) {
        if (pos == null || attacker == null || !attacker.exists() || attacker.isAttackFrame() || attacker.isStartingAttack()) {
            return;
        }
        if (Ecgberht.getGs().frameCount == attacker.getLastCommandFrame()) {
            return;
        }
        Position targetPos = attacker.getTargetPosition();
        if (pos.equals(targetPos) || targetPos != null && pos.toTilePosition().equals(targetPos.toTilePosition())) {
            return;
        }
        if (!Ecgberht.getGs().getGame().getBWMap().isValidPosition(pos)) {
            return;
        }
        if (!attacker.isFlying() && !Ecgberht.getGs().getGame().getBWMap().isWalkable(pos.toWalkPosition())) {
            return;
        }
        attacker.attack(pos);
    }

    public static void attack(UnitInfo attacker, UnitInfo target) {
        try {
            Attacker attackerUnit = (Attacker)attacker.unit;
            if (attackerUnit == null || target == null || !attackerUnit.exists() || attackerUnit.isStartingAttack() || attackerUnit.isAttackFrame()) {
                return;
            }
            if (Ecgberht.getGs().frameCount == attackerUnit.getLastCommandFrame()) {
                return;
            }
            Unit targetUnit = attackerUnit.getTargetUnit();
            if (target.unit.equals(targetUnit)) {
                return;
            }
            if (target.visible) {
                WeaponType w = Util.getWeapon(attacker, target);
                double range = attacker.player.getUnitStatCalculator().weaponMaxRange(w);
                if ((double)attacker.getDistance(target) <= range) {
                    attackerUnit.attack(target.unit);
                    return;
                }
                Position predicted = UtilMicro.predictUnitPosition(target, 3);
                if (predicted != null) {
                    UtilMicro.move((MobileUnit)((Object)attackerUnit), predicted);
                }
            } else {
                UtilMicro.move((MobileUnit)((Object)attackerUnit), target.lastPosition);
            }
        }
        catch (Exception e) {
            System.err.println("UtilMicro Attack Exception");
            e.printStackTrace();
        }
    }

    public static void attack(Attacker attacker, UnitInfo target) {
        try {
            if (attacker == null || target == null || !attacker.exists() || attacker.isStartingAttack() || attacker.isAttackFrame()) {
                return;
            }
            if (Ecgberht.getGs().frameCount == attacker.getLastCommandFrame()) {
                return;
            }
            Unit targetUnit = attacker.getTargetUnit();
            if (target.unit.equals(targetUnit)) {
                return;
            }
            if (target.visible) {
                attacker.attack(target.unit);
            } else {
                UtilMicro.move((MobileUnit)((Object)attacker), target.lastPosition);
            }
        }
        catch (Exception e) {
            System.err.println("UtilMicro Attack Exception");
            e.printStackTrace();
        }
    }

    public static void irradiate(ScienceVessel vessel, PlayerUnit target) {
        Unit targetUnit;
        if (vessel == null || target == null || !vessel.exists() || !target.exists()) {
            return;
        }
        if (vessel.getOrder() == Order.CastIrradiate && target.equals(targetUnit = vessel.getTargetUnit())) {
            return;
        }
        vessel.irradiate(target);
    }

    public static void defenseMatrix(ScienceVessel vessel, MobileUnit target) {
        Unit targetUnit;
        if (vessel == null || target == null || !vessel.exists() || !target.exists()) {
            return;
        }
        if (vessel.getOrder() == Order.CastDefensiveMatrix && target.equals(targetUnit = vessel.getTargetUnit())) {
            return;
        }
        vessel.defensiveMatrix(target);
    }

    public static void emp(ScienceVessel vessel, Position pos) {
        Position targetPos;
        if (pos == null || vessel == null || !vessel.exists()) {
            return;
        }
        if (vessel.getOrder() == Order.CastEMPShockwave && pos.equals(targetPos = vessel.getTargetPosition())) {
            return;
        }
        vessel.empShockWave(pos);
    }

    public static void move(MobileUnit u, Position pos) {
        if (pos == null || u == null || !u.exists()) {
            return;
        }
        if (Ecgberht.getGs().frameCount == u.getLastCommandFrame()) {
            return;
        }
        Position targetPos = u.getTargetPosition();
        if (pos.equals(targetPos) || targetPos != null && pos.toTilePosition().equals(targetPos.toTilePosition())) {
            return;
        }
        if (!Ecgberht.getGs().getGame().getBWMap().isValidPosition(pos)) {
            return;
        }
        if (!u.isFlying() && !Ecgberht.getGs().getGame().getBWMap().isWalkable(pos.toWalkPosition())) {
            return;
        }
        u.move(pos);
    }

    public static Position kiteAway(Unit unit, Set<UnitInfo> enemies) {
        try {
            if (enemies.isEmpty()) {
                return null;
            }
            Position ownPosition = unit.getPosition();
            ArrayList<MutablePair<Double, Double>> vectors = new ArrayList<MutablePair<Double, Double>>();
            for (UnitInfo enemy : enemies) {
                Position enemyPosition = enemy.position;
                Position sub = ownPosition.subtract(enemyPosition);
                MutablePair<Double, Double> unitV = new MutablePair<Double, Double>(Double.valueOf(sub.getX()), Double.valueOf(sub.getY()));
                vectors.add(unitV);
            }
            MutablePair<Double, Double> sumAll = Util.sumPosition(vectors);
            return Util.cropPosition(Util.sumPosition(ownPosition, new Position((int)((Double)sumAll.first / (double)vectors.size()), (int)((Double)sumAll.second / (double)vectors.size()))));
        }
        catch (Exception e) {
            System.err.println("KiteAway Exception");
            e.printStackTrace();
            return null;
        }
    }

    public static void heal(Medic u, PlayerUnit heal) {
        if (u == null || heal == null || u.getLastCommandFrame() == Ecgberht.getGs().frameCount) {
            return;
        }
        Unit targetUnit = u.getTargetUnit();
        if (heal.equals(targetUnit)) {
            return;
        }
        u.heal(heal);
    }

    public static void heal(Medic u, Position heal) {
        if (u == null || heal == null || !Ecgberht.getGs().bw.getBWMap().isValidPosition(heal)) {
            return;
        }
        if (u.getLastCommandFrame() == Ecgberht.getGs().frameCount) {
            return;
        }
        Position targetPos = u.getTargetPosition();
        if (heal.equals(targetPos) || targetPos != null && heal.toTilePosition().equals(targetPos.toTilePosition())) {
            return;
        }
        u.heal(heal);
    }

    public static void stop(MobileUnit u) {
        if (Ecgberht.getGs().frameCount == u.getLastCommandFrame()) {
            return;
        }
        if (u.getOrder() == Order.Stop) {
            return;
        }
        u.stop(false);
    }

    public static Position predictUnitPosition(UnitInfo unit, int frames) {
        if (unit == null) {
            return null;
        }
        if (unit.speed == 0.0) {
            return unit.lastPosition;
        }
        return unit.lastPosition.add(new Position((int)((double)frames * unit.unit.getVelocityX()), (int)((double)frames * unit.unit.getVelocityY())));
    }

    private static boolean verifyPosition(Position position) {
        if (!Ecgberht.getGs().getGame().getBWMap().isValidPosition(position)) {
            return false;
        }
        if (Ecgberht.getGs().map.getMap()[position.getY() / 32][position.getX() / 32].equals("0")) {
            return false;
        }
        return Ecgberht.getGs().getGame().getBWMap().isWalkable(position.toWalkPosition());
    }

    public static Position kiteAwayAlt(Position unitPos, Position fleePos) {
        Position delta = fleePos.subtract(unitPos);
        double angleToTarget = Math.atan2(delta.getY(), delta.getX());
        Position bestPosition = null;
        boolean shouldBreak = false;
        for (int i = 0; i <= 3 && !shouldBreak; ++i) {
            int sign = -1;
            while (i == 0 ? sign == -1 : sign <= 1) {
                double a = angleToTarget + (double)(i * sign) * Math.PI / 6.0;
                Position position = new Position(unitPos.getX() - (int)Math.round(64.0 * Math.cos(a)), unitPos.getY() - (int)Math.round(64.0 * Math.sin(a)));
                if (UtilMicro.verifyPosition(position) && UtilMicro.verifyPosition(position.add(new Position(-16, -16))) && UtilMicro.verifyPosition(position.add(new Position(16, -16))) && UtilMicro.verifyPosition(position.add(new Position(16, 16))) && UtilMicro.verifyPosition(position.add(new Position(-16, 16)))) {
                    bestPosition = position;
                    shouldBreak = true;
                }
                sign += 2;
            }
        }
        if (bestPosition != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(bestPosition)) {
            return bestPosition;
        }
        return null;
    }
}

