/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Util;

import bwem.Area;
import bwem.Base;
import bwem.ChokePoint;
import ecgberht.BaseManager;
import ecgberht.ConfigManager;
import ecgberht.Ecgberht;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.DamageType;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitSizeType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.Factory;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.MachineShop;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.MissileTurret;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PhotonCannon;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.ResourceDepot;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.SporeColony;
import org.openbw.bwapi4j.unit.SunkenColony;
import org.openbw.bwapi4j.unit.TrainingFacility;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Vulture;

public class Util {
    private static double areaOfTriangle(Position p1, Position p2, Position pos) {
        double side1 = Math.sqrt(Math.pow(Math.abs(p1.getY() - p2.getY()), 2.0) + Math.pow(Math.abs(p1.getX() - p2.getX()), 2.0));
        double side2 = Math.sqrt(Math.pow(Math.abs(p1.getY() - pos.getY()), 2.0) + Math.pow(Math.abs(p1.getX() - pos.getX()), 2.0));
        double side3 = Math.sqrt(Math.pow(Math.abs(p2.getY() - pos.getY()), 2.0) + Math.pow(Math.abs(p2.getX() - pos.getX()), 2.0));
        double semi_perimeter = (side1 + side2 + side3) / 2.0;
        return Math.sqrt(semi_perimeter * (semi_perimeter - side1) * (semi_perimeter - side2) * (semi_perimeter - side3));
    }

    private static double areaOfRect(Position p1, Position p2, Position p3) {
        double side1 = Math.sqrt(Math.pow(Math.abs(p1.getY() - p2.getY()), 2.0) + Math.pow(Math.abs(p1.getX() - p2.getX()), 2.0));
        double side2 = Math.sqrt(Math.pow(Math.abs(p2.getY() - p3.getY()), 2.0) + Math.pow(Math.abs(p2.getX() - p3.getX()), 2.0));
        return side1 * side2;
    }

    private static boolean check(Position p1, Position p2, Position p3, Position p4, Position pos) {
        double triangle1Area = Util.areaOfTriangle(p1, p2, pos);
        double triangle2Area = Util.areaOfTriangle(p2, p3, pos);
        double triangle3Area = Util.areaOfTriangle(p3, p4, pos);
        double triangle4Area = Util.areaOfTriangle(p4, p1, pos);
        double rectArea = Util.areaOfRect(p1, p2, p3);
        double triangleAreaSum = triangle1Area + triangle2Area + triangle3Area + triangle4Area;
        if (triangleAreaSum % Math.pow(10.0, 14.0) >= 0.999999999999999) {
            triangleAreaSum = Math.ceil(triangleAreaSum);
        }
        return Double.compare(triangleAreaSum, rectArea) == 0;
    }

    public static List<Unit> getUnitsInRectangle(Position topLeft, Position bottomRight) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (!Ecgberht.getGs().getGame().getBWMap().isVisible(topLeft.toTilePosition()) || !Ecgberht.getGs().getGame().getBWMap().isVisible(bottomRight.toTilePosition())) {
            return units;
        }
        for (Unit unit : Ecgberht.getGs().bw.getAllUnits()) {
            Position p3;
            if (!unit.exists() || !unit.isVisible()) continue;
            Position pos = unit.getPosition();
            Position p2 = new Position(bottomRight.getX(), topLeft.getY());
            if (!Util.check(topLeft, p2, p3 = new Position(topLeft.getX(), bottomRight.getY()), bottomRight, pos)) continue;
            units.add(unit);
        }
        return units;
    }

    public static List<Unit> getUnitsOnTile(TilePosition tile) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (!Ecgberht.getGs().getGame().getBWMap().isVisible(tile)) {
            return units;
        }
        for (Unit unit : Ecgberht.getGs().bw.getAllUnits()) {
            if (!unit.exists() || !unit.getTilePosition().equals(tile)) continue;
            units.add(unit);
        }
        return units;
    }

    public static int countUnitTypeSelf(UnitType type) {
        int count = 0;
        for (Unit unit : Ecgberht.getGs().bw.getUnits(Ecgberht.getGs().getPlayer())) {
            if (!unit.exists() || !type.isBuilding() && type != UnitType.Terran_Science_Vessel && !((PlayerUnit)unit).isCompleted()) continue;
            if (type == UnitType.Terran_Siege_Tank_Tank_Mode && unit instanceof SiegeTank) {
                ++count;
                continue;
            }
            if (unit.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public static Position sumPosition(Position ... positions) {
        Position sum = new Position(0, 0);
        for (Position p : positions) {
            sum = new Position(sum.getX() + p.getX(), sum.getY() + p.getY());
        }
        return sum;
    }

    public static TilePosition sumTilePosition(TilePosition ... tilepositions) {
        TilePosition sum = new TilePosition(0, 0);
        for (TilePosition p : tilepositions) {
            sum = new TilePosition(sum.getX() + p.getX(), sum.getY() + p.getY());
        }
        return sum;
    }

    public static MutablePair<Double, Double> sumPosition(List<MutablePair<Double, Double>> vectors) {
        MutablePair<Double, Double> sum = new MutablePair<Double, Double>(0.0, 0.0);
        for (MutablePair<Double, Double> p : vectors) {
            MutablePair<Double, Double> mutablePair = sum;
            Double.valueOf((Double)mutablePair.first + (Double)p.first);
            mutablePair.first = mutablePair.first;
            mutablePair = sum;
            Double.valueOf((Double)mutablePair.second + (Double)p.second);
            mutablePair.second = mutablePair.second;
        }
        return sum;
    }

    public static boolean isEnemy(Player player) {
        if (player == null) {
            return true;
        }
        if (!Ecgberht.getGs().players.containsKey(player)) {
            return true;
        }
        return Ecgberht.getGs().players.get(player) == -1;
    }

    public static ChokePoint getClosestChokepoint(Position pos) {
        ChokePoint closestChoke = null;
        double dist = Double.MAX_VALUE;
        for (ChokePoint choke : Ecgberht.getGs().bwem.getMap().getChokePoints()) {
            double cDist = Util.broodWarDistance(pos, choke.getCenter().toPosition());
            if (closestChoke != null && !(cDist < dist)) continue;
            closestChoke = choke;
            dist = cDist;
        }
        return closestChoke;
    }

    public static ChokePoint getGroundDistanceClosestChoke(Position pos) {
        ChokePoint closestChoke = null;
        double dist = Double.MAX_VALUE;
        for (ChokePoint choke : Ecgberht.getGs().bwem.getMap().getChokePoints()) {
            double cDist = Util.getGroundDistance(pos, choke.getCenter().toPosition());
            if (cDist == 0.0 || closestChoke != null && !(cDist < dist)) continue;
            closestChoke = choke;
            dist = cDist;
        }
        return closestChoke;
    }

    public static Base getClosestBaseLocation(Position pos) {
        Base closestBase = null;
        double dist = Double.MAX_VALUE;
        for (Base base : Ecgberht.getGs().bwem.getMap().getBases()) {
            double cDist = Util.broodWarDistance(pos, base.getLocation().toPosition());
            if (closestBase != null && !(cDist < dist)) continue;
            closestBase = base;
            dist = cDist;
        }
        return closestBase;
    }

    public static Base getGroundDistanceClosestBase(Position pos) {
        Base closestBase = null;
        double dist = Double.MAX_VALUE;
        for (Base base : Ecgberht.getGs().bwem.getMap().getBases()) {
            double cDist = Util.getGroundDistance(pos, base.getLocation().toPosition());
            if (cDist == 0.0 || closestBase != null && !(cDist < dist)) continue;
            closestBase = base;
            dist = cDist;
        }
        return closestBase;
    }

    public static WeaponType getWeapon(UnitInfo attacker, UnitInfo target) {
        UnitType attackerType = attacker.unitType;
        UnitType targetType = target.unitType;
        if (attackerType == UnitType.Terran_Bunker) {
            return Util.getWeapon(UnitType.Terran_Marine, targetType);
        }
        if (attackerType == UnitType.Protoss_Carrier) {
            return Util.getWeapon(UnitType.Protoss_Interceptor, targetType);
        }
        if (attackerType == UnitType.Protoss_Reaver) {
            return Util.getWeapon(UnitType.Protoss_Scarab, targetType);
        }
        return target.flying ? attackerType.airWeapon() : attackerType.groundWeapon();
    }

    private static WeaponType getWeapon(UnitType attacker, UnitType target) {
        if (attacker == UnitType.Terran_Bunker) {
            return Util.getWeapon(UnitType.Terran_Marine, target);
        }
        if (attacker == UnitType.Protoss_Carrier) {
            return Util.getWeapon(UnitType.Protoss_Interceptor, target);
        }
        if (attacker == UnitType.Protoss_Reaver) {
            return Util.getWeapon(UnitType.Protoss_Scarab, target);
        }
        return target.isFlyer() ? attacker.airWeapon() : attacker.groundWeapon();
    }

    public static WeaponType getWeapon(UnitType attacker) {
        if (attacker == UnitType.Terran_Bunker) {
            return UnitType.Terran_Marine.groundWeapon();
        }
        if (attacker == UnitType.Protoss_Carrier) {
            return UnitType.Protoss_Interceptor.airWeapon();
        }
        if (attacker == UnitType.Protoss_Reaver) {
            return UnitType.Protoss_Scarab.groundWeapon();
        }
        return attacker.groundWeapon() != WeaponType.None ? attacker.groundWeapon() : attacker.airWeapon();
    }

    public static boolean canAttack(UnitInfo attacker, UnitInfo target) {
        if (attacker.unit.isLockedDown() || !(attacker.unit instanceof Attacker)) {
            return false;
        }
        WeaponType weapon = Util.getWeapon(attacker, target);
        return weapon != null;
    }

    public static String raceToString(Race race) {
        switch (race) {
            case Zerg: {
                return "Zerg";
            }
            case Terran: {
                return "Terran";
            }
            case Protoss: {
                return "Protoss";
            }
            case Random: {
                return "Random";
            }
            case Unknown: {
                return "Random";
            }
        }
        return "Unknown";
    }

    public static void sendText(String text) {
        if (!ConfigManager.getConfig().ecgConfig.humanMode) {
            Util.getIH().sendText(text);
        }
    }

    public static int getGroundDistance(Position start, Position end) {
        try {
            return Ecgberht.getGs().bwem.getMap().getPathLength(start, end);
        }
        catch (Exception e) {
            return start != null && end != null ? start.getDistance(end) : Integer.MAX_VALUE;
        }
    }

    public static boolean isConnected(TilePosition start, TilePosition end) {
        return !Ecgberht.getGs().bwem.getMap().getPath(start.toPosition(), end.toPosition()).isEmpty();
    }

    public static double broodWarDistance(Position a, Position b) {
        return Util.broodWarDistance(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static double broodWarDistance(int x00, int y00, int x01, int y01) {
        double D;
        double dy;
        double dx = Math.abs(x00 - x01);
        double d = Math.min(dx, dy = (double)Math.abs(y00 - y01));
        if (d < (D = Math.max(dx, dy)) / 4.0) {
            return D;
        }
        return D - D / 16.0 + d * 3.0 / 8.0 - D / 64.0 + d * 3.0 / 256.0;
    }

    public static double broodWarDistance(double[] a, double[] b) {
        double D;
        double dy;
        double dx = Math.abs(a[0] - b[0]);
        double d = Math.min(dx, dy = Math.abs(a[1] - b[1]));
        if (d < (D = Math.max(dx, dy)) / 4.0) {
            return D;
        }
        return D - D / 16.0 + d * 3.0 / 8.0 - D / 64.0 + d * 3.0 / 256.0;
    }

    public static double broodWarDistance(Unit u, double[] b) {
        Position pos = u.getPosition();
        return Util.broodWarDistance(pos.getX(), pos.getY(), (int)b[0], (int)b[1]);
    }

    public static Position chooseAttackPosition(Position p, boolean flying) {
        Position chosen = null;
        double maxScore = 0.0;
        for (UnitInfo b : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
            double influence = Util.getScoreAttackPosition((Building)b.unit);
            int n = flying ? b.lastPosition.getDistance(p) : Util.getGroundDistance(p, b.lastPosition);
            double score = influence / (2.5 * (double)n);
            if (!(score > maxScore)) continue;
            chosen = b.lastPosition;
            maxScore = score;
        }
        if (chosen == null && Ecgberht.getGs().enemyMainBase == null) {
            for (BaseManager.Garrison g : Ecgberht.getGs().baseManager.getScoutingBasesSorted()) {
                if (!flying && g.island) continue;
                return g.tile.toPosition();
            }
        }
        return chosen;
    }

    private static double getScoreAttackPosition(Building unit) {
        if (unit instanceof ResourceDepot) {
            return 8.0;
        }
        if (unit instanceof ResearchingFacility || unit instanceof TrainingFacility) {
            return 4.0;
        }
        if (unit.getType().canAttack() || unit instanceof Bunker) {
            return 6.0;
        }
        return 3.0;
    }

    public static UnitInfo getClosestUnit(UnitInfo unit, Set<UnitInfo> enemies, boolean ignoreAir) {
        UnitInfo chosen = null;
        double minDist = Double.MAX_VALUE;
        for (UnitInfo u : enemies) {
            if (!u.unit.exists() || ignoreAir && u.flying) continue;
            double dist = unit.getDistance(u);
            if (chosen != null && !(dist < minDist)) continue;
            minDist = dist;
            chosen = u;
        }
        return chosen;
    }

    public static MutablePair<Double, Double> cropPosition(MutablePair<Double, Double> unitV) {
        MutablePair<Double, Double> cropped = new MutablePair<Double, Double>((Double)unitV.first, (Double)unitV.second);
        double sizeX = (double)Ecgberht.getGs().getGame().getBWMap().mapWidth() * 32.0;
        double sizeY = (double)Ecgberht.getGs().getGame().getBWMap().mapHeight() * 32.0;
        if ((Double)cropped.first < 0.0) {
            cropped.first = 0.0;
        } else if ((Double)cropped.first >= sizeX) {
            cropped.first = sizeX - 1.0;
        }
        if ((Double)cropped.second < 0.0) {
            cropped.second = 0.0;
        } else if ((Double)cropped.second >= sizeY) {
            cropped.second = sizeY - 1.0;
        }
        return cropped;
    }

    static Position cropPosition(Position pos) {
        MutablePair<Integer, Integer> cropped = new MutablePair<Integer, Integer>(pos.getX(), pos.getY());
        int sizeX = Ecgberht.getGs().getGame().getBWMap().mapWidth() * 32;
        int sizeY = Ecgberht.getGs().getGame().getBWMap().mapHeight() * 32;
        if ((double)((Integer)cropped.first).intValue() < 0.0) {
            cropped.first = 0;
        } else if ((Integer)cropped.first >= sizeX) {
            cropped.first = sizeX - 1;
        }
        if ((double)((Integer)cropped.second).intValue() < 0.0) {
            cropped.second = 0;
        } else if ((Integer)cropped.second >= sizeY) {
            cropped.second = sizeY - 1;
        }
        return new Position((Integer)cropped.first, (Integer)cropped.second);
    }

    public static Position choosePatrolPositionVulture(Vulture myUnit, UnitInfo attackUnit) {
        try {
            Position myUnitPos = myUnit.getPosition();
            Position attackUnitPos = attackUnit.lastPosition;
            MutablePair<Double, Double> AT = new MutablePair<Double, Double>((double)attackUnitPos.getX() - (double)myUnitPos.getX(), (double)attackUnitPos.getY() - (double)myUnitPos.getY());
            MutablePair<Double, Double> patrolDir1 = Util.rotatePosition(AT, 0.6283185307179586);
            MutablePair<Double, Double> patrolDir2 = Util.rotatePosition(AT, -0.6283185307179586);
            MutablePair<Double, Double> accel = new MutablePair<Double, Double>(myUnit.getVelocityX(), myUnit.getVelocityY());
            MutablePair<Double, Double> multi = new MutablePair<Double, Double>((Double)patrolDir1.first * (Double)accel.first, (Double)patrolDir1.second * (Double)accel.second);
            MutablePair<Double, Double> patrolDir = (Double)multi.first >= 0.0 && (Double)multi.second >= 0.0 ? patrolDir1 : patrolDir2;
            patrolDir = Util.normalize(patrolDir);
            Position prePatrol = new Position(((Double)patrolDir.first).intValue(), ((Double)patrolDir.second).intValue()).multiply(new Position(myUnit.getGroundWeaponMaxRange() - 5, myUnit.getGroundWeaponMaxRange() - 5));
            return Util.cropPosition(myUnitPos.add(prePatrol));
        }
        catch (Exception e) {
            System.err.println("choosePatrolPositionVulture Exception");
            e.printStackTrace();
            return null;
        }
    }

    private static MutablePair<Double, Double> normalize(MutablePair<Double, Double> pos) {
        double norm = Math.sqrt((Double)pos.first * (Double)pos.first + (Double)pos.second * (Double)pos.second);
        return new MutablePair<Double, Double>((Double)pos.first / norm, (Double)pos.second / norm);
    }

    public static double getSpeed(UnitInfo unit) {
        if (unit.unitType.isBuilding() && !unit.flying) {
            return 0.0;
        }
        if (unit.burrowed) {
            return 0.0;
        }
        return unit.player.getUnitStatCalculator().topSpeed(unit.unitType);
    }

    private static MutablePair<Double, Double> rotatePosition(MutablePair<Double, Double> pos, double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        return new MutablePair<Double, Double>((Double)pos.first * cosAngle - (Double)pos.second * sinAngle, (Double)pos.first * sinAngle + (Double)pos.second * cosAngle);
    }

    public static boolean isPositionMapEdge(Position pos) {
        return pos.getX() <= 0 || pos.getY() <= 0 || pos.getX() >= Ecgberht.getGs().getGame().getBWMap().mapWidth() * 32 || pos.getY() >= Ecgberht.getGs().getGame().getBWMap().mapHeight() * 32;
    }

    public static Position improveMapEdgePosition(Position unitPos, Position pos) {
        MutablePair<Integer, Integer> improved = new MutablePair<Integer, Integer>(pos.getX(), pos.getY());
        int mapHeight = Ecgberht.getGs().getGame().getBWMap().mapHeight() * 32;
        int mapWidth = Ecgberht.getGs().getGame().getBWMap().mapWidth() * 32;
        if ((Integer)improved.first <= 0 && (Integer)improved.second <= 0) {
            if (Math.random() < 0.5) {
                improved.first = 160;
            } else {
                improved.second = 160;
            }
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        if ((Integer)improved.first >= mapWidth && (Integer)improved.second >= mapWidth) {
            if (Math.random() < 0.5) {
                improved.first = mapWidth - 96;
            } else {
                improved.second = mapHeight - 96;
            }
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        if ((Integer)improved.first <= 0) {
            improved.first = 160;
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        if ((Integer)improved.second <= 0) {
            improved.second = 160;
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        if ((Integer)improved.first >= mapWidth) {
            improved.first = mapWidth - 64;
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        if ((Integer)improved.second >= mapHeight) {
            improved.second = mapHeight - 64;
            return new Position((Integer)improved.first, (Integer)improved.second);
        }
        return null;
    }

    public static boolean shouldIStop(Position pos) {
        for (Base b : Ecgberht.getGs().BLs) {
            if (!Util.getSquareTiles(b.getLocation(), UnitType.Terran_Command_Center).contains(pos.toTilePosition())) continue;
            return false;
        }
        return Ecgberht.getGs().mainChoke != null && Ecgberht.getGs().mainChoke.getCenter().toPosition().getDistance(pos) > 64;
    }

    private static Set<TilePosition> getSquareTiles(TilePosition pos, UnitType type) {
        int ii;
        HashSet<TilePosition> tiles = new HashSet<TilePosition>();
        tiles.add(pos);
        int height = type.tileHeight();
        int width = type.tileHeight();
        for (ii = 1; ii <= height; ++ii) {
            tiles.add(pos.add(new TilePosition(0, ii)));
        }
        for (ii = 1; ii <= width; ++ii) {
            tiles.add(pos.add(new TilePosition(ii, 0)));
        }
        return tiles;
    }

    public static Position getUnitCenterPosition(Position leftTop, UnitType type) {
        Position rightBottom = new Position(leftTop.getX() + type.tileWidth() * 32, leftTop.getY() + type.tileHeight() * 32);
        return new Position((leftTop.getX() + rightBottom.getX()) / 2, (leftTop.getY() + rightBottom.getY()) / 2);
    }

    public static double getChokeWidth(ChokePoint choke) {
        List<WalkPosition> walks = choke.getGeometry();
        return walks.get(0).toPosition().getDistance(walks.get(walks.size() - 1).toPosition());
    }

    public static boolean isStaticDefense(UnitInfo u) {
        return Util.isStaticDefense(u.unitType);
    }

    public static boolean isStaticDefense(UnitType u) {
        return u.isBuilding() && (u.canAttack() || u == UnitType.Terran_Bunker || u == UnitType.Zerg_Creep_Colony);
    }

    public static boolean isGroundStaticDefense(Unit u) {
        return u instanceof Bunker || u instanceof SunkenColony || u instanceof PhotonCannon;
    }

    public static boolean isAirStaticDefense(Unit u) {
        return u instanceof Bunker || u instanceof MissileTurret || u instanceof SporeColony || u instanceof PhotonCannon;
    }

    public static int countBuildingAll(UnitType type) {
        int count = 0;
        for (MutablePair<UnitType, TilePosition> w : Ecgberht.getGs().workerBuild.values()) {
            if (w.first != type) continue;
            ++count;
        }
        return count += Util.countUnitTypeSelf(type);
    }

    public static boolean hasFreePatches(Base base) {
        List minerals = base.getMinerals().stream().map(u -> (MineralPatch)u.getUnit()).collect(Collectors.toList());
        int count = 0;
        for (MineralPatch m : minerals) {
            if (!Ecgberht.getGs().mineralsAssigned.containsKey(m)) continue;
            count += Ecgberht.getGs().mineralsAssigned.get(m).intValue();
        }
        return count < 2 * minerals.size();
    }

    public static int getNumberCCs() {
        return Ecgberht.getGs().CCs.size() + Ecgberht.getGs().islandCCs.size();
    }

    public static boolean checkSiege() {
        boolean machineShop = false;
        if (Ecgberht.getGs().Fs.isEmpty()) {
            return false;
        }
        int mS = (int)Ecgberht.getGs().UBs.stream().filter(u -> u instanceof MachineShop).count();
        if (mS == 0) {
            for (Factory f : Ecgberht.getGs().Fs) {
                if (f.getMachineShop() == null) continue;
                machineShop = true;
                break;
            }
            return !machineShop;
        }
        return mS >= 1;
    }

    public static InteractionHandler getIH() {
        return Ecgberht.getGs().getIH();
    }

    public static UnitInfo getTankTarget(UnitInfo t, Set<UnitInfo> tankTargets) {
        UnitInfo chosenTarget = null;
        int highPriority = 0;
        int closestDist = Integer.MAX_VALUE;
        for (UnitInfo target : tankTargets) {
            if (!target.visible) continue;
            int distance = t.getDistance(target);
            int priority = Util.getRangedAttackPriority(t, target);
            if (Util.isStaticDefense(t)) {
                priority = (int)((double)priority * 1.2);
            }
            if (chosenTarget != null && priority <= highPriority && (priority != highPriority || distance >= closestDist)) continue;
            closestDist = distance;
            highPriority = priority;
            chosenTarget = target;
        }
        return chosenTarget;
    }

    public static UnitInfo getRangedTarget(UnitInfo rangedUnit, Set<UnitInfo> enemies, Position pos) {
        int bestScore = -999999;
        UnitInfo bestTarget = null;
        if (rangedUnit == null || enemies.isEmpty()) {
            return null;
        }
        if (pos == null) {
            return Util.getRangedTarget(rangedUnit, enemies);
        }
        for (UnitInfo enemy : enemies) {
            DamageType damage;
            boolean isThreat;
            boolean canShootBack;
            if (enemy.unit == null || (enemy.unit.isCloaked() || enemy.burrowed) && !enemy.unit.isDetected() || enemy.flying && !(rangedUnit.unit instanceof AirAttacker) || !enemy.flying && !(rangedUnit.unit instanceof GroundAttacker)) continue;
            int priority = Util.getRangedAttackPriority(rangedUnit, enemy);
            int distance = rangedUnit.getDistance(enemy);
            double closerToGoal = rangedUnit.getDistance(pos) - enemy.getDistance(pos);
            if (distance >= 416) continue;
            int score = 160 * priority - distance;
            if (closerToGoal > 0.0) {
                score += 64;
            }
            boolean bl = canShootBack = (isThreat = Util.canAttack(enemy, rangedUnit)) && distance <= 32 + Util.getAttackRange(enemy, rangedUnit);
            if (isThreat) {
                double weaponDist;
                score = canShootBack ? (score += 224) : ((double)distance < (weaponDist = (double)enemy.player.getUnitStatCalculator().weaponMaxRange(Util.getWeapon(enemy, rangedUnit))) ? (score += 192) : (score += 160));
            } else if (enemy.unit instanceof MobileUnit && !((MobileUnit)enemy.unit).isMoving()) {
                score = enemy.unit instanceof SiegeTank && ((SiegeTank)enemy.unit).isSieged() || enemy.currentOrder == Order.Sieging || enemy.currentOrder == Order.Unsieging || enemy.burrowed ? (score += 48) : (score += 24);
            } else if (enemy.unit instanceof MobileUnit && ((MobileUnit)enemy.unit).isBraking()) {
                score += 16;
            } else if (enemy.speed >= rangedUnit.speed) {
                score -= 128;
            }
            if (enemy.unitType.getRace() == Race.Protoss && enemy.shields <= 5) {
                score += 32;
            }
            if (enemy.health < enemy.unitType.maxHitPoints()) {
                score += 24;
            }
            if ((damage = Util.getWeapon(rangedUnit, enemy).damageType()) == DamageType.Explosive) {
                if (enemy.unitType.size() == UnitSizeType.Large) {
                    score += 32;
                }
            } else if (damage == DamageType.Concussive) {
                if (enemy.unitType.size() == UnitSizeType.Small) {
                    score += 32;
                } else if (enemy.unitType.size() == UnitSizeType.Large) {
                    score -= 32;
                }
            }
            if (score <= bestScore) continue;
            bestScore = score;
            bestTarget = enemy;
        }
        return bestScore > 0 ? bestTarget : null;
    }

    public static UnitInfo getRangedTarget(UnitInfo rangedUnit, Set<UnitInfo> enemies) {
        int bestScore = -999999;
        UnitInfo bestTarget = null;
        if (rangedUnit == null || enemies.isEmpty()) {
            return null;
        }
        for (UnitInfo enemy : enemies) {
            DamageType damage;
            boolean canShootBack;
            if (enemy.unit == null || (enemy.unit.isCloaked() || enemy.burrowed) && !enemy.unit.isDetected() || enemy.flying && !(rangedUnit.unit instanceof AirAttacker) || !enemy.flying && !(rangedUnit.unit instanceof GroundAttacker)) continue;
            int priority = Util.getRangedAttackPriority(rangedUnit, enemy);
            int distance = rangedUnit.getDistance(enemy);
            if (distance >= 416) continue;
            int score = 160 * priority - distance;
            boolean isThreat = Util.canAttack(enemy, rangedUnit);
            boolean bl = canShootBack = isThreat && distance <= 32 + Util.getAttackRange(enemy, rangedUnit);
            if (isThreat) {
                double weaponDist;
                score = canShootBack ? (score += 224) : ((double)distance < (weaponDist = (double)enemy.player.getUnitStatCalculator().weaponMaxRange(Util.getWeapon(enemy, rangedUnit))) ? (score += 192) : (score += 160));
            } else if (enemy.unit instanceof MobileUnit && !((MobileUnit)enemy.unit).isMoving()) {
                score = enemy.unit instanceof SiegeTank && ((SiegeTank)enemy.unit).isSieged() || enemy.currentOrder == Order.Sieging || enemy.currentOrder == Order.Unsieging || enemy.burrowed ? (score += 48) : (score += 24);
            } else if (enemy.unit instanceof MobileUnit && ((MobileUnit)enemy.unit).isBraking()) {
                score += 16;
            } else if (enemy.speed >= rangedUnit.speed) {
                score -= 128;
            }
            if (enemy.unitType.getRace() == Race.Protoss && enemy.shields <= 5) {
                score += 32;
            }
            if (enemy.health < enemy.unitType.maxHitPoints()) {
                score += 24;
            }
            if ((damage = Util.getWeapon(rangedUnit, enemy).damageType()) == DamageType.Explosive) {
                if (enemy.unitType.size() == UnitSizeType.Large) {
                    score += 32;
                }
            } else if (damage == DamageType.Concussive) {
                if (enemy.unitType.size() == UnitSizeType.Small) {
                    score += 32;
                } else if (enemy.unitType.size() == UnitSizeType.Large) {
                    score -= 32;
                }
            }
            if (score <= bestScore) continue;
            bestScore = score;
            bestTarget = enemy;
        }
        return bestScore > 0 ? bestTarget : null;
    }

    private static int getRangedAttackPriority(UnitInfo rangedUnit, UnitInfo target) {
        UnitType rangedType = rangedUnit.unitType;
        UnitType targetType = target.unitType;
        if (targetType == UnitType.Terran_Ghost && target.currentOrder == Order.NukePaint || target.currentOrder == Order.NukeTrack) {
            return 15;
        }
        if (rangedType.isFlyer() ? targetType == UnitType.Zerg_Scourge : targetType == UnitType.Terran_Vulture_Spider_Mine && !target.burrowed || targetType == UnitType.Zerg_Infested_Terran) {
            return 12;
        }
        if (rangedType == UnitType.Terran_Wraith) {
            if (target.flying) {
                return targetType.isFlyingBuilding() ? 5 : 11;
            }
        } else if (rangedType == UnitType.Terran_Goliath && target.flying) {
            return targetType.isFlyingBuilding() ? 8 : 10;
        }
        if (rangedType.isFlyer() && target.unit instanceof SiegeTank) {
            return 10;
        }
        if (targetType == UnitType.Protoss_High_Templar || targetType == UnitType.Zerg_Defiler) {
            return 12;
        }
        if (targetType == UnitType.Protoss_Reaver || targetType == UnitType.Protoss_Arbiter) {
            return 11;
        }
        if (Util.isStaticDefense(target)) {
            if (Util.canAttack(target, rangedUnit)) {
                if (target.completed) {
                    return 9;
                }
                return 10;
            }
            if (target.completed) {
                return 8;
            }
            return 7;
        }
        if (Util.canAttack(target, rangedUnit) && !targetType.isWorker()) {
            if (rangedUnit.getDistance(target) > 48 + Util.getAttackRange(target, rangedUnit)) {
                return 8;
            }
            return 10;
        }
        if (targetType == UnitType.Terran_Dropship || targetType == UnitType.Protoss_Shuttle) {
            return 10;
        }
        if (targetType == UnitType.Terran_Science_Vessel || targetType == UnitType.Zerg_Scourge || targetType == UnitType.Protoss_Observer) {
            return 10;
        }
        if (targetType.isWorker()) {
            if (rangedType == UnitType.Terran_Vulture) {
                return 11;
            }
            if (target.unit instanceof SCV) {
                if (((SCV)target.unit).isRepairing()) {
                    return 11;
                }
                if (((SCV)target.unit).isConstructing()) {
                    if (Ecgberht.getGs().getStrat().proxy) {
                        PlayerUnit build = target.unit.getBuildUnit();
                        if (build instanceof Bunker || build instanceof Factory) {
                            return 15;
                        }
                        return 13;
                    }
                    return 10;
                }
            }
            return 9;
        }
        if (targetType == UnitType.Protoss_Carrier || targetType == UnitType.Terran_Siege_Tank_Tank_Mode || targetType == UnitType.Terran_Siege_Tank_Siege_Mode) {
            return 8;
        }
        if (targetType.isSpellcaster() || targetType.groundWeapon() != WeaponType.None || targetType.airWeapon() != WeaponType.None) {
            return 7;
        }
        if (targetType == UnitType.Protoss_Templar_Archives) {
            return 7;
        }
        if (targetType == UnitType.Zerg_Spawning_Pool) {
            return 7;
        }
        if (targetType.isResourceDepot()) {
            if (Ecgberht.getGs().getStrat().proxy) {
                return 3;
            }
            return 6;
        }
        if (targetType == UnitType.Protoss_Pylon) {
            return 5;
        }
        if (targetType == UnitType.Terran_Factory || targetType == UnitType.Terran_Armory) {
            return 5;
        }
        if (!(!targetType.isBuilding() || target.completed && target.unit.isPowered() || targetType.isResourceDepot() || targetType.groundWeapon() != WeaponType.None || targetType.airWeapon() != WeaponType.None)) {
            return 2;
        }
        if (targetType.gasPrice() > 0) {
            return 4;
        }
        if (targetType.mineralPrice() > 0) {
            return 3;
        }
        return 1;
    }

    public static int getAttackRange(UnitInfo attacker, UnitInfo target) {
        UnitType attackerType = attacker.unitType;
        if (attackerType == UnitType.Protoss_Reaver && !target.flying) {
            return 256;
        }
        if (attackerType == UnitType.Protoss_Carrier) {
            return 256;
        }
        if (attackerType == UnitType.Terran_Bunker) {
            return attacker.player.getUnitStatCalculator().weaponMaxRange(WeaponType.Gauss_Rifle) + 32;
        }
        WeaponType weapon = Util.getWeapon(attacker, target);
        if (weapon == WeaponType.None) {
            return 0;
        }
        return attacker.player.getUnitStatCalculator().weaponMaxRange(weapon);
    }

    public static boolean isInOurBases(UnitInfo u) {
        if (u == null) {
            return false;
        }
        Area uArea = Ecgberht.getGs().bwem.getMap().getArea(u.lastTileposition);
        if (uArea == null) {
            return false;
        }
        if (uArea.equals(Ecgberht.getGs().enemyMainArea) || uArea.equals(Ecgberht.getGs().enemyNaturalArea)) {
            return false;
        }
        for (Base b : Ecgberht.getGs().CCs.keySet()) {
            if (!b.getArea().equals(uArea)) continue;
            return true;
        }
        return uArea.equals(Ecgberht.getGs().naturalArea);
    }

    public static boolean isResearched(TechType tech) {
        return Ecgberht.getGs().getPlayer().hasResearched(tech);
    }

    public static int getDistance(Unit unit, Position target) {
        int yDist;
        if (!unit.exists() || target == null) {
            return Integer.MAX_VALUE;
        }
        int xDist = unit.getLeft() - target.getX();
        if (xDist < 0 && (xDist = target.getX() - (unit.getRight() + 1)) < 0) {
            xDist = 0;
        }
        if ((yDist = unit.getTop() - target.getY()) < 0 && (yDist = target.getY() - (unit.getBottom() + 1)) < 0) {
            yDist = 0;
        }
        return new Position(0, 0).getDistance(new Position(xDist, yDist));
    }
}

