/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.Ecgberht;
import ecgberht.UnitInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.Unit;

public class UnitStorage {
    private Map<Unit, UnitInfo> ally = new TreeMap<Unit, UnitInfo>();
    private Map<Unit, UnitInfo> enemy = new TreeMap<Unit, UnitInfo>();

    public Map<Unit, UnitInfo> getAllyUnits() {
        return this.ally;
    }

    public Map<Unit, UnitInfo> getEnemyUnits() {
        return this.enemy;
    }

    void onFrame() {
        Iterator<Map.Entry<Unit, UnitInfo>> allyIT = this.ally.entrySet().iterator();
        while (allyIT.hasNext()) {
            Map.Entry<Unit, UnitInfo> ally = allyIT.next();
            if (!ally.getKey().exists() || ally.getValue().unit == null || !ally.getValue().unit.exists()) {
                allyIT.remove();
                continue;
            }
            ally.getValue().update();
        }
        Iterator<Map.Entry<Unit, UnitInfo>> enemyIT = this.enemy.entrySet().iterator();
        while (enemyIT.hasNext()) {
            Map.Entry<Unit, UnitInfo> enemy = enemyIT.next();
            if (!enemy.getKey().exists() && Ecgberht.getGs().getGame().getBWMap().isVisible(enemy.getValue().lastTileposition) || enemy.getKey().exists() && enemy.getValue().unitType != UnitType.None && !(enemy.getKey() instanceof SiegeTank) && enemy.getKey().getType() != enemy.getValue().unitType) {
                enemyIT.remove();
                continue;
            }
            enemy.getValue().update();
        }
        this.updateAttackers();
    }

    void onUnitCreate(Unit unit) {
        if (!unit.getType().isBuilding()) {
            return;
        }
        UnitInfo u = new UnitInfo((PlayerUnit)unit);
        this.ally.put(unit, u);
    }

    void onUnitComplete(Unit unit) {
        if (this.ally.containsKey(unit)) {
            return;
        }
        UnitInfo u = new UnitInfo((PlayerUnit)unit);
        this.ally.put(unit, u);
    }

    void onUnitShow(Unit unit) {
        UnitInfo stored = this.enemy.get(unit);
        if (stored != null && stored.unitType != unit.getType()) {
            this.enemy.remove(unit);
        }
        UnitInfo u = new UnitInfo((PlayerUnit)unit);
        this.enemy.put(unit, u);
    }

    void onUnitMorph(Unit unit) {
        UnitInfo stored = this.enemy.get(unit);
        if (stored != null && !(unit instanceof SiegeTank) && stored.unitType != unit.getType()) {
            this.enemy.remove(unit);
        }
        UnitInfo u = new UnitInfo((PlayerUnit)unit);
        this.enemy.put(unit, u);
    }

    void onUnitDestroy(Unit unit) {
        if (unit instanceof PlayerUnit) {
            Player p = ((PlayerUnit)unit).getPlayer();
            if (p.equals(Ecgberht.getGs().self)) {
                this.ally.remove(unit);
            } else {
                this.enemy.remove(unit);
            }
        }
    }

    private void updateAttackers() {
        for (UnitInfo u : this.enemy.values()) {
            UnitInfo ally;
            if (u.target == null || !u.target.exists() || (ally = this.ally.get(u.target)) == null) continue;
            ally.attackers.add(u);
        }
    }
}

