/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.Ecgberht;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.Burrowable;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.SpellCaster;
import org.openbw.bwapi4j.unit.Unit;

public class UnitInfo
implements Comparable<UnitInfo> {
    private static final int PROTOSSSHIELDREGEN = 7;
    private static final int ZERGREGEN = 4;
    public double groundRange = 0.0;
    public double airRange = 0.0;
    public double speed = 0.0;
    public int lastAttackFrame = 0;
    public int lastVisibleFrame = 0;
    public int shields = 0;
    public int health = 0;
    public double percentHealth = 0.0;
    public double percentShield = 0.0;
    public int energy = 0;
    public Set<UnitInfo> attackers = new TreeSet<UnitInfo>();
    public boolean burrowed = false;
    public boolean flying = false;
    public boolean visible = false;
    public boolean completed = false;
    public Player player = null;
    public PlayerUnit unit;
    public UnitType unitType = UnitType.None;
    public Position position = null;
    public TilePosition tileposition = null;
    public WalkPosition walkposition = null;
    public Position lastPosition = null;
    public TilePosition lastTileposition = null;
    public WalkPosition lastWalkposition = null;
    public Unit target = null;
    public Order currentOrder;

    public UnitInfo(PlayerUnit u) {
        this.unit = u;
        this.lastPosition = this.position = u.getPosition();
        this.lastTileposition = this.tileposition = u.getTilePosition();
        this.unitType = u.getType();
    }

    private int expectedHealth() {
        if (this.unitType.getRace() == Race.Zerg && this.unitType.regeneratesHP()) {
            return Math.min(((Ecgberht.getGs().frameCount - this.lastVisibleFrame) * 4 >> 8) + this.health, this.unitType.maxHitPoints());
        }
        return this.health;
    }

    private int expectedShields() {
        if (this.unitType.getRace() == Race.Protoss) {
            return Math.min(((Ecgberht.getGs().frameCount - this.lastVisibleFrame) * 7 >> 8) + this.shields, this.unitType.maxShields());
        }
        return this.shields;
    }

    void update() {
        this.player = this.unit.getPlayer();
        this.unitType = this.unit.getType();
        this.visible = this.unit.isVisible();
        this.position = this.visible ? this.unit.getPosition() : this.position;
        this.currentOrder = this.unit.getOrder();
        this.completed = !this.completed && this.visible ? this.unit.isCompleted() : this.completed;
        this.tileposition = this.visible ? this.unit.getTilePosition() : this.tileposition;
        this.walkposition = !this.unitType.isBuilding() ? new Position(this.unit.getLeft(), this.unit.getTop()).toWalkPosition() : this.tileposition.toWalkPosition();
        if (this.visible) {
            this.lastPosition = this.position;
            this.lastTileposition = this.tileposition;
            this.lastWalkposition = this.walkposition;
        }
        this.lastVisibleFrame = this.visible ? Ecgberht.getGs().frameCount : this.lastVisibleFrame;
        int n = this.lastAttackFrame = this.unit.isStartingAttack() ? Ecgberht.getGs().frameCount : this.lastVisibleFrame;
        if (this.unit instanceof GroundAttacker) {
            this.groundRange = this.player.getUnitStatCalculator().weaponMaxRange(this.unitType.groundWeapon());
        }
        if (this.unit instanceof AirAttacker) {
            this.airRange = this.player.getUnitStatCalculator().weaponMaxRange(this.unitType.airWeapon());
        }
        if (this.unit instanceof Bunker) {
            this.airRange = 160.0;
            this.groundRange = 160.0;
        }
        this.health = this.visible ? this.unit.getHitPoints() : this.expectedHealth();
        int n2 = this.shields = this.visible ? this.unit.getShields() : this.expectedShields();
        if (this.unit instanceof SpellCaster) {
            this.energy = ((SpellCaster)this.unit).getEnergy();
        }
        this.percentHealth = this.unitType.maxHitPoints() > 0 ? (double)this.health / (double)this.unitType.maxHitPoints() : 1.0;
        double d = this.percentShield = this.unitType.maxShields() > 0 ? (double)this.shields / (double)this.unitType.maxShields() : 1.0;
        if (this.unit instanceof Burrowable && this.visible) {
            this.burrowed = ((Burrowable)this.unit).isBurrowed();
        }
        if (this.visible) {
            this.flying = this.unit.isFlying();
        }
        this.speed = Util.getSpeed(this);
        this.target = this.unit instanceof Attacker ? ((Attacker)this.unit).getTargetUnit() : this.unit.getOrderTarget();
        this.attackers.clear();
    }

    public int getDistance(Position pos) {
        if (this.visible) {
            return Util.getDistance(this.unit, pos);
        }
        return this.lastPosition.getDistance(pos);
    }

    public int getDistance(Unit u) {
        if (this.visible) {
            return this.unit.getDistance(u);
        }
        return this.lastPosition.getDistance(u.getPosition());
    }

    public int getDistance(UnitInfo target) {
        if (this.visible) {
            return target.visible ? this.unit.getDistance(target.unit) : this.getDistance(target.lastPosition);
        }
        return target.visible ? target.getDistance(this.lastPosition) : target.lastPosition.getDistance(this.lastPosition);
    }

    public double getPredictedDistance(UnitInfo target) {
        Position nextPosition = UtilMicro.predictUnitPosition(target, 1);
        if (nextPosition == null) {
            return this.getDistance(target);
        }
        return this.getDistance(nextPosition);
    }

    public double getPredictedDistance(UnitInfo target, int frames) {
        Position nextPosition = UtilMicro.predictUnitPosition(target, frames);
        if (nextPosition == null) {
            return this.getDistance(target);
        }
        return this.getDistance(nextPosition);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnitInfo)) {
            return false;
        }
        UnitInfo ui2 = (UnitInfo)o;
        return this.unit.equals(ui2.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit);
    }

    @Override
    public int compareTo(UnitInfo o) {
        return this.unit.getId() - o.unit.getId();
    }
}

