/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Overlord;
import org.openbw.bwapi4j.unit.Pylon;
import org.openbw.bwapi4j.unit.ResourceDepot;
import org.openbw.bwapi4j.unit.SupplyDepot;
import org.openbw.bwapi4j.unit.Unit;

public class SupplyMan {
    private int supplyUsed = 8;
    private int supplyTotal = 18;

    SupplyMan(Race race) {
        if (race == Race.Terran) {
            this.supplyTotal = 20;
        }
    }

    public int getSupplyLeft() {
        return this.supplyTotal - this.supplyUsed;
    }

    public int getSupplyUsed() {
        return this.supplyUsed;
    }

    int getSupplyTotal() {
        return this.supplyTotal;
    }

    void onCreate(Unit unit) {
        if (unit instanceof Building) {
            return;
        }
        UnitType type = unit.getType();
        if (type.supplyRequired() > 0) {
            this.supplyUsed += type.supplyRequired();
        }
    }

    void onComplete(Unit unit) {
        UnitType type;
        if ((unit instanceof SupplyDepot || unit instanceof Pylon || unit instanceof Overlord || unit instanceof ResourceDepot) && (type = unit.getType()).supplyProvided() > 0) {
            this.supplyTotal += type.supplyProvided();
        }
    }

    void onDestroy(Unit unit) {
        UnitType type = unit.getType();
        if (unit instanceof SupplyDepot || unit instanceof Pylon || unit instanceof Overlord || unit instanceof ResourceDepot) {
            if (type.supplyProvided() > 0) {
                this.supplyTotal -= type.supplyProvided();
            }
            return;
        }
        if (type.supplyRequired() > 0) {
            this.supplyUsed -= type.supplyRequired();
        }
    }
}

