/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.Clustering.Cluster;
import ecgberht.Ecgberht;
import ecgberht.Simulation.SimInfo;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.Marine;

public class SquadManager {
    public Map<Integer, Squad> squads = new TreeMap<Integer, Squad>();

    public void createSquads(List<Cluster> friendly) {
        this.squads.clear();
        int counter = 0;
        for (Cluster c : friendly) {
            Squad s = new Squad(counter, new Position((int)c.modeX, (int)c.modeY), Ecgberht.getGs().sim.getSimulation(c));
            this.squads.put(counter, s);
            ++counter;
        }
    }

    void updateSquadOrderAndMicro() {
        this.squads.values().stream().filter(u -> !u.members.isEmpty()).forEach(Squad::updateSquad);
        this.squads.values().stream().filter(u -> !u.members.isEmpty()).forEach(Squad::runSquad);
    }

    void updateBunkers() {
        for (Map.Entry<Bunker, Set<UnitInfo>> bunker : Ecgberht.getGs().DBs.entrySet()) {
            SimInfo bunkerSim = Ecgberht.getGs().sim.getSimulation(Ecgberht.getGs().unitStorage.getAllyUnits().get(bunker.getKey()), SimInfo.SimType.MIX);
            if (!bunkerSim.enemies.isEmpty()) {
                if (bunker.getValue().size() >= 4) continue;
                Marine closest = null;
                double bestDist = Double.MAX_VALUE;
                for (UnitInfo u : bunkerSim.allies) {
                    double dist;
                    if (!(u.unit instanceof Marine) || !((dist = (double)u.getDistance(bunker.getKey())) < bestDist)) continue;
                    closest = (Marine)u.unit;
                    bestDist = dist;
                }
                if (closest == null) continue;
                UnitInfo closestUI = Ecgberht.getGs().unitStorage.getAllyUnits().get(closest);
                bunker.getValue().add(closestUI);
                bunkerSim.allies.remove(closestUI);
                closest.rightClick(bunker.getKey(), false);
                continue;
            }
            bunker.getKey().unloadAll();
            bunkerSim.allies.addAll((Collection<UnitInfo>)bunker.getValue());
            bunker.getValue().clear();
        }
    }
}

