/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.Ecgberht;
import ecgberht.IntelligenceAgency;
import ecgberht.Simulation.SimInfo;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.AirAttacker;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Firebat;
import org.openbw.bwapi4j.unit.Goliath;
import org.openbw.bwapi4j.unit.GroundAttacker;
import org.openbw.bwapi4j.unit.Marine;
import org.openbw.bwapi4j.unit.Medic;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.SpellCaster;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Vulture;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Wraith;

public class Squad
implements Comparable<Squad> {
    private static boolean stimResearched;
    public Position attack;
    public Set<UnitInfo> members = new TreeSet<UnitInfo>();
    public Status status;
    private Position center;
    private Integer id;
    private SimInfo squadSim;
    private boolean medicOnly = false;
    boolean lose;

    Squad(int id, Position center, SimInfo squadSim) {
        Position closestCC;
        this.id = id;
        this.lose = squadSim.lose;
        this.squadSim = squadSim;
        for (UnitInfo m : squadSim.allies) {
            if (!this.isArmyUnit(m.unit) || Ecgberht.getGs().agents.containsKey(m.unit)) continue;
            this.members.add(m);
        }
        Status status = this.status = Ecgberht.getGs().defense ? Status.DEFENSE : Status.IDLE;
        this.attack = Ecgberht.getGs().defendPosition != null ? Ecgberht.getGs().defendPosition : (!Ecgberht.getGs().DBs.isEmpty() ? Ecgberht.getGs().DBs.keySet().iterator().next().getPosition() : ((closestCC = Ecgberht.getGs().getNearestCC(center, false)) != null ? closestCC : center));
        this.center = center;
    }

    private boolean isArmyUnit(Unit u) {
        if (!u.exists()) {
            return false;
        }
        if (u instanceof Building) {
            return false;
        }
        if (u instanceof SCV && (Ecgberht.getGs().getStrat().name.equals("ProxyBBS") || Ecgberht.getGs().getStrat().name.equals("ProxyEightRax"))) {
            return true;
        }
        if (u instanceof MobileUnit && ((MobileUnit)u).getTransport() != null) {
            return false;
        }
        return u instanceof Marine || u instanceof Medic || u instanceof SiegeTank || u instanceof Firebat || u instanceof Vulture || u instanceof Wraith || u instanceof Goliath;
    }

    public Position getSquadCenter() {
        return this.center;
    }

    public void giveAttackOrder(Position pos) {
        if (!pos.equals(this.attack)) {
            this.attack = pos;
        }
    }

    int getSquadMembersCount() {
        int count = 0;
        for (UnitInfo u : this.members) {
            ++count;
            if (!(u.unit instanceof Goliath) && !(u.unit instanceof SiegeTank) && !(u.unit instanceof Vulture) && !(u.unit instanceof Wraith)) continue;
            ++count;
        }
        return count;
    }

    private void setSquadStatus() {
        this.medicOnly = this.members.stream().noneMatch(u -> u.unitType != UnitType.Terran_Medic);
        if (this.status == Status.DEFENSE) {
            return;
        }
        if (this.status != Status.IDLE && (this.squadSim.lose || this.medicOnly)) {
            this.status = Status.REGROUP;
        } else if (this.status == Status.ATTACK && this.squadSim.enemies.isEmpty()) {
            this.status = Status.ADVANCE;
        } else if (!(this.status != Status.IDLE || this.squadSim.enemies.isEmpty() || IntelligenceAgency.enemyIsRushing() || Ecgberht.getGs().defendPosition != null && Ecgberht.getGs().defendPosition.getDistance(this.center) > 350)) {
            this.status = !this.squadSim.lose ? Status.ATTACK : Status.REGROUP;
        }
    }

    void updateSquad() {
        if (this.members.isEmpty()) {
            return;
        }
        if (!stimResearched && Ecgberht.getGs().getPlayer().hasResearched(TechType.Stim_Packs)) {
            stimResearched = true;
        }
        this.setSquadStatus();
    }

    void runSquad() {
        try {
            TreeSet<Unit> marinesToHeal = new TreeSet<Unit>();
            for (UnitInfo u : this.members) {
                if (u.unit.isLockedDown() || u.unit.isMaelstrommed() || ((MobileUnit)u.unit).isStasised() || ((MobileUnit)u.unit).getTransport() != null) continue;
                if (u.unit instanceof Marine && this.shouldStim(u)) {
                    ((Marine)u.unit).stimPack();
                }
                if (u.unit instanceof Firebat && this.shouldStim(u)) {
                    ((Firebat)u.unit).stimPack();
                }
                if (u.unit instanceof Medic) {
                    this.microMedic((Medic)u.unit, marinesToHeal);
                    continue;
                }
                if (u.unit instanceof SiegeTank) {
                    this.microTank(u);
                    continue;
                }
                if (u.unitType.groundWeapon().maxRange() > 32) {
                    this.microRanged(u);
                    continue;
                }
                this.microMelee(u);
            }
        }
        catch (Exception e) {
            System.err.println("runSquad Error");
            e.printStackTrace();
        }
    }

    private void microRanged(UnitInfo u) {
        switch (this.status) {
            case ATTACK: 
            case DEFENSE: {
                this.executeRangedAttackLogic(u);
                break;
            }
            case IDLE: {
                int range2;
                if (Ecgberht.getGs().getStrat().proxy) {
                    return;
                }
                Position move = null;
                if (Ecgberht.getGs().defendPosition != null) {
                    if (u.currentOrder != Order.Stop) {
                        move = Ecgberht.getGs().defendPosition;
                    }
                } else if (!Ecgberht.getGs().DBs.isEmpty()) {
                    Unit bunker = Ecgberht.getGs().DBs.keySet().iterator().next();
                    if (u.currentOrder != Order.Stop) {
                        move = bunker.getPosition();
                    }
                } else if (!(Ecgberht.getGs().mainChoke == null || Ecgberht.getGs().learningManager.isNaughty() || Ecgberht.getGs().getStrat().name.equals("ProxyBBS") || Ecgberht.getGs().getStrat().name.equals("ProxyEightRax"))) {
                    if (u.currentOrder != Order.Stop) {
                        move = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    }
                } else if (Util.broodWarDistance(u.position, this.center) >= 190.0 && u.currentOrder != Order.Move && Ecgberht.getGs().getGame().getBWMap().isWalkable(this.center.toWalkPosition())) {
                    move = this.center;
                }
                if (move == null) break;
                WeaponType weapon = Util.getWeapon(u.unitType);
                int n = range2 = weapon == WeaponType.None ? UnitType.Terran_Marine.groundWeapon().maxRange() : weapon.maxRange();
                if (u.currentOrder == Order.AttackMove) {
                    Random random = new Random();
                    if (!((double)u.getDistance(move) <= (double)range2 * (double)(random.nextInt(7) + 4) / 10.0) || !Util.shouldIStop(u.position)) break;
                    UtilMicro.stop((MobileUnit)u.unit);
                    return;
                }
                if (u.getDistance(move) <= range2) break;
                UtilMicro.attack((MobileUnit)u.unit, move);
                return;
            }
            case REGROUP: {
                if (((MobileUnit)u.unit).isDefenseMatrixed() || Ecgberht.getGs().sim.farFromFight(u, this.squadSim, false) || this.squadSim.enemies.stream().noneMatch(e -> Util.getWeapon(e, u).maxRange() > 32)) {
                    this.executeRangedAttackLogic(u);
                    return;
                }
                Position pos = Ecgberht.getGs().getNearestCC(u.position, true);
                if (!(Util.broodWarDistance(pos, u.position) >= 400.0)) break;
                UtilMicro.move((MobileUnit)u.unit, pos);
                break;
            }
            case ADVANCE: {
                double dist = Util.broodWarDistance(u.position, this.center);
                if (dist >= 240.0) {
                    UtilMicro.move((MobileUnit)u.unit, this.center);
                    return;
                }
                if (this.attack == null) break;
                UtilMicro.move((MobileUnit)u.unit, this.attack);
            }
        }
    }

    private void microMelee(UnitInfo u) {
        switch (this.status) {
            case ATTACK: 
            case DEFENSE: {
                Position closestCC;
                if (u.unit.isAttackFrame() || u.unit.isStartingAttack()) {
                    return;
                }
                if (this.squadSim.enemies.isEmpty() && this.attack != null) {
                    UtilMicro.attack((MobileUnit)u.unit, this.attack);
                    return;
                }
                if (((MobileUnit)u.unit).isUnderStorm() && (closestCC = Ecgberht.getGs().getNearestCC(u.position, true)) != null) {
                    UtilMicro.move((MobileUnit)u.unit, closestCC);
                    return;
                }
                if (this.attack == null || u.unit.isStartingAttack() || u.unit.isAttacking()) break;
                UnitInfo target = Util.getRangedTarget(u, this.squadSim.enemies, this.attack);
                if (target != null) {
                    UtilMicro.attack(u, target);
                    break;
                }
                if (this.attack == null) break;
                UtilMicro.attack((MobileUnit)u.unit, this.attack);
                break;
            }
            case IDLE: {
                if (Ecgberht.getGs().getStrat().proxy) {
                    return;
                }
                Position move = null;
                if (Ecgberht.getGs().defendPosition != null) {
                    if (u.currentOrder != Order.Stop) {
                        move = Ecgberht.getGs().defendPosition;
                    }
                } else if (!Ecgberht.getGs().DBs.isEmpty()) {
                    Unit bunker = Ecgberht.getGs().DBs.keySet().iterator().next();
                    if (u.currentOrder != Order.Stop) {
                        move = bunker.getPosition();
                    }
                } else if (!(Ecgberht.getGs().mainChoke == null || Ecgberht.getGs().learningManager.isNaughty() || Ecgberht.getGs().getStrat().name.equals("ProxyBBS") || Ecgberht.getGs().getStrat().name.equals("ProxyEightRax"))) {
                    if (u.currentOrder != Order.Stop) {
                        move = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    }
                } else if (Util.broodWarDistance(u.position, this.center) >= 190.0 && u.currentOrder != Order.Move && Ecgberht.getGs().getGame().getBWMap().isWalkable(this.center.toWalkPosition())) {
                    move = this.center;
                }
                if (move == null) break;
                int range2 = UnitType.Terran_Marine.groundWeapon().maxRange();
                if (u.currentOrder == Order.AttackMove || u.currentOrder == Order.Move || u.currentOrder == Order.PlayerGuard) {
                    Random random = new Random();
                    if (!((double)u.getDistance(move) <= (double)range2 * (double)(random.nextInt(7) + 4) / 10.0) || !Util.shouldIStop(u.position)) break;
                    UtilMicro.stop((MobileUnit)u.unit);
                    return;
                }
                if (u.getDistance(move) <= range2) break;
                UtilMicro.attack((MobileUnit)u.unit, move);
                return;
            }
            case REGROUP: {
                if (((MobileUnit)u.unit).isDefenseMatrixed() || Ecgberht.getGs().sim.farFromFight(u, this.squadSim, true)) {
                    return;
                }
                Position pos = Ecgberht.getGs().getNearestCC(u.position, true);
                if (!(Util.broodWarDistance(pos, u.position) >= 400.0)) break;
                UtilMicro.move((MobileUnit)u.unit, pos);
                break;
            }
            case ADVANCE: {
                double dist = Util.broodWarDistance(u.position, this.center);
                if (dist >= 260.0) {
                    UtilMicro.move((MobileUnit)u.unit, this.center);
                    return;
                }
                if (this.attack == null) break;
                UtilMicro.move((MobileUnit)u.unit, this.attack);
            }
        }
    }

    private void microTank(UnitInfo u) {
        SiegeTank st = (SiegeTank)u.unit;
        if (st.isAttackFrame() || st.isStartingAttack() || st.isSieged() && u.currentOrder == Order.Unsieging) {
            return;
        }
        if (!st.isSieged() && u.currentOrder == Order.Sieging) {
            return;
        }
        if (u.currentOrder == Order.Unsieging || u.currentOrder == Order.Sieging) {
            return;
        }
        switch (this.status) {
            case ATTACK: 
            case DEFENSE: {
                UnitInfo target;
                boolean found = false;
                boolean close = false;
                int threats = (int)this.squadSim.enemies.stream().filter(e -> e.unitType.canAttack() || e.unitType.isSpellcaster() || Util.isStaticDefense(e.unitType)).count();
                for (UnitInfo e2 : this.squadSim.enemies) {
                    if (e2.flying || e2.unit instanceof Worker || e2.unit instanceof Medic || e2.unitType.isBuilding() && !Util.isStaticDefense(e2)) continue;
                    int distance = u.getDistance(e2);
                    if (!(found || distance > UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange() - 8 || e2.health + e2.shields < 60 && threats <= 2)) {
                        found = true;
                    }
                    if (!close && distance < UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().minRange()) {
                        close = true;
                    }
                    if (!found || !close) continue;
                    break;
                }
                if (found && !close && !st.isSieged()) {
                    st.siege();
                    return;
                }
                if (this.status == Status.DEFENSE && st.isSieged() && Ecgberht.getGs().defendPosition != null) {
                    double range = u.groundRange - 8.0;
                    if ((double)u.getDistance(Ecgberht.getGs().defendPosition) > range) {
                        st.unsiege();
                    }
                    return;
                }
                Set<UnitInfo> tankTargets = this.squadSim.enemies.stream().filter(e -> !e.flying).collect(Collectors.toSet());
                if (st.isSieged()) {
                    tankTargets.removeIf(e -> u.getDistance((UnitInfo)e) > UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange() - 8 || e.unitType.isBuilding() && !Util.isStaticDefense(e) || !e.unitType.isBuilding() && !e.unitType.canAttack() && !e.unitType.isSpellcaster());
                    if (tankTargets.isEmpty() && Math.random() * 10.0 <= 3.0) {
                        st.unsiege();
                        return;
                    }
                }
                if ((target = Util.getTankTarget(u, tankTargets)) != null) {
                    UtilMicro.attack(u, target);
                    break;
                }
                if (this.attack == null || !(Math.random() * 10.0 <= 2.5)) break;
                if (st.isSieged()) {
                    st.unsiege();
                    break;
                }
                UtilMicro.move(st, this.attack);
                break;
            }
            case IDLE: {
                Position move = null;
                if (Ecgberht.getGs().defendPosition != null) {
                    move = Ecgberht.getGs().defendPosition;
                } else if (!Ecgberht.getGs().DBs.isEmpty()) {
                    Unit bunker = Ecgberht.getGs().DBs.keySet().iterator().next();
                    if (Util.broodWarDistance(bunker.getPosition(), this.center) >= 180.0 && Ecgberht.getGs().getArmySize() < Ecgberht.getGs().getStrat().armyForAttack && !Ecgberht.getGs().getStrat().name.equals("ProxyBBS") && !Ecgberht.getGs().getStrat().name.equals("ProxyEightRax") && u.currentOrder != Order.Move) {
                        move = bunker.getPosition();
                    }
                } else if (!(Ecgberht.getGs().mainChoke == null || Ecgberht.getGs().learningManager.isNaughty() || Ecgberht.getGs().getStrat().name.equals("ProxyBBS") || Ecgberht.getGs().getStrat().name.equals("ProxyEightRax"))) {
                    if (Util.broodWarDistance(Ecgberht.getGs().mainChoke.getCenter().toPosition(), this.center) >= 200.0 && Ecgberht.getGs().getArmySize() < Ecgberht.getGs().getStrat().armyForAttack && u.currentOrder != Order.Move) {
                        move = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    }
                } else if (Util.broodWarDistance(u.position, this.center) >= 180.0 && u.currentOrder != Order.Move && Ecgberht.getGs().getGame().getBWMap().isWalkable(this.center.toWalkPosition())) {
                    move = this.center;
                }
                if (move == null) break;
                WeaponType weapon = Util.getWeapon(u.unitType);
                int range = weapon.maxRange();
                if (u.currentOrder == Order.AttackMove || u.currentOrder == Order.PlayerGuard || u.currentOrder == Order.Move) {
                    Random random = new Random();
                    if (!((double)u.getDistance(move) <= (double)range * (double)(random.nextInt(7) + 4) / 10.0) || !Util.shouldIStop(u.position)) break;
                    if (!st.isSieged() && Ecgberht.getGs().getPlayer().hasResearched(TechType.Tank_Siege_Mode)) {
                        st.siege();
                    } else {
                        UtilMicro.stop(st);
                    }
                    return;
                }
                if (u.getDistance(move) <= range) break;
                if (st.isSieged() && !Ecgberht.getGs().defense) {
                    st.unsiege();
                } else {
                    UtilMicro.attack(st, move);
                }
                return;
            }
            case REGROUP: {
                if (st.isDefenseMatrixed() || Ecgberht.getGs().sim.farFromFight(u, this.squadSim, false)) {
                    return;
                }
                Position pos = Ecgberht.getGs().getNearestCC(u.position, true);
                if (!(Util.broodWarDistance(pos, u.position) >= 400.0)) break;
                UtilMicro.move(st, pos);
                break;
            }
            case ADVANCE: {
                if (st.isSieged() && Math.random() * 10.0 <= 6.0) {
                    st.unsiege();
                    break;
                }
                double dist = Util.broodWarDistance(u.position, this.center);
                if (dist >= 300.0) {
                    UtilMicro.attack(st, this.center);
                    return;
                }
                if (this.attack == null) break;
                UtilMicro.move(st, this.attack);
            }
        }
    }

    private void microMedic(Medic u, Set<Unit> marinesToHeal) {
        PlayerUnit healTarget = this.getHealTarget(u, marinesToHeal);
        if (healTarget != null) {
            UtilMicro.heal(u, healTarget);
            marinesToHeal.add(healTarget);
        } else if (this.status == Status.IDLE) {
            if (Ecgberht.getGs().defendPosition != null) {
                int range = UnitType.Terran_Marine.groundWeapon().maxRange();
                Random random = new Random();
                if ((double)Ecgberht.getGs().defendPosition.getDistance(u.getPosition()) <= (double)range * (double)(random.nextInt(7) + 4) / 10.0 && Util.shouldIStop(u.getPosition())) {
                    UtilMicro.stop(u);
                } else if (u.getDistance(Ecgberht.getGs().defendPosition) > (double)range) {
                    UtilMicro.move(u, Ecgberht.getGs().defendPosition);
                }
            }
        } else if (this.status == Status.REGROUP) {
            if (this.medicOnly) {
                Optional<Squad> closest = Ecgberht.getGs().sqManager.squads.values().stream().filter(s -> !s.medicOnly).min(Comparator.comparingDouble(s -> u.getDistance(s.getSquadCenter())));
                closest.ifPresent(squad -> UtilMicro.move(u, squad.getSquadCenter()));
                return;
            }
            Position pos = Ecgberht.getGs().getNearestCC(u.getPosition(), true);
            if (Util.broodWarDistance(pos, u.getPosition()) >= 400.0) {
                UtilMicro.heal(u, pos);
            }
        } else if (this.status == Status.ADVANCE && this.attack != null) {
            UtilMicro.heal(u, this.attack);
        } else if (this.center.getDistance(u.getPosition()) > 192) {
            UtilMicro.heal(u, this.center);
        }
    }

    private boolean shouldStim(UnitInfo stimmer) {
        if (stimmer.unitType == UnitType.Terran_Marine && ((Marine)stimmer.unit).isStimmed() || stimmer.health <= 25) {
            return false;
        }
        if (stimmer.unitType == UnitType.Terran_Firebat && ((Firebat)stimmer.unit).isStimmed() || stimmer.health <= 25) {
            return false;
        }
        Unit target = stimmer.target;
        if (target == null) {
            return false;
        }
        UnitInfo targetUI = Ecgberht.getGs().unitStorage.getEnemyUnits().get(target);
        double range = stimmer.groundRange;
        double distToTarget = targetUI != null ? (double)stimmer.getDistance(targetUI) : (double)stimmer.getDistance(target);
        return distToTarget > range - 32.0 && (target instanceof Attacker || target instanceof SpellCaster || Util.isStaticDefense(target.getType()));
    }

    private PlayerUnit getHealTarget(Unit u, Set<Unit> marinesToHeal) {
        Set<PlayerUnit> healables = this.getHealable();
        PlayerUnit chosen = null;
        double dist = Double.MAX_VALUE;
        for (PlayerUnit m : healables) {
            if (m.getHitPoints() == m.getType().maxHitPoints() || marinesToHeal.contains(m)) continue;
            double distA = m.getDistance(u);
            if (chosen != null && !(distA < dist)) continue;
            chosen = m;
            dist = distA;
        }
        return chosen;
    }

    private Set<PlayerUnit> getHealable() {
        TreeSet<PlayerUnit> aux = new TreeSet<PlayerUnit>();
        for (UnitInfo u : this.members) {
            if (!(u.unit instanceof Marine) && !(u.unit instanceof Firebat)) continue;
            aux.add(u.unit);
        }
        return aux;
    }

    private void executeRangedAttackLogic(UnitInfo u) {
        boolean moveCloser;
        int framesToFiringRange;
        if (u.unit.isAttackFrame() || u.unit.isStartingAttack()) {
            return;
        }
        UnitInfo target = Util.getRangedTarget(u, this.squadSim.enemies, this.attack);
        if (target == null) {
            if (this.attack != null) {
                UtilMicro.attack((MobileUnit)u.unit, this.attack);
            }
            return;
        }
        double distToTarget = u.getDistance(target);
        Optional<UnitInfo> bunker = this.squadSim.allies.stream().filter(ally -> ally.unitType == UnitType.Terran_Bunker).findFirst();
        if (this.status == Status.DEFENSE && IntelligenceAgency.enemyIsRushing() && bunker.isPresent() && (double)u.getDistance(bunker.get()) > distToTarget) {
            UtilMicro.move((MobileUnit)u.unit, bunker.get().lastPosition);
        }
        double speed = u.speed;
        if (Ecgberht.getGs().frameCount - u.unit.getLastCommandFrame() <= 10) {
            return;
        }
        WeaponType w = Util.getWeapon(u, target);
        double range = u.player.getUnitStatCalculator().weaponMaxRange(w);
        int cooldown = (target.flying ? ((AirAttacker)u.unit).getAirWeaponCooldown() : ((GroundAttacker)u.unit).getGroundWeaponCooldown()) - Ecgberht.getGs().getIH().getRemainingLatencyFrames() - 2;
        if (cooldown <= (framesToFiringRange = (int)Math.ceil(Math.max(0.0, distToTarget - range) / speed))) {
            UtilMicro.attack(u, target);
            return;
        }
        Position predictedPosition = null;
        int targetRange = target.player.getUnitStatCalculator().weaponMaxRange(Util.getWeapon(target, u));
        boolean kite = true;
        boolean enemyTooClose = distToTarget <= 96.0 && targetRange <= 32;
        boolean bl = moveCloser = target.unitType == UnitType.Terran_Siege_Tank_Siege_Mode || target.unit instanceof SCV && ((SCV)target.unit).isRepairing() && target.unit.getOrderTarget() != null && target.unit.getOrderTarget().getType() == UnitType.Terran_Bunker || target.unitType.isBuilding() && !Util.canAttack(target, u);
        if (!moveCloser && (predictedPosition = UtilMicro.predictUnitPosition(target, 2)) != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(predictedPosition)) {
            double distCurrent;
            double distPredicted = u.getDistance(predictedPosition);
            if (distPredicted > (distCurrent = (double)u.getDistance(target))) {
                kite = false;
                if (distToTarget > range - 24.0) {
                    moveCloser = true;
                }
            } else if (distCurrent == distPredicted && range >= (double)(targetRange + 64) && distToTarget > range - 48.0) {
                moveCloser = true;
            }
        }
        if (moveCloser && !enemyTooClose) {
            if (distToTarget > 32.0 && !u.unit.isStartingAttack() && !u.unit.isAttackFrame()) {
                if (predictedPosition != null) {
                    UtilMicro.move((MobileUnit)u.unit, predictedPosition);
                } else {
                    UtilMicro.move((MobileUnit)u.unit, target.lastPosition);
                }
            } else {
                UtilMicro.attack(u, target);
            }
            return;
        }
        if ((kite || enemyTooClose) && target.unitType.topSpeed() > 0.0) {
            Position kitePos = UtilMicro.kiteAwayAlt(u.position, target.lastPosition);
            if (kitePos != null) {
                UtilMicro.move((MobileUnit)u.unit, kitePos);
            } else {
                kitePos = UtilMicro.kiteAway(u.unit, this.squadSim.enemies);
                if (kitePos != null) {
                    UtilMicro.move((MobileUnit)u.unit, kitePos);
                }
            }
        } else {
            UtilMicro.attack(u, target);
        }
    }

    public void giveMoveOrder(Position retreat) {
        int frameCount = Ecgberht.getGs().frameCount;
        for (UnitInfo u : this.members) {
            Position lastTarget;
            PlayerUnit pU = u.unit;
            if (u.unitType == UnitType.Terran_Siege_Tank_Siege_Mode && pU.getOrder() == Order.Unsieging || u.unitType == UnitType.Terran_Siege_Tank_Tank_Mode && pU.getOrder() == Order.Sieging) continue;
            Position position = lastTarget = ((MobileUnit)u.unit).getTargetPosition() == null ? pU.getOrderTargetPosition() : ((MobileUnit)u.unit).getTargetPosition();
            if (lastTarget != null && lastTarget.equals(retreat) || this.attack == null || frameCount == pU.getLastCommandFrame()) continue;
            ((MobileUnit)u.unit).move(retreat);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Squad)) {
            return false;
        }
        Squad s = (Squad)o;
        return this.id.equals(s.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Squad o) {
        return this.id.compareTo(o.id);
    }

    public static enum Status {
        ATTACK,
        IDLE,
        REGROUP,
        ADVANCE,
        DEFENSE;

    }
}

