/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import java.util.Map;
import java.util.TreeMap;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.ScienceVessel;

public class SpellsManager {
    public Map<ScienceVessel, PlayerUnit> irradiatedUnits = new TreeMap<ScienceVessel, PlayerUnit>();
    public Map<ScienceVessel, MobileUnit> defenseMatrixedUnits = new TreeMap<ScienceVessel, MobileUnit>();
    public Map<ScienceVessel, PlayerUnit> EMPedUnits = new TreeMap<ScienceVessel, PlayerUnit>();

    void onFrameSpellManager() {
        try {
            this.updateIrradiated();
            this.updateDefenseMatrixed();
            this.updateEMPed();
        }
        catch (Exception e) {
            System.err.println("onFrameSpellManager Exception");
            e.printStackTrace();
        }
    }

    private void updateIrradiated() {
        this.irradiatedUnits.entrySet().removeIf(u -> ((PlayerUnit)u.getValue()).isIrradiated() || !((PlayerUnit)u.getValue()).exists() || !((ScienceVessel)u.getKey()).exists());
    }

    private void updateDefenseMatrixed() {
        this.defenseMatrixedUnits.entrySet().removeIf(u -> ((MobileUnit)u.getValue()).isDefenseMatrixed() || !((MobileUnit)u.getValue()).exists() || !((ScienceVessel)u.getKey()).exists());
    }

    private void updateEMPed() {
        this.EMPedUnits.entrySet().removeIf(u -> ((PlayerUnit)u.getValue()).getShields() <= 1 || !((PlayerUnit)u.getValue()).exists() || !((ScienceVessel)u.getKey()).exists());
    }

    public boolean isUnitIrradiated(PlayerUnit u) {
        return this.irradiatedUnits.containsValue(u);
    }

    public boolean isDefenseMatrixed(MobileUnit u) {
        return this.defenseMatrixedUnits.containsValue(u);
    }

    public boolean isUnitEMPed(PlayerUnit u) {
        return this.EMPedUnits.containsValue(u);
    }

    public void addIrradiated(ScienceVessel vessel, PlayerUnit unit) {
        this.irradiatedUnits.put(vessel, unit);
    }

    public void addDefenseMatrixed(ScienceVessel vessel, MobileUnit unit) {
        this.defenseMatrixedUnits.put(vessel, unit);
    }

    public void addEMPed(ScienceVessel vessel, PlayerUnit unit) {
        this.EMPedUnits.put(vessel, unit);
    }
}

