/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ecgberht.IntelligenceAgency;
import ecgberht.Util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openbw.bwapi4j.type.Race;

public class LearningManager {
    private EnemyHistory enemyHistory = new EnemyHistory();
    private EnemyInfo enemyInfo;
    private final String dir = "bwapi-data/write/";

    LearningManager(String name, Race race) {
        this.enemyInfo = new EnemyInfo(name, race);
    }

    private void readOpponentHistory(String opponentName) {
        Gson enemyHistoryJSON = new Gson();
        String filename = opponentName + "_" + this.enemyInfo.race + "-History.json";
        String path = "bwapi-data/read/" + filename;
        try {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyHistory = enemyHistoryJSON.fromJson((Reader)new FileReader(path), EnemyHistory.class);
                return;
            }
            path = "bwapi-data/write/" + filename;
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyHistory = enemyHistoryJSON.fromJson((Reader)new FileReader(path), EnemyHistory.class);
                return;
            }
            path = "bwapi-data/AI/" + filename;
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyHistory = enemyHistoryJSON.fromJson((Reader)new FileReader(path), EnemyHistory.class);
            }
        }
        catch (Exception e) {
            System.err.println("readOpponentHistory");
            e.printStackTrace();
        }
    }

    private void writeJSON(Object content, String path) {
        Gson aux = new GsonBuilder().setPrettyPrinting().create();
        File directory = new File("bwapi-data/write/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        try (FileWriter writer = new FileWriter(path);){
            aux.toJson(content, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("writeJSON");
            e.printStackTrace();
        }
    }

    private void writeOpponentInfo(String name, boolean enemyIsRandom) {
        if (enemyIsRandom && this.enemyInfo.naughty) {
            this.enemyInfo.naughty = false;
        }
        String path = "bwapi-data/write/" + name + "_" + this.enemyInfo.race + ".json";
        Util.sendText("Writing result to: " + path);
        this.writeJSON(this.enemyInfo, path);
    }

    private void writeOpponentHistory(String name) {
        String path = "bwapi-data/write/" + name + "_" + this.enemyInfo.race + "-History.json";
        Util.sendText("Writing history to: " + path);
        this.writeJSON(this.enemyHistory, path);
    }

    private void readOpponentInfo(String opponentName) {
        Gson enemyInfoJSON = new Gson();
        String filename = opponentName + "_" + this.enemyInfo.race + ".json";
        String path = "bwapi-data/read/" + filename;
        try {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyInfo = enemyInfoJSON.fromJson((Reader)new FileReader(path), EnemyInfo.class);
                return;
            }
            path = "bwapi-data/write/" + filename;
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyInfo = enemyInfoJSON.fromJson((Reader)new FileReader(path), EnemyInfo.class);
                return;
            }
            path = "bwapi-data/AI/" + filename;
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                this.enemyInfo = enemyInfoJSON.fromJson((Reader)new FileReader(path), EnemyInfo.class);
            }
        }
        catch (Exception e) {
            System.err.println("readOpponentInfo");
            e.printStackTrace();
        }
    }

    EnemyInfo getEnemyInfo() {
        return this.enemyInfo;
    }

    LinkedList<EnemyHistory.EnemyGame> getEnemyHistory() {
        return this.enemyHistory.history;
    }

    public void setRace(String raceToString) {
        if (this.enemyInfo.race == null) {
            this.enemyInfo.race = raceToString;
        }
    }

    public boolean isNaughty() {
        return this.enemyInfo.naughty;
    }

    void onEnd(String stratName, int mapSize, boolean win, String opponentName, Race enemyRace, String mapName, boolean enemyIsRandom, IntelligenceAgency.EnemyStrats enemyStrat) {
        this.enemyInfo.updateStrategyOpponentHistory(stratName, mapSize, win);
        this.enemyHistory.history.add(new EnemyHistory.EnemyGame(opponentName, enemyRace, win, stratName, mapName, enemyStrat));
        if (win) {
            ++this.enemyInfo.wins;
        } else {
            ++this.enemyInfo.losses;
        }
        this.writeOpponentInfo(opponentName, enemyIsRandom);
        this.writeOpponentHistory(opponentName);
    }

    void setNaughty(boolean naughty) {
        this.enemyInfo.naughty = naughty;
    }

    public boolean defendHarass() {
        return this.enemyInfo.defendHarass;
    }

    public void setHarass(boolean harass) {
        this.enemyInfo.defendHarass = harass;
    }

    void onStart(String name, String raceToString) {
        this.setRace(raceToString);
        this.readOpponentInfo(name);
        this.readOpponentHistory(name);
    }

    public static class EnemyInfo {
        public String opponent;
        public String race;
        public int wins = 0;
        public int losses = 0;
        public boolean naughty = false;
        public boolean defendHarass = false;
        public List<StrategyOpponentHistory> history = new ArrayList<StrategyOpponentHistory>();

        EnemyInfo(String opponent, Race race) {
            this.opponent = opponent;
            this.race = Util.raceToString(race);
        }

        void updateStrategyOpponentHistory(String strategyName, int mapSize, boolean win) {
            for (StrategyOpponentHistory data : this.history) {
                if (data.mapSize != mapSize || !data.strategyName.equals(strategyName)) continue;
                if (win) {
                    ++data.wins;
                } else {
                    ++data.losses;
                }
                return;
            }
            StrategyOpponentHistory newData = new StrategyOpponentHistory(strategyName, mapSize, win);
            this.history.add(newData);
        }

        static class StrategyOpponentHistory {
            int losses = 0;
            int mapSize;
            int wins = 0;
            String strategyName;

            StrategyOpponentHistory(String strategyName, int mapSize, boolean win) {
                this.strategyName = strategyName;
                this.mapSize = mapSize;
                if (win) {
                    ++this.wins;
                } else {
                    ++this.losses;
                }
            }
        }
    }

    public static class EnemyHistory {
        public LinkedList<EnemyGame> history = new LinkedList();

        static class EnemyGame {
            private String opponent;
            private String race;
            private String outcome;
            private String strategy;
            private String mapName;
            public String opponentStrategy;

            EnemyGame(String opponent, Race race, boolean outcome, String strategy, String mapName, IntelligenceAgency.EnemyStrats enemyStrat) {
                this.opponent = opponent;
                this.race = Util.raceToString(race);
                this.outcome = outcome ? "Win" : "Lose";
                this.strategy = strategy;
                this.mapName = mapName;
                this.opponentStrategy = enemyStrat.toString();
            }
        }
    }
}

