/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.Base;
import bwem.Mineral;
import ecgberht.Ecgberht;
import ecgberht.Strategies.BioGreedyFE;
import ecgberht.Strategies.BioMechGreedyFE;
import ecgberht.Strategies.FullBio;
import ecgberht.Strategies.FullBioFE;
import ecgberht.Strategies.FullMech;
import ecgberht.Strategies.MechGreedyFE;
import ecgberht.Strategy;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.Bullet;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.ControlTower;
import org.openbw.bwapi4j.unit.Drone;
import org.openbw.bwapi4j.unit.Egg;
import org.openbw.bwapi4j.unit.Marine;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Probe;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.ScienceFacility;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Zealot;
import org.openbw.bwapi4j.unit.Zergling;

public class IntelligenceAgency {
    static Map<Player, TreeSet<UnitInfo>> enemyBases;
    static Map<Player, HashSet<UnitType>> enemyTypes;
    private static Player mainEnemy;
    private static Set<Unit> enemyWorkers;
    private static List<Bullet> enemyBullets;
    private static List<Bullet> allyBullets;
    private static EnemyStrats enemyStrat;
    private static String startStrat;
    private static boolean exploredMinerals;
    private static Map<UnitType, Integer> mainEnemyUnitTypeAmount;
    private static boolean cloakedThreats;

    private static int getNumEnemyWorkers() {
        return enemyWorkers.size();
    }

    static String getStartStrat() {
        return startStrat;
    }

    static void setStartStrat(String strat) {
        startStrat = strat;
    }

    static void onStartIntelligenceAgency(Player enemy) {
        enemyBases = new HashMap<Player, TreeSet<UnitInfo>>();
        enemyTypes = new HashMap<Player, HashSet<UnitType>>();
        mainEnemy = enemy;
        enemyWorkers = new TreeSet<Unit>();
        enemyBullets = new ArrayList<Bullet>();
        allyBullets = new ArrayList<Bullet>();
        enemyStrat = EnemyStrats.Unknown;
        startStrat = null;
        exploredMinerals = false;
        mainEnemyUnitTypeAmount = new HashMap<UnitType, Integer>();
        cloakedThreats = false;
    }

    public static EnemyStrats getEnemyStrat() {
        return enemyStrat;
    }

    public static void setEnemyStrat(EnemyStrats newEnemyStrat) {
        enemyStrat = newEnemyStrat;
    }

    public static int getNumEnemyBases(Player player) {
        if (enemyBases.containsKey(player)) {
            return enemyBases.get(player).size();
        }
        return 0;
    }

    static void updateBullets() {
        enemyBullets.clear();
        allyBullets.clear();
        for (Bullet b : Ecgberht.getGs().getGame().getBullets()) {
            if (!b.isExists()) continue;
            if (b.getPlayer() != null && b.getPlayer().isEnemy()) {
                enemyBullets.add(b);
                continue;
            }
            allyBullets.add(b);
        }
    }

    public static boolean enemyHasType(UnitType type) {
        return enemyTypes.values().stream().anyMatch(list -> list.contains(type));
    }

    public static boolean playerHasType(Player player, UnitType type) {
        Set types = enemyTypes.get(player);
        return types != null && types.contains(type);
    }

    public static boolean enemyHasType(UnitType ... types) {
        return enemyTypes.values().stream().anyMatch(list -> Arrays.stream(types).anyMatch(list::contains));
    }

    public static boolean mainEnemyHasType(UnitType type) {
        return enemyTypes.get(mainEnemy).contains(type);
    }

    public static boolean mainEnemyHasType(UnitType ... types) {
        return Arrays.stream(types).anyMatch(enemyTypes.get(mainEnemy)::contains);
    }

    public static void printEnemyTypes() {
        for (Map.Entry<Player, HashSet<UnitType>> entry : enemyTypes.entrySet()) {
            for (UnitType type : entry.getValue()) {
                System.out.println(entry.getKey() + ": " + type);
            }
        }
    }

    public static int getNumberEnemyType(UnitType type) {
        Integer number = mainEnemyUnitTypeAmount.get(type);
        return number == null ? 0 : number;
    }

    static void onShow(Unit unit, UnitType type) {
        Integer value = mainEnemyUnitTypeAmount.get(type);
        if (value != null) {
            mainEnemyUnitTypeAmount.put(type, value + 1);
        } else {
            mainEnemyUnitTypeAmount.put(type, 0);
        }
        Player player = ((PlayerUnit)unit).getPlayer();
        if (unit instanceof Worker) {
            enemyWorkers.add(unit);
        }
        if (type.isResourceDepot()) {
            if (enemyBases.containsKey(player) && enemyBases.get(player).contains(Ecgberht.getGs().unitStorage.getEnemyUnits().get(unit))) {
                return;
            }
            for (Base b : Ecgberht.getGs().BLs) {
                if (!b.getLocation().equals(unit.getTilePosition())) continue;
                enemyBases.get(player).add(Ecgberht.getGs().unitStorage.getEnemyUnits().get(unit));
                break;
            }
        }
        if (enemyTypes.containsKey(player) && enemyTypes.get(player).contains(type)) {
            return;
        }
        if (!(unit instanceof Egg)) {
            enemyTypes.get(player).add(type);
        }
        if (type == UnitType.Zerg_Lurker_Egg) {
            enemyTypes.get(player).add(UnitType.Zerg_Lurker);
        } else if (type.isBuilding()) {
            if (type == UnitType.Protoss_Arbiter_Tribunal) {
                enemyTypes.get(player).add(UnitType.Protoss_Arbiter);
            } else if (type == UnitType.Protoss_Templar_Archives) {
                enemyTypes.get(player).add(UnitType.Protoss_Dark_Templar);
                enemyTypes.get(player).add(UnitType.Protoss_High_Templar);
            } else if (type == UnitType.Protoss_Fleet_Beacon) {
                enemyTypes.get(player).add(UnitType.Protoss_Carrier);
            } else if (type == UnitType.Protoss_Robotics_Support_Bay) {
                enemyTypes.get(player).add(UnitType.Protoss_Reaver);
            } else if (type == UnitType.Zerg_Spawning_Pool) {
                enemyTypes.get(player).add(UnitType.Zerg_Zergling);
            } else if (type == UnitType.Zerg_Spire) {
                enemyTypes.get(player).add(UnitType.Zerg_Mutalisk);
            } else if (type == UnitType.Zerg_Hydralisk_Den) {
                enemyTypes.get(player).add(UnitType.Zerg_Hydralisk);
            } else if (type == UnitType.Zerg_Queens_Nest) {
                enemyTypes.get(player).add(UnitType.Zerg_Queen);
            } else if (type == UnitType.Zerg_Defiler_Mound) {
                enemyTypes.get(player).add(UnitType.Zerg_Defiler);
            }
        }
    }

    static void onDestroy(Unit unit, UnitType type) {
        Integer value = mainEnemyUnitTypeAmount.get(type);
        if (value != null) {
            mainEnemyUnitTypeAmount.put(type, value - 1);
        } else {
            mainEnemyUnitTypeAmount.put(type, 0);
        }
        Player player = ((PlayerUnit)unit).getPlayer();
        if (type.isResourceDepot() && enemyBases.containsKey(player)) {
            enemyBases.get(player).remove(Ecgberht.getGs().unitStorage.getEnemyUnits().get(unit));
        }
        if (Ecgberht.getGs().enemyRace == Race.Zerg && unit instanceof Drone) {
            enemyWorkers.remove(unit);
        }
    }

    private static boolean detectEarlyPool() {
        if ((double)Ecgberht.getGs().frameCount < 3600.0 && Ecgberht.getGs().enemyStartBase != null && !Ecgberht.getGs().learningManager.isNaughty() && exploredMinerals) {
            int drones = IntelligenceAgency.getNumEnemyWorkers();
            boolean foundPool = IntelligenceAgency.enemyHasType(UnitType.Zerg_Spawning_Pool);
            if (foundPool && drones <= 6) {
                enemyStrat = EnemyStrats.EarlyPool;
                Ecgberht.getGs().learningManager.setNaughty(true);
                Util.sendText("Bad zerg!, bad!");
                Ecgberht.getGs().playSound("rushed.mp3");
                String strat = Ecgberht.getGs().getStrat().name;
                if (strat.contains("GreedyFE") || strat.equals("14CC")) {
                    Ecgberht.getGs().setStrat(new FullBio());
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    Ecgberht.transition();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean detectZealotRush() {
        if ((double)Ecgberht.getGs().frameCount <= 3888.0000000000005 && Ecgberht.getGs().enemyStartBase != null && exploredMinerals) {
            int countGates = (int)Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType == UnitType.Protoss_Gateway).count();
            int probes = IntelligenceAgency.getNumEnemyWorkers();
            boolean foundGas = IntelligenceAgency.enemyHasType(UnitType.Protoss_Assimilator);
            if (countGates >= 2 && probes <= 13 && !foundGas) {
                enemyStrat = EnemyStrats.ZealotRush;
                Util.sendText("Nice gates you got there");
                Ecgberht.getGs().playSound("rushed.mp3");
                String strat = Ecgberht.getGs().getStrat().name;
                if (strat.contains("GreedyFE") || strat.equals("FullMech") || strat.equals("14CC")) {
                    Ecgberht.getGs().setStrat(new FullBio());
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    Ecgberht.transition();
                } else if (Ecgberht.getGs().getStrat().name.equals("BioMech") || Ecgberht.getGs().getStrat().name.equals("BioMechFE")) {
                    Ecgberht.getGs().setStrat(new FullBioFE());
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    Ecgberht.transition();
                }
                Ecgberht.getGs().getStrat().armyForExpand += 13;
                return true;
            }
        }
        return false;
    }

    private static boolean detectMechRush() {
        if (Ecgberht.getGs().frameCount < 5040 && Ecgberht.getGs().enemyStartBase != null && exploredMinerals) {
            int countFactories = 0;
            int countRax = 0;
            boolean foundGas = false;
            for (UnitInfo u2 : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                if (u2.unitType == UnitType.Terran_Factory) {
                    ++countFactories;
                }
                if (u2.unitType == UnitType.Terran_Refinery) {
                    foundGas = true;
                }
                if (u2.unitType != UnitType.Terran_Barracks) continue;
                ++countRax;
            }
            if (countFactories >= 1 && foundGas && countRax == 1) {
                enemyStrat = EnemyStrats.MechRush;
                Util.sendText("Nice Mech getStrat() you got there");
                Ecgberht.getGs().playSound("rushed.mp3");
                if (Ecgberht.getGs().getStrat().name.equals("BioGreedyFE")) {
                    Ecgberht.getGs().setStrat(new MechGreedyFE());
                    Ecgberht.transition();
                } else if (Ecgberht.getGs().getStrat().name.equals("FullBio") || Ecgberht.getGs().getStrat().name.equals("FullBioFE")) {
                    Ecgberht.getGs().setStrat(new FullMech());
                    Ecgberht.transition();
                }
                return true;
            }
        }
        return false;
    }

    private static void detectEnemyStrategy() {
        if (enemyStrat != EnemyStrats.Unknown) {
            return;
        }
        if (!exploredMinerals) {
            exploredMinerals = IntelligenceAgency.checkExploredEnemyMinerals();
        }
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                if (IntelligenceAgency.detectEarlyPool()) {
                    return;
                }
                if (IntelligenceAgency.detectNinePool()) {
                    return;
                }
                if (!IntelligenceAgency.detectFastHatch()) break;
                return;
            }
            case Terran: {
                if (IntelligenceAgency.detectMechRush()) {
                    return;
                }
                if (!IntelligenceAgency.detectBioPush()) break;
                return;
            }
            case Protoss: {
                if (IntelligenceAgency.detectZealotRush()) {
                    return;
                }
                if (IntelligenceAgency.detectProtossFE()) {
                    return;
                }
                if (!IntelligenceAgency.detectCannonRush()) break;
                return;
            }
        }
    }

    private static boolean detectBioPush() {
        if ((double)Ecgberht.getGs().frameCount <= 5040.0 && Ecgberht.getGs().enemyStartBase != null) {
            int countFactories = 0;
            int countRax = 0;
            for (UnitInfo u2 : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                if (u2.unitType == UnitType.Terran_Factory) {
                    ++countFactories;
                }
                if (u2.unitType != UnitType.Terran_Barracks) continue;
                ++countRax;
            }
            if (countFactories < 1 && countRax > 1) {
                enemyStrat = EnemyStrats.BioPush;
                Ecgberht.getGs().getStrat().bunker = true;
                Util.sendText("Nice Bio strat");
                return true;
            }
        }
        return false;
    }

    private static boolean detectFastHatch() {
        if ((double)Ecgberht.getGs().frameCount <= 5040.0 && Ecgberht.getGs().enemyStartBase != null && exploredMinerals) {
            int drones = IntelligenceAgency.getNumEnemyWorkers();
            if (IntelligenceAgency.getNumEnemyBases(mainEnemy) == 2 && drones >= 10 && drones <= 12) {
                enemyStrat = EnemyStrats.FastHatch;
                Util.sendText("Nice 12 Hatch");
                if (!(Ecgberht.getGs().getStrat().name.contains("GreedyFE") || Ecgberht.getGs().getStrat().proxy || Ecgberht.getGs().getStrat().trainUnits.contains(UnitType.Terran_Wraith))) {
                    Ecgberht.getGs().iReallyWantToExpand = true;
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().naturalChoke.getCenter().toPosition();
                    Ecgberht.transition();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean detectNinePool() {
        if (Ecgberht.getGs().frameCount <= 4320 && Ecgberht.getGs().enemyStartBase != null && exploredMinerals) {
            int drones = IntelligenceAgency.getNumEnemyWorkers();
            boolean foundPool = IntelligenceAgency.enemyHasType(UnitType.Zerg_Spawning_Pool);
            boolean foundExtractor = IntelligenceAgency.enemyHasType(UnitType.Zerg_Extractor);
            if (foundPool && IntelligenceAgency.getNumEnemyBases(mainEnemy) < 2 && drones >= 7 && drones <= 10) {
                enemyStrat = EnemyStrats.NinePool;
                Util.sendText(drones == 10 || foundExtractor ? "Nice Overpool" : "Nice 9 pool");
                Ecgberht.getGs().getStrat().bunker = true;
                String strat = Ecgberht.getGs().getStrat().name;
                if (strat.equals("14CC")) {
                    Ecgberht.getGs().setStrat(new FullBio());
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    Ecgberht.transition();
                }
                if (strat.contains("GreedyFE")) {
                    Ecgberht.getGs().setStrat(new FullBio());
                    Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                    Ecgberht.transition();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean detectProtossFE() {
        if (Ecgberht.getGs().frameCount <= 5040 && Ecgberht.getGs().enemyStartBase != null) {
            int probes = IntelligenceAgency.getNumEnemyWorkers();
            if (IntelligenceAgency.getNumEnemyBases(mainEnemy) > 1 && probes <= 16) {
                enemyStrat = EnemyStrats.ProtossFE;
                Util.sendText("Nice FE");
                String strat = Ecgberht.getGs().getStrat().name;
                if (strat.equals("FullBio") || strat.equals("FullBioFE")) {
                    Ecgberht.getGs().setStrat(new BioGreedyFE());
                }
                if (strat.equals("BioMech") || strat.equals("BioMechFE")) {
                    Ecgberht.getGs().setStrat(new BioMechGreedyFE());
                }
                if (strat.equals("FullMech")) {
                    Ecgberht.getGs().setStrat(new MechGreedyFE());
                }
                if (strat.contains("GreedyFE")) {
                    Ecgberht.getGs().getStrat().armyForAttack += 10;
                }
                Ecgberht.getGs().defendPosition = Ecgberht.getGs().naturalChoke.getCenter().toPosition();
                Ecgberht.transition();
                return true;
            }
        }
        return false;
    }

    static void onFrame() {
        if (Ecgberht.getGs().enemyStartBase == null) {
            return;
        }
        IntelligenceAgency.detectEnemyStrategy();
        IntelligenceAgency.updateMaxAmountTypes();
    }

    private static int updateGoliaths() {
        int goliaths = 0;
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                boolean spire = IntelligenceAgency.mainEnemyHasType(UnitType.Zerg_Spire, UnitType.Zerg_Greater_Spire);
                if (spire) {
                    goliaths += 3;
                }
                Integer amount = mainEnemyUnitTypeAmount.get(UnitType.Zerg_Mutalisk);
                goliaths = (int)((long)goliaths + (amount != null ? Math.round((double)amount.intValue() / 2.0) : 0L));
                break;
            }
            case Terran: {
                Integer amount = mainEnemyUnitTypeAmount.get(UnitType.Terran_Wraith);
                goliaths = (int)((double)goliaths + (amount != null ? Math.ceil(amount.doubleValue() / 2.0) : 0.0));
                amount = mainEnemyUnitTypeAmount.get(UnitType.Terran_Battlecruiser);
                goliaths += amount != null ? amount * 3 : 0;
                break;
            }
            case Protoss: {
                Integer amount = mainEnemyUnitTypeAmount.get(UnitType.Protoss_Scout);
                goliaths += amount != null ? amount : 0;
                Integer stargateAmount = mainEnemyUnitTypeAmount.get(UnitType.Protoss_Stargate);
                if (stargateAmount != null && stargateAmount > 0) {
                    goliaths += 3;
                }
                goliaths += (amount = mainEnemyUnitTypeAmount.get(UnitType.Protoss_Carrier)) != null ? amount * 3 : 0;
            }
        }
        return Math.min(20, goliaths);
    }

    private static int updateVessels() {
        Strategy strat = Ecgberht.getGs().getStrat();
        String stratName = strat.name.toLowerCase();
        if (Ecgberht.getGs().getArmySize() <= 12) {
            return 0;
        }
        if (Ecgberht.getGs().enemyRace == Race.Zerg && stratName.contains("bio")) {
            int mm = (int)Ecgberht.getGs().myArmy.stream().filter(u -> u.unitType == UnitType.Terran_Marine || u.unitType == UnitType.Terran_Medic).count();
            if (stratName.contains("full") || stratName.contains("greedy")) {
                return Math.max(3, mm % 14);
            }
            return Math.max(3, mm % 18);
        }
        return Ecgberht.getGs().enemyRace == Race.Protoss && IntelligenceAgency.enemyHasType(UnitType.Protoss_Arbiter) ? 4 : 2;
    }

    private static int updateFirebats() {
        return (int)Math.min(Math.max(3.0, Math.exp(((double)IntelligenceAgency.getNumberEnemyType(UnitType.Zerg_Zergling) - 3.0) / 20.0)), 15.0);
    }

    private static boolean canTrainVessels() {
        boolean tower = false;
        boolean science = false;
        for (ResearchingFacility u : Ecgberht.getGs().UBs) {
            if (u instanceof ControlTower) {
                tower = true;
            } else if (u instanceof ScienceFacility) {
                science = true;
            }
            if (!science || !tower) continue;
            break;
        }
        return science && tower;
    }

    private static void updateMaxAmountTypes() {
        if (Ecgberht.getGs().getStrat().trainUnits.contains(UnitType.Terran_Goliath)) {
            Ecgberht.getGs().maxGoliaths = IntelligenceAgency.updateGoliaths();
        }
        if (IntelligenceAgency.canTrainVessels()) {
            Ecgberht.getGs().maxVessels = IntelligenceAgency.updateVessels();
        }
        if (Ecgberht.getGs().getStrat().trainUnits.contains(UnitType.Terran_Firebat)) {
            Ecgberht.getGs().maxBats = IntelligenceAgency.updateFirebats();
        }
    }

    private static boolean detectCannonRush() {
        if (Ecgberht.getGs().frameCount < 5040 && Ecgberht.getGs().enemyStartBase != null) {
            boolean foundForge = false;
            boolean foundGas = IntelligenceAgency.enemyHasType(UnitType.Protoss_Assimilator);
            if (exploredMinerals) {
                for (UnitInfo u2 : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                    if (u2.unitType != UnitType.Protoss_Forge || !Ecgberht.getGs().bwem.getMap().getArea(u2.tileposition).equals(Ecgberht.getGs().enemyMainArea)) continue;
                    foundForge = true;
                    break;
                }
            }
            boolean somethingInMyBase = false;
            for (UnitInfo u3 : Ecgberht.getGs().unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                if (u3.unitType != UnitType.Protoss_Pylon && u3.unitType != UnitType.Protoss_Photon_Cannon || !Ecgberht.getGs().bwem.getMap().getArea(u3.tileposition).equals(Ecgberht.getGs().BLs.get(0).getArea()) && !Ecgberht.getGs().bwem.getMap().getArea(u3.tileposition).equals(Ecgberht.getGs().BLs.get(1).getArea())) continue;
                somethingInMyBase = true;
                break;
            }
            if (foundForge && !foundGas || somethingInMyBase) {
                enemyStrat = EnemyStrats.CannonRush;
                Util.sendText("Cannon rusher T_T");
                Ecgberht.getGs().playSound("rushed.mp3");
                Ecgberht.getGs().setStrat(new FullMech());
                Ecgberht.getGs().getStrat().armyForExpand += 10;
                Ecgberht.getGs().defendPosition = Ecgberht.getGs().mainChoke.getCenter().toPosition();
                Ecgberht.transition();
                return true;
            }
        }
        return false;
    }

    private static boolean checkExploredEnemyMinerals() {
        for (Mineral m : Ecgberht.getGs().enemyStartBase.getMinerals()) {
            if (Ecgberht.getGs().getGame().getBWMap().isExplored(m.getUnit().getTilePosition())) continue;
            return false;
        }
        return true;
    }

    public static boolean enemyIsRushing() {
        boolean timeCheck = Ecgberht.getGs().frameCount <= 11520;
        boolean rushStratDetected = enemyStrat == EnemyStrats.ZealotRush || enemyStrat == EnemyStrats.EarlyPool || enemyStrat == EnemyStrats.CannonRush || enemyStrat == EnemyStrats.NinePool || Ecgberht.getGs().learningManager.isNaughty();
        boolean raceCheck = false;
        if (timeCheck && rushStratDetected) {
            return true;
        }
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                if (Ecgberht.getGs().enemyInBase.stream().filter(u -> u instanceof Zergling).count() < 4L || Ecgberht.getGs().myArmy.size() >= 4) break;
                raceCheck = true;
                break;
            }
            case Terran: {
                if (Ecgberht.getGs().enemyInBase.stream().filter(u -> u instanceof SCV).count() >= 3L && Ecgberht.getGs().myArmy.size() < 3) {
                    raceCheck = true;
                    break;
                }
                if (Ecgberht.getGs().enemyInBase.stream().filter(u -> u instanceof Marine).count() <= (long)Ecgberht.getGs().myArmy.size()) break;
                raceCheck = true;
                break;
            }
            case Protoss: {
                if (Ecgberht.getGs().enemyInBase.stream().filter(u -> u instanceof Probe).count() >= 3L && Ecgberht.getGs().myArmy.size() < 3) {
                    raceCheck = true;
                    break;
                }
                if (Ecgberht.getGs().enemyInBase.stream().filter(u -> u instanceof Zealot).count() < 3L || Ecgberht.getGs().myArmy.size() >= 6) break;
                raceCheck = true;
            }
        }
        return timeCheck && raceCheck;
    }

    public static boolean enemyHasAirOrCloakedThreats() {
        if (cloakedThreats) {
            return true;
        }
        switch (Ecgberht.getGs().enemyRace) {
            case Zerg: {
                cloakedThreats = IntelligenceAgency.mainEnemyHasType(UnitType.Zerg_Lurker) || IntelligenceAgency.mainEnemyHasType(UnitType.Zerg_Mutalisk);
                break;
            }
            case Terran: {
                cloakedThreats = IntelligenceAgency.mainEnemyHasType(UnitType.Terran_Wraith);
                break;
            }
            case Protoss: {
                boolean bl = cloakedThreats = IntelligenceAgency.mainEnemyHasType(UnitType.Protoss_Dark_Templar) || IntelligenceAgency.mainEnemyHasType(UnitType.Protoss_Carrier);
            }
        }
        if (cloakedThreats && Ecgberht.getGs().getStrat().numBays == 0) {
            ++Ecgberht.getGs().getStrat().numBays;
        }
        return cloakedThreats;
    }

    static {
        enemyStrat = EnemyStrats.Unknown;
        startStrat = null;
        exploredMinerals = false;
        cloakedThreats = false;
    }

    public static enum EnemyStrats {
        Unknown,
        EarlyPool,
        ZealotRush,
        CannonRush,
        ProtossFE,
        NinePool,
        FastHatch,
        BioPush,
        MechRush;

    }
}

