/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.BWEM;
import bwem.Base;
import cameraModule.CameraModule;
import ecgberht.Agents.DropShipAgent;
import ecgberht.Agents.VesselAgent;
import ecgberht.Agents.VultureAgent;
import ecgberht.Agents.WraithAgent;
import ecgberht.BaseManager;
import ecgberht.BehaviourTrees.AddonBuild.BuildAddon;
import ecgberht.BehaviourTrees.AddonBuild.CheckResourcesAddon;
import ecgberht.BehaviourTrees.AddonBuild.ChooseComsatStation;
import ecgberht.BehaviourTrees.AddonBuild.ChooseMachineShop;
import ecgberht.BehaviourTrees.AddonBuild.ChooseTower;
import ecgberht.BehaviourTrees.Build.Build;
import ecgberht.BehaviourTrees.Build.CheckMineralWalkGoldRush;
import ecgberht.BehaviourTrees.Build.CheckResourcesBuilding;
import ecgberht.BehaviourTrees.Build.ChooseAcademy;
import ecgberht.BehaviourTrees.Build.ChooseArmory;
import ecgberht.BehaviourTrees.Build.ChooseBarracks;
import ecgberht.BehaviourTrees.Build.ChooseBay;
import ecgberht.BehaviourTrees.Build.ChooseBunker;
import ecgberht.BehaviourTrees.Build.ChooseExpand;
import ecgberht.BehaviourTrees.Build.ChooseFactory;
import ecgberht.BehaviourTrees.Build.ChooseNothingBuilding;
import ecgberht.BehaviourTrees.Build.ChoosePort;
import ecgberht.BehaviourTrees.Build.ChoosePosition;
import ecgberht.BehaviourTrees.Build.ChooseRefinery;
import ecgberht.BehaviourTrees.Build.ChooseScience;
import ecgberht.BehaviourTrees.Build.ChooseSupply;
import ecgberht.BehaviourTrees.Build.ChooseTurret;
import ecgberht.BehaviourTrees.Build.ChooseWorker;
import ecgberht.BehaviourTrees.Build.Move;
import ecgberht.BehaviourTrees.Build.WorkerWalkBuild;
import ecgberht.BehaviourTrees.BuildingLot.CheckBuildingsLot;
import ecgberht.BehaviourTrees.BuildingLot.ChooseBlotWorker;
import ecgberht.BehaviourTrees.BuildingLot.ChooseBuildingLot;
import ecgberht.BehaviourTrees.BuildingLot.FinishBuilding;
import ecgberht.BehaviourTrees.Defense.CheckPerimeter;
import ecgberht.BehaviourTrees.Defense.ChooseDefensePosition;
import ecgberht.BehaviourTrees.Defense.SendDefenders;
import ecgberht.BehaviourTrees.Harass.CheckExplorer;
import ecgberht.BehaviourTrees.Harass.CheckHarasser;
import ecgberht.BehaviourTrees.Harass.CheckHarasserAttacked;
import ecgberht.BehaviourTrees.Harass.ChooseBuilderToHarass;
import ecgberht.BehaviourTrees.Harass.ChooseBuildingToHarass;
import ecgberht.BehaviourTrees.Harass.ChooseWorkerToHarass;
import ecgberht.BehaviourTrees.Harass.Explore;
import ecgberht.BehaviourTrees.Harass.HarassWorker;
import ecgberht.BehaviourTrees.IslandExpansion.CheckBlockingMinerals;
import ecgberht.BehaviourTrees.IslandExpansion.CheckDropped;
import ecgberht.BehaviourTrees.IslandExpansion.CheckExpandingIsland;
import ecgberht.BehaviourTrees.IslandExpansion.CheckIslands;
import ecgberht.BehaviourTrees.IslandExpansion.CheckResourcesIsland;
import ecgberht.BehaviourTrees.IslandExpansion.ChooseDropShip;
import ecgberht.BehaviourTrees.IslandExpansion.ChooseIsland;
import ecgberht.BehaviourTrees.IslandExpansion.ChooseWorkerDrop;
import ecgberht.BehaviourTrees.IslandExpansion.MoveIsland;
import ecgberht.BehaviourTrees.IslandExpansion.SendToDrop;
import ecgberht.BehaviourTrees.Recollection.CollectGas;
import ecgberht.BehaviourTrees.Recollection.CollectMineral;
import ecgberht.BehaviourTrees.Recollection.FreeWorker;
import ecgberht.BehaviourTrees.Repair.CheckBuildingFlames;
import ecgberht.BehaviourTrees.Repair.ChooseRepairer;
import ecgberht.BehaviourTrees.Repair.Repair;
import ecgberht.BehaviourTrees.Scanner.CheckScan;
import ecgberht.BehaviourTrees.Scanner.Scan;
import ecgberht.BehaviourTrees.Scouting.CheckEnemyBaseVisible;
import ecgberht.BehaviourTrees.Scouting.CheckMineralWalk;
import ecgberht.BehaviourTrees.Scouting.CheckScout;
import ecgberht.BehaviourTrees.Scouting.CheckVisibleBase;
import ecgberht.BehaviourTrees.Scouting.ChooseScout;
import ecgberht.BehaviourTrees.Scouting.SendScout;
import ecgberht.BehaviourTrees.Training.CheckResourcesUnit;
import ecgberht.BehaviourTrees.Training.ChooseFireBat;
import ecgberht.BehaviourTrees.Training.ChooseGoliath;
import ecgberht.BehaviourTrees.Training.ChooseMarine;
import ecgberht.BehaviourTrees.Training.ChooseMedic;
import ecgberht.BehaviourTrees.Training.ChooseNothingTrain;
import ecgberht.BehaviourTrees.Training.ChooseSCV;
import ecgberht.BehaviourTrees.Training.ChooseSituationalUnit;
import ecgberht.BehaviourTrees.Training.ChooseTank;
import ecgberht.BehaviourTrees.Training.ChooseVulture;
import ecgberht.BehaviourTrees.Training.ChooseWraith;
import ecgberht.BehaviourTrees.Training.TrainUnit;
import ecgberht.BehaviourTrees.Upgrade.CheckResourcesUpgrade;
import ecgberht.BehaviourTrees.Upgrade.ChooseArmorInfUp;
import ecgberht.BehaviourTrees.Upgrade.ChooseArmorMechUp;
import ecgberht.BehaviourTrees.Upgrade.ChooseCharonBoosters;
import ecgberht.BehaviourTrees.Upgrade.ChooseEMP;
import ecgberht.BehaviourTrees.Upgrade.ChooseIrradiate;
import ecgberht.BehaviourTrees.Upgrade.ChooseMarineRange;
import ecgberht.BehaviourTrees.Upgrade.ChooseSiegeMode;
import ecgberht.BehaviourTrees.Upgrade.ChooseStimUpgrade;
import ecgberht.BehaviourTrees.Upgrade.ChooseVultureSpeed;
import ecgberht.BehaviourTrees.Upgrade.ChooseWeaponInfUp;
import ecgberht.BehaviourTrees.Upgrade.ChooseWeaponMechUp;
import ecgberht.BehaviourTrees.Upgrade.ResearchUpgrade;
import ecgberht.BuildingMap;
import ecgberht.Cartographer;
import ecgberht.CherryVis.CherryVisDumper;
import ecgberht.ConfigManager;
import ecgberht.DebugManager;
import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.Strategies.BioMechFE;
import ecgberht.Strategies.FullBio;
import ecgberht.Strategies.FullBioFE;
import ecgberht.Strategies.FullMech;
import ecgberht.StrategyManager;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.bk.ass.path.Position;
import org.bk.ass.path.Result;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.composite.Selector;
import org.iaie.btree.task.composite.Sequence;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.BWEventListener;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.unit.Addon;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.ComsatStation;
import org.openbw.bwapi4j.unit.Critter;
import org.openbw.bwapi4j.unit.Factory;
import org.openbw.bwapi4j.unit.GasMiningFacility;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.MissileTurret;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Refinery;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.ResourceDepot;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.ScannerSweep;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.SpecialBuilding;
import org.openbw.bwapi4j.unit.Starport;
import org.openbw.bwapi4j.unit.SupplyDepot;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.Vulture;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.unit.Wraith;

public class Ecgberht
implements BWEventListener {
    private static BW bw;
    private static InteractionHandler ih;
    private static GameState gs;
    private static BehavioralTree addonBuildTree;
    private static BehavioralTree buildTree;
    private static BehavioralTree trainTree;
    private static BehavioralTree upgradeTree;
    private BehavioralTree botherTree;
    private BehavioralTree buildingLotTree;
    private BehavioralTree collectTree;
    private BehavioralTree defenseTree;
    private BehavioralTree repairTree;
    private BehavioralTree scannerTree;
    private BehavioralTree scoutingTree;
    private BehavioralTree islandTree;
    private boolean first = false;
    private Player self;
    private BWEM bwem = null;
    private DebugManager debugManager = null;
    private CameraModule skycladObserver = null;
    private CherryVisDumper cherryVisDumper;
    private Result path;

    public static void main(String[] args) {
        new Ecgberht().run();
    }

    public static BW getGame() {
        return bw;
    }

    public static GameState getGs() {
        return gs;
    }

    static void transition() {
        Ecgberht.initTrainTree();
        Ecgberht.initBuildTree();
        Ecgberht.initUpgradeTree();
        Ecgberht.initAddonBuildTree();
    }

    private static void initTrainTree() {
        ChooseSituationalUnit cSU = new ChooseSituationalUnit("Choose situational unit", gs);
        ChooseNothingTrain cNT = new ChooseNothingTrain("Choose Nothing To Train", gs);
        ChooseSCV cSCV = new ChooseSCV("Choose SCV", gs);
        ChooseFireBat cFir = new ChooseFireBat("Choose Firebat", gs);
        ChooseMarine cMar = new ChooseMarine("Choose Marine", gs);
        ChooseMedic cMed = new ChooseMedic("Choose Medic", gs);
        ChooseTank cTan = new ChooseTank("Choose Tank", gs);
        ChooseVulture cVul = new ChooseVulture("Choose vulture", gs);
        ChooseGoliath cGol = new ChooseGoliath("Choose Goliath", gs);
        ChooseWraith cWra = new ChooseWraith("Choose Wraith", gs);
        CheckResourcesUnit cr = new CheckResourcesUnit("Check Cash", gs);
        TrainUnit tr = new TrainUnit("Train Unit", gs);
        Selector chooseUnit = new Selector("Choose Recruit", cNT, cSU, cSCV);
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Goliath)) {
            chooseUnit.addChild(cGol);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Siege_Tank_Tank_Mode)) {
            chooseUnit.addChild(cTan);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Vulture)) {
            chooseUnit.addChild(cVul);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Wraith)) {
            chooseUnit.addChild(cWra);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Medic)) {
            chooseUnit.addChild(cMed);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Firebat) && Ecgberht.gs.enemyRace == Race.Zerg) {
            chooseUnit.addChild(cFir);
        }
        if (Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Marine)) {
            chooseUnit.addChild(cMar);
        }
        Sequence train = new Sequence("Train", chooseUnit, cr, tr);
        trainTree = new BehavioralTree("Training Tree");
        trainTree.addChild(train);
    }

    private static void initBuildTree() {
        Build b = new Build("Build", gs);
        WorkerWalkBuild wwB = new WorkerWalkBuild("worker walk build", gs);
        CheckMineralWalkGoldRush cMWGR = new CheckMineralWalkGoldRush("Mineral Walk Gold Rush", gs);
        ChooseNothingBuilding cNB = new ChooseNothingBuilding("Choose Nothing", gs);
        ChooseExpand cE = new ChooseExpand("Choose Expansion", gs);
        ChooseSupply cSup = new ChooseSupply("Choose Supply Depot", gs);
        ChooseBunker cBun = new ChooseBunker("Choose Bunker", gs);
        ChooseBarracks cBar = new ChooseBarracks("Choose Barracks", gs);
        ChooseFactory cFar = new ChooseFactory("Choose Factory", gs);
        ChoosePort cPor = new ChoosePort("Choose Star Port", gs);
        ChooseScience cSci = new ChooseScience("Choose Science Facility", gs);
        ChooseRefinery cRef = new ChooseRefinery("Choose Refinery", gs);
        ChooseBay cBay = new ChooseBay("Choose Bay", gs);
        ChooseTurret cTur = new ChooseTurret("Choose Turret", gs);
        ChooseAcademy cAca = new ChooseAcademy("Choose Academy", gs);
        ChooseArmory cArm = new ChooseArmory("Choose Armory", gs);
        CheckResourcesBuilding crb = new CheckResourcesBuilding("Check Cash", gs);
        ChoosePosition cp = new ChoosePosition("Choose Position", gs);
        ChooseWorker cw = new ChooseWorker("Choose Worker", gs);
        Move m = new Move("Move to chosen building position", gs);
        Selector chooseBuildingBuild = new Selector("Choose Building to build", cNB, cE, cBun, cSup);
        chooseBuildingBuild.addChild(cTur);
        chooseBuildingBuild.addChild(cRef);
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Academy)) {
            chooseBuildingBuild.addChild(cAca);
        }
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Engineering_Bay)) {
            chooseBuildingBuild.addChild(cBay);
        }
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Armory)) {
            chooseBuildingBuild.addChild(cArm);
        }
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Factory)) {
            chooseBuildingBuild.addChild(cFar);
        }
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Starport)) {
            chooseBuildingBuild.addChild(cPor);
        }
        if (Ecgberht.gs.getStrat().buildUnits.contains(UnitType.Terran_Science_Facility)) {
            chooseBuildingBuild.addChild(cSci);
        }
        chooseBuildingBuild.addChild(cBar);
        Sequence buildMove = bw.getBWMap().mapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1") ? new Sequence("BuildMove", wwB, b, chooseBuildingBuild, cp, cw, crb, m) : (bw.getBWMap().mapHash().equals("666dd28cd3c85223ebc749a481fc281e58221e4a") ? new Sequence("BuildMove", cMWGR, b, chooseBuildingBuild, cp, cw, crb, m) : new Sequence("BuildMove", b, chooseBuildingBuild, cp, cw, crb, m));
        buildTree = new BehavioralTree("Building Tree");
        buildTree.addChild(buildMove);
    }

    private static void initUpgradeTree() {
        CheckResourcesUpgrade cRU = new CheckResourcesUpgrade("Check Resources Upgrade", gs);
        ChooseIrradiate cI = new ChooseIrradiate("Choose Irradiate", gs);
        ChooseEMP cEMP = new ChooseEMP("Choose EMP", gs);
        ChooseArmorMechUp cAMU = new ChooseArmorMechUp("Choose Armor mech upgrade", gs);
        ChooseWeaponMechUp cWMU = new ChooseWeaponMechUp("Choose weapon mech upgrade", gs);
        ChooseArmorInfUp cAIU = new ChooseArmorInfUp("Choose Armor inf upgrade", gs);
        ChooseWeaponInfUp cWIU = new ChooseWeaponInfUp("Choose Weapon inf upgrade", gs);
        ChooseMarineRange cMR = new ChooseMarineRange("Choose Marine Range upgrade", gs);
        ChooseStimUpgrade cSU = new ChooseStimUpgrade("Choose Stimpack upgrade", gs);
        ChooseSiegeMode cSM = new ChooseSiegeMode("Choose Siege Mode", gs);
        ChooseCharonBoosters cCB = new ChooseCharonBoosters("Choose Charon Boosters", gs);
        ChooseVultureSpeed cVS = new ChooseVultureSpeed("Choose Vulture Speed", gs);
        ResearchUpgrade rU = new ResearchUpgrade("Research Upgrade", gs);
        Selector ChooseUP = new Selector("Choose Upgrade");
        ChooseUP.addChild(cI);
        ChooseUP.addChild(cEMP);
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Terran_Infantry_Weapons)) {
            ChooseUP.addChild(cWIU);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Terran_Infantry_Armor)) {
            ChooseUP.addChild(cAIU);
        }
        if (Ecgberht.gs.getStrat().techToResearch.contains(TechType.Stim_Packs)) {
            ChooseUP.addChild(cSU);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.U_238_Shells)) {
            ChooseUP.addChild(cMR);
        }
        if (Ecgberht.gs.getStrat().techToResearch.contains(TechType.Tank_Siege_Mode)) {
            ChooseUP.addChild(cSM);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Ion_Thrusters)) {
            ChooseUP.addChild(cVS);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Charon_Boosters)) {
            ChooseUP.addChild(cCB);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Terran_Vehicle_Weapons)) {
            ChooseUP.addChild(cWMU);
        }
        if (Ecgberht.gs.getStrat().upgradesToResearch.contains(UpgradeType.Terran_Vehicle_Plating)) {
            ChooseUP.addChild(cAMU);
        }
        Sequence Upgrader = new Sequence("Upgrader", ChooseUP, cRU, rU);
        upgradeTree = new BehavioralTree("Technology");
        upgradeTree.addChild(Upgrader);
    }

    private static void initAddonBuildTree() {
        BuildAddon bA = new BuildAddon("Build Addon", gs);
        CheckResourcesAddon cRA = new CheckResourcesAddon("Check Resources Addon", gs);
        ChooseComsatStation cCS = new ChooseComsatStation("Choose Comsat Station", gs);
        ChooseMachineShop cMS = new ChooseMachineShop("Choose Machine Shop", gs);
        ChooseTower cT = new ChooseTower("Choose Control Tower", gs);
        Selector ChooseAddon = new Selector("Choose Addon");
        if (Ecgberht.gs.getStrat().buildAddons.contains(UnitType.Terran_Machine_Shop)) {
            ChooseAddon.addChild(cMS);
        }
        if (Ecgberht.gs.getStrat().buildAddons.contains(UnitType.Terran_Comsat_Station)) {
            ChooseAddon.addChild(cCS);
        }
        if (Ecgberht.gs.getStrat().buildAddons.contains(UnitType.Terran_Control_Tower)) {
            ChooseAddon.addChild(cT);
        }
        Sequence Addon2 = new Sequence("Addon", ChooseAddon, cRA, bA);
        addonBuildTree = new BehavioralTree("Addon Build Tree");
        addonBuildTree.addChild(Addon2);
    }

    private void initIslandTree() {
        CheckIslands chI = new CheckIslands("Check islands", gs);
        CheckExpandingIsland cEI = new CheckExpandingIsland("Check Expanding To Island", gs);
        CheckDropped chD = new CheckDropped("Check Dropped", gs);
        CheckBlockingMinerals cBM = new CheckBlockingMinerals("Check Blocking minerals", gs);
        CheckResourcesIsland cRI = new CheckResourcesIsland("Check resources Island", gs);
        MoveIsland mI = new MoveIsland("Move Island", gs);
        ChooseDropShip cD = new ChooseDropShip("Choose DropShip", gs);
        ChooseIsland cI = new ChooseIsland("Choose Island", gs);
        ChooseWorkerDrop cWD = new ChooseWorkerDrop("Choose Worker Drop", gs);
        SendToDrop sD = new SendToDrop("Send To Drop", gs);
        Sequence chooseThings = new Sequence("Choose things", cD, cI, cWD, sD);
        Sequence expand = new Sequence("Island expand", cEI, chD, cBM, cRI, mI);
        Selector expanding = new Selector("Check if already expanding", expand, cEI, chooseThings);
        Sequence islandExpansion = new Sequence("island expansion", chI, expanding);
        this.islandTree = new BehavioralTree("islandTree");
        this.islandTree.addChild(islandExpansion);
    }

    private void run() {
        bw = new BW(this);
        bw.startGame();
    }

    private void initScoutingTree() {
        CheckScout cSc = new CheckScout("Check Scout", gs);
        ChooseScout chSc = new ChooseScout("Choose Scouter", gs);
        SendScout sSc = new SendScout("Send Scout", gs);
        CheckMineralWalk cMW = new CheckMineralWalk("Check Mineral Walk", gs);
        CheckVisibleBase cVB = new CheckVisibleBase("Check visible Base", gs);
        CheckEnemyBaseVisible cEBV = new CheckEnemyBaseVisible("Check Enemy Base Visible", gs);
        Sequence scoutFalse = new Sequence("Scout ", cSc, chSc, sSc);
        Selector EnemyFound = new Selector("Enemy found in base location", cEBV, sSc);
        Sequence scoutTrue = new Sequence("Scout True", cMW, cVB, EnemyFound);
        Selector Scouting = new Selector("Select Scouting Plan", scoutFalse, scoutTrue);
        this.scoutingTree = new BehavioralTree("Movement Tree");
        this.scoutingTree.addChild(Scouting);
    }

    private void initDefenseTree() {
        CheckPerimeter cP = new CheckPerimeter("Check Perimeter", gs);
        ChooseDefensePosition cDP = new ChooseDefensePosition("Choose Defence Position", gs);
        SendDefenders sD = new SendDefenders("Send Defenders", gs);
        Sequence Defense = new Sequence("Defence", cP, cDP, sD);
        this.defenseTree = new BehavioralTree("Defence Tree");
        this.defenseTree.addChild(Defense);
    }

    private void initRepairTree() {
        CheckBuildingFlames cBF = new CheckBuildingFlames("Check building in flames", gs);
        ChooseRepairer cR = new ChooseRepairer("Choose Repairer", gs);
        Repair R = new Repair("Repair Building", gs);
        Sequence Repair2 = new Sequence("Repair", cBF, cR, R);
        this.repairTree = new BehavioralTree("RepairTree");
        this.repairTree.addChild(Repair2);
    }

    private void initBuildingLotTree() {
        CheckBuildingsLot chBL = new CheckBuildingsLot("Check Buildings Lot", gs);
        ChooseBlotWorker cBW = new ChooseBlotWorker("Choose Building Lot worker", gs);
        ChooseBuildingLot cBLot = new ChooseBuildingLot("Choose Building Lot building", gs);
        FinishBuilding fB = new FinishBuilding("Finish Building", gs);
        Sequence BLot = new Sequence("Building Lot", chBL, cBLot, cBW, fB);
        this.buildingLotTree = new BehavioralTree("Building Lot Tree");
        this.buildingLotTree.addChild(BLot);
    }

    private void initScanTree() {
        CheckScan cScan = new CheckScan("Check scan", gs);
        Scan s = new Scan("Scan", gs);
        Sequence Scanning = new Sequence("Scanning", cScan, s);
        this.scannerTree = new BehavioralTree("Scanner Tree");
        this.scannerTree.addChild(Scanning);
    }

    private void initHarassTree() {
        CheckHarasser cH = new CheckHarasser("Check Harasser", gs);
        CheckExplorer cE = new CheckExplorer("Check Explorer", gs);
        ChooseWorkerToHarass cWTH = new ChooseWorkerToHarass("Check Worker to Harass", gs);
        ChooseBuilderToHarass cWTB = new ChooseBuilderToHarass("Check Worker to Harass", gs);
        CheckHarasserAttacked cHA = new CheckHarasserAttacked("Check Harasser Attacked", gs);
        ChooseBuildingToHarass cBTH = new ChooseBuildingToHarass("Check Building to Harass", gs);
        Explore E = new Explore("Explore", gs);
        HarassWorker hW = new HarassWorker("Bother SCV", gs);
        Selector bOw = new Selector("Choose Builder or Worker or Building", cWTH, cWTB, cBTH);
        Sequence harassAttack = new Sequence("Harass", cHA, bOw, hW);
        Sequence explorer = new Sequence("Explorer", cE, E);
        Selector eOh = new Selector("Explorer or harasser", explorer, harassAttack);
        Sequence harass = new Sequence("Harass", cH, eOh);
        this.botherTree = new BehavioralTree("Harass Tree");
        this.botherTree.addChild(harass);
    }

    private void initCollectTree() {
        CollectGas cg = new CollectGas("Collect Gas", gs);
        CollectMineral cm = new CollectMineral("Collect Mineral", gs);
        FreeWorker fw = new FreeWorker("No Union", gs);
        Selector collectResources = new Selector("Collect Melted Cash", cg, cm);
        Sequence collect = new Sequence("Collect", fw, collectResources);
        this.collectTree = new BehavioralTree("Recollection Tree");
        this.collectTree.addChild(collect);
    }

    @Override
    public void onStart() {
        try {
            ConfigManager.readConfig();
            if (!ConfigManager.getConfig().ecgConfig.debugConsole) {
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream("NUL:");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                PrintStream nullOut = new PrintStream(Objects.requireNonNull(output));
                System.setErr(nullOut);
                System.setOut(nullOut);
            }
            if (ConfigManager.getConfig().ecgConfig.humanMode) {
                ConfigManager.getConfig().ecgConfig.sounds = false;
                ConfigManager.getConfig().ecgConfig.debugConsole = false;
                ConfigManager.getConfig().ecgConfig.debugScreen = false;
                ConfigManager.getConfig().ecgConfig.debugText = false;
                ConfigManager.getConfig().ecgConfig.enableCherryVisDump = false;
                ConfigManager.getConfig().ecgConfig.enableLatCom = true;
                ConfigManager.getConfig().ecgConfig.forceStrat = "";
                ConfigManager.getConfig().ecgConfig.sscait = true;
            }
            this.self = bw.getInteractionHandler().self();
            this.skycladObserver = new CameraModule(this.self.getStartLocation(), bw);
            ih = bw.getInteractionHandler();
            this.debugManager = new DebugManager(bw.getMapDrawer(), bw.getInteractionHandler(), this.skycladObserver);
            IntelligenceAgency.onStartIntelligenceAgency(ih.enemy());
            if (!ConfigManager.getConfig().ecgConfig.enableLatCom) {
                ih.enableLatCom(false);
            } else {
                ih.enableLatCom(true);
            }
            if (ConfigManager.getConfig().bwapiConfig.completeMapInformation) {
                ih.enableCompleteMapInformation();
            }
            if (ConfigManager.getConfig().bwapiConfig.frameSkip != 0) {
                ih.setFrameSkip(ConfigManager.getConfig().bwapiConfig.frameSkip);
            }
            if (ConfigManager.getConfig().bwapiConfig.localSpeed >= 0) {
                ih.setLocalSpeed(ConfigManager.getConfig().bwapiConfig.localSpeed);
            }
            if (ConfigManager.getConfig().bwapiConfig.userInput) {
                ih.enableUserInput();
            }
            this.bwem = new BWEM(bw);
            if (bw.getBWMap().mapHash().equals("69a3b6a5a3d4120e47408defd3ca44c954997948")) {
                Util.sendText("Hitchhiker :(");
            }
            this.bwem.initialize();
            if (!bw.getBWMap().mapHash().equals("e6d0144e14315118d916905ff5e7045f68db541e")) {
                this.bwem.getMap().assignStartingLocationsToSuitableBases();
            }
            gs = new GameState(bw, this.bwem);
            Ecgberht.gs.baseManager = new BaseManager(this.bwem);
            gs.initEnemyRace();
            Ecgberht.gs.learningManager.onStart(ih.enemy().getName(), Util.raceToString(bw.getInteractionHandler().enemy().getRace()));
            gs.alwaysPools();
            if (Ecgberht.gs.enemyRace == Race.Zerg && Ecgberht.gs.learningManager.isNaughty()) {
                gs.playSound("rushed.mp3");
            }
            Ecgberht.gs.scipio = new StrategyManager();
            IntelligenceAgency.setStartStrat(Ecgberht.gs.getStrat().name);
            gs.initStartLocations();
            boolean fortress = bw.getBWMap().mapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1");
            for (Base b : this.bwem.getMap().getBases()) {
                if (fortress) {
                    if (b.getMinerals().size() < 3) continue;
                    if (Ecgberht.gs.fortressSpecialBLsTiles.contains(b.getLocation())) {
                        Ecgberht.gs.fortressSpecialBLs.put(b, gs.getMineralWalkPatchesFortress(b));
                    }
                    Ecgberht.gs.BLs.add(b);
                    continue;
                }
                if (b.getArea().getAccessibleNeighbors().isEmpty()) {
                    Ecgberht.gs.islandBases.add(b);
                    continue;
                }
                Ecgberht.gs.BLs.add(b);
            }
            if (bw.getBWMap().mapHash().equals("666dd28cd3c85223ebc749a481fc281e58221e4a")) {
                gs.initMineralWalkPatches();
            }
            gs.initBlockingMinerals();
            gs.initBaseLocations();
            gs.checkBasesWithBLockingMinerals();
            gs.initChokes();
            IntelligenceAgency.EnemyStrats ES = IntelligenceAgency.getEnemyStrat();
            if (Ecgberht.gs.mainChoke != null && (ES == IntelligenceAgency.EnemyStrats.ZealotRush || ES == IntelligenceAgency.EnemyStrats.EarlyPool)) {
                Ecgberht.gs.defendPosition = Ecgberht.gs.mainChoke.getCenter().toPosition();
            }
            Ecgberht.gs.map = new BuildingMap(bw, ih.self(), this.bwem);
            Ecgberht.gs.map.initMap();
            Ecgberht.gs.testMap = Ecgberht.gs.map.clone();
            this.initCollectTree();
            Ecgberht.initTrainTree();
            Ecgberht.initBuildTree();
            this.initScoutingTree();
            this.initDefenseTree();
            Ecgberht.initUpgradeTree();
            this.initRepairTree();
            Ecgberht.initAddonBuildTree();
            this.initBuildingLotTree();
            this.initScanTree();
            this.initHarassTree();
            this.initIslandTree();
            Ecgberht.gs.silentCartographer = new Cartographer(bw.getBWMap().mapWidth(), bw.getBWMap().mapHeight());
            if (ConfigManager.getConfig().ecgConfig.enableSkyCladObserver) {
                this.skycladObserver.toggle();
            }
            this.cherryVisDumper = new CherryVisDumper(gs);
        }
        catch (Exception e) {
            System.err.println("onStart Exception");
            e.printStackTrace();
        }
    }

    @Override
    public void onFrame() {
        try {
            if (Ecgberht.gs.enemyMainBase != null) {
                if (this.path == null) {
                    this.path = Ecgberht.gs.naturalChoke != null ? Ecgberht.gs.silentCartographer.getWalkablePath(Ecgberht.gs.naturalChoke.getCenter(), Ecgberht.gs.enemyMainBase.getLocation().toWalkPosition()) : Ecgberht.gs.silentCartographer.getWalkablePath(this.self.getStartLocation().toWalkPosition(), Ecgberht.gs.enemyMainBase.getLocation().toWalkPosition());
                } else if (ConfigManager.getConfig().ecgConfig.debugScreen) {
                    for (Position position : this.path.path) {
                        org.openbw.bwapi4j.Position pos = new WalkPosition(position.x, position.y).toPosition();
                        bw.getMapDrawer().drawCircleMap(pos, 4, Color.RED, true);
                    }
                }
            }
            Ecgberht.gs.frameCount = ih.getFrameCount();
            Ecgberht.gs.baseManager.updateGarrisons();
            this.skycladObserver.onFrame();
            gs.fix();
            Ecgberht.gs.unitStorage.onFrame();
            if (Ecgberht.gs.frameCount == 1500) {
                gs.sendCustomMessage();
            }
            if (Ecgberht.gs.frameCount == 2300) {
                gs.sendRandomMessage();
            }
            if (Ecgberht.gs.frameCount == 1000 && bw.getBWMap().mapHash().equals("69a3b6a5a3d4120e47408defd3ca44c954997948")) {
                Util.sendText("RIP");
                gs.getIH().leaveGame();
            }
            if (Ecgberht.gs.frameCount == 20160 && Ecgberht.gs.enemyRace == Race.Terran && Ecgberht.gs.getStrat().techToResearch.contains(TechType.Stim_Packs) && !Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Siege_Tank_Tank_Mode)) {
                gs.setStrat(new FullMech());
                Ecgberht.transition();
            }
            if (Ecgberht.gs.frameCount == 11520 && Ecgberht.gs.getStrat().proxy) {
                Ecgberht.gs.scipio.chooseProxyTransition();
                ArrayList<UnitInfo> workersToDelete = new ArrayList<UnitInfo>();
                for (UnitInfo u2 : Ecgberht.gs.myArmy) {
                    if (!(u2.unit instanceof Worker)) continue;
                    workersToDelete.add(u2);
                }
                Ecgberht.gs.myArmy.removeAll(workersToDelete);
                workersToDelete.forEach(u -> Ecgberht.gs.workerIdle.add((Worker)u.unit));
                Ecgberht.transition();
            }
            if (bw.getBWMap().mapHash().equals("6f5295624a7e3887470f3f2e14727b1411321a67") && Ecgberht.gs.getStrat().name.equals("PlasmaWraithHell") && Ecgberht.gs.frameCount == 16800) {
                FullBio b = new FullBio();
                b.buildUnits.remove(UnitType.Terran_Bunker);
                gs.setStrat(b);
                Ecgberht.gs.maxWraiths = 5;
                Ecgberht.transition();
            }
            if (bw.getBWMap().mapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1") && !Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Wraith) && Ecgberht.gs.frameCount == 21600) {
                Ecgberht.gs.getStrat().trainUnits.add(UnitType.Terran_Wraith);
                Ecgberht.gs.maxWraiths = 999;
                Ecgberht.transition();
            }
            if (bw.getBWMap().mapHash().equals("6f5295624a7e3887470f3f2e14727b1411321a67") && !Ecgberht.gs.getStrat().name.equals("PlasmaWraithHell")) {
                for (Unit unit : bw.getAllUnits()) {
                    if (unit.getType() != UnitType.Zerg_Egg && unit instanceof PlayerUnit && !Util.isEnemy(((PlayerUnit)unit).getPlayer())) continue;
                    if (!unit.isVisible() && Ecgberht.gs.enemyCombatUnitMemory.contains(unit)) {
                        Ecgberht.gs.enemyCombatUnitMemory.remove(unit);
                        continue;
                    }
                    if (unit.getType() != UnitType.Zerg_Egg || !(unit instanceof PlayerUnit) || Util.isEnemy(((PlayerUnit)unit).getPlayer())) continue;
                    Ecgberht.gs.enemyCombatUnitMemory.add(unit);
                }
            }
            if (Ecgberht.gs.getStrat().name.equals("TwoPortWraith") && Util.countBuildingAll(UnitType.Terran_Command_Center) > 1 && Ecgberht.gs.wraithsTrained >= 4) {
                if (Ecgberht.gs.enemyRace == Race.Zerg) {
                    if (IntelligenceAgency.enemyHasType(UnitType.Zerg_Lurker)) {
                        gs.setStrat(new BioMechFE());
                    } else {
                        gs.setStrat(new FullBioFE());
                    }
                    if (Ecgberht.gs.proxyBuilding != null) {
                        Ecgberht.gs.getStrat().trainUnits.add(UnitType.Terran_Vulture);
                    }
                } else if (Ecgberht.gs.enemyRace == Race.Terran) {
                    gs.setStrat(new FullMech());
                }
                Ecgberht.gs.getStrat().armyForAttack += 5;
                Ecgberht.transition();
            }
            if (Ecgberht.gs.getStrat().name.equals("VultureRush") && Util.countBuildingAll(UnitType.Terran_Command_Center) > 1) {
                gs.setStrat(new FullMech());
                if (Ecgberht.gs.naturalChoke != null) {
                    Ecgberht.gs.defendPosition = Ecgberht.gs.naturalChoke.getCenter().toPosition();
                }
                Ecgberht.transition();
            }
            if (Ecgberht.gs.getStrat().name.equals("TheNitekat") || Ecgberht.gs.getStrat().name.equals("JoyORush") && Ecgberht.gs.CCs.size() > 1) {
                gs.setStrat(new FullMech());
                if (Ecgberht.gs.naturalChoke != null) {
                    Ecgberht.gs.defendPosition = Ecgberht.gs.naturalChoke.getCenter().toPosition();
                }
                Ecgberht.transition();
            }
            gs.cancelDyingThings();
            Ecgberht.gs.wizard.onFrameSpellManager();
            IntelligenceAgency.onFrame();
            Ecgberht.gs.sim.onFrameSim();
            gs.vespeneManager();
            Ecgberht.gs.sqManager.updateBunkers();
            gs.checkDisrupter();
            this.buildingLotTree.run();
            this.repairTree.run();
            this.collectTree.run();
            upgradeTree.run();
            this.islandTree.run();
            buildTree.run();
            addonBuildTree.run();
            trainTree.run();
            this.scoutingTree.run();
            this.botherTree.run();
            this.scannerTree.run();
            if (Ecgberht.gs.getStrat().name.equals("ProxyBBS")) {
                gs.checkWorkerMilitia(2);
            } else if (Ecgberht.gs.getStrat().name.equals("ProxyEightRax")) {
                gs.checkWorkerMilitia(1);
            }
            this.defenseTree.run();
            gs.updateAttack();
            gs.runAgents();
            Ecgberht.gs.sqManager.updateSquadOrderAndMicro();
            gs.checkMainEnemyBase();
            if (Ecgberht.gs.frameCount > 10 && Ecgberht.gs.frameCount % 5 == 0) {
                gs.mineralLocking();
            }
            this.debugManager.onFrame(gs);
            this.cherryVisDumper.onFrame();
        }
        catch (Exception e) {
            System.err.println("onFrame Exception");
            e.printStackTrace();
        }
    }

    @Override
    public void onEnd(boolean arg0) {
        try {
            String name = ih.enemy().getName();
            if (arg0) {
                Util.sendText("gg wp " + name);
            } else {
                Util.sendText("gg wp! " + name + ", next game I will not lose!");
            }
            if (bw.getBWMap().mapHash().equals("6f5295624a7e3887470f3f2e14727b1411321a67")) {
                Ecgberht.gs.getStrat().name = "PlasmaWraithHell";
            }
            String oldStrat = IntelligenceAgency.getStartStrat();
            this.cherryVisDumper.onEnd(arg0, oldStrat);
            if (oldStrat != null && !oldStrat.equals(Ecgberht.gs.getStrat().name)) {
                Ecgberht.gs.getStrat().name = oldStrat;
            }
            Ecgberht.gs.learningManager.onEnd(Ecgberht.gs.getStrat().name, Ecgberht.gs.mapSize, arg0, name, Ecgberht.gs.enemyRace, bw.getBWMap().mapFileName().replace(".scx", ""), Ecgberht.gs.enemyIsRandom, IntelligenceAgency.getEnemyStrat());
        }
        catch (Exception e) {
            System.err.println("onEnd Exception");
            e.printStackTrace();
        }
    }

    @Override
    public void onNukeDetect(org.openbw.bwapi4j.Position arg0) {
    }

    @Override
    public void onPlayerLeft(Player arg0) {
    }

    @Override
    public void onReceiveText(Player arg0, String arg1) {
    }

    @Override
    public void onSaveGame(String arg0) {
    }

    @Override
    public void onSendText(String arg0) {
        this.debugManager.keyboardInteraction(arg0);
    }

    @Override
    public void onUnitCreate(Unit arg0) {
        try {
            UnitType type;
            if (arg0 == null) {
                return;
            }
            if (arg0 instanceof MineralPatch || arg0 instanceof VespeneGeyser || arg0 instanceof SpecialBuilding || arg0 instanceof Critter || arg0 instanceof ScannerSweep) {
                return;
            }
            PlayerUnit pU = (PlayerUnit)arg0;
            if (arg0 instanceof ResourceDepot) {
                Ecgberht.gs.baseManager.onCreate((ResourceDepot)arg0);
            }
            if (!(type = arg0.getType()).isNeutral() && !type.isSpecialBuilding()) {
                if (arg0 instanceof Building) {
                    if (pU.getPlayer().getId() == this.self.getId()) {
                        SCV worker;
                        Ecgberht.gs.unitStorage.onUnitCreate(arg0);
                        if (!(arg0 instanceof CommandCenter)) {
                            Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, false);
                            Ecgberht.gs.testMap = Ecgberht.gs.map.clone();
                        } else if (Ecgberht.getGs().iReallyWantToExpand) {
                            Ecgberht.getGs().iReallyWantToExpand = false;
                        }
                        if (arg0 instanceof Addon) {
                            return;
                        }
                        if (arg0 instanceof CommandCenter && ih.getFrameCount() == 0) {
                            return;
                        }
                        if (arg0 instanceof Bunker && Ecgberht.gs.learningManager.isNaughty() && Ecgberht.gs.enemyRace == Race.Zerg) {
                            Ecgberht.gs.defendPosition = arg0.getPosition();
                        }
                        if ((worker = (SCV)((Building)arg0).getBuildUnit()) != null && Ecgberht.gs.workerBuild.containsKey(worker) && type.equals(Ecgberht.gs.workerBuild.get((Object)worker).first)) {
                            Ecgberht.gs.workerTask.put(worker, (Building)arg0);
                            MutablePair<Integer, Integer> mutablePair = Ecgberht.gs.deltaCash;
                            mutablePair.first = (Integer)mutablePair.first - type.mineralPrice();
                            mutablePair = Ecgberht.gs.deltaCash;
                            mutablePair.second = (Integer)mutablePair.second - type.gasPrice();
                            Ecgberht.gs.workerBuild.remove(worker);
                        }
                    }
                } else if (pU.getPlayer().getId() == this.self.getId()) {
                    if (Ecgberht.gs.ih.getFrameCount() > 0) {
                        Ecgberht.gs.supplyMan.onCreate(arg0);
                    }
                    if (arg0 instanceof Vulture) {
                        ++Ecgberht.gs.vulturesTrained;
                    }
                    if (arg0 instanceof Wraith) {
                        ++Ecgberht.gs.wraithsTrained;
                    }
                    if (arg0 instanceof SiegeTank) {
                        ++Ecgberht.gs.tanksTrained;
                        if (Ecgberht.gs.tanksTrained == 3 && Ecgberht.gs.getStrat().name.equals("JoyORush")) {
                            Ecgberht.gs.getStrat().trainUnits.add(UnitType.Terran_Vulture);
                            Ecgberht.gs.getStrat().upgradesToResearch.add(UpgradeType.Ion_Thrusters);
                            Ecgberht.transition();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("onUnitCreate exception");
            e.printStackTrace();
        }
    }

    @Override
    public void onUnitComplete(Unit arg0) {
        block45: {
            try {
                if (arg0 instanceof MineralPatch || arg0 instanceof VespeneGeyser || arg0 instanceof SpecialBuilding || arg0 instanceof Critter || arg0 instanceof ScannerSweep) {
                    return;
                }
                this.skycladObserver.moveCameraUnitCompleted(arg0);
                PlayerUnit pU = (PlayerUnit)arg0;
                UnitType type = arg0.getType();
                if (type.isNeutral() || pU.getPlayer().getId() != this.self.getId()) break block45;
                Ecgberht.gs.unitStorage.onUnitComplete(arg0);
                if (Ecgberht.gs.ih.getFrameCount() > 0) {
                    Ecgberht.gs.supplyMan.onComplete(arg0);
                }
                if (type.isBuilding()) {
                    ++Ecgberht.gs.builtBuildings;
                    if (type.isRefinery()) {
                        for (Map.Entry<VespeneGeyser, Boolean> entry : Ecgberht.gs.vespeneGeysers.entrySet()) {
                            if (!entry.getKey().getTilePosition().equals(arg0.getTilePosition())) continue;
                            Ecgberht.gs.vespeneGeysers.put(entry.getKey(), true);
                            break;
                        }
                        for (Map.Entry<UnitImpl, Comparable<Boolean>> entry : Ecgberht.gs.workerTask.entrySet()) {
                            if (!((Building)entry.getValue()).equals(arg0)) continue;
                            Ecgberht.gs.workerGas.put((Worker)entry.getKey(), (GasMiningFacility)arg0);
                            Ecgberht.gs.workerTask.remove(entry.getKey());
                            break;
                        }
                        Ecgberht.gs.refineriesAssigned.put((GasMiningFacility)arg0, 1);
                        ++Ecgberht.gs.builtRefinery;
                        break block45;
                    }
                    if (type == UnitType.Terran_Command_Center) {
                        Base ccBase = Util.getClosestBaseLocation(arg0.getPosition());
                        if (!Ecgberht.gs.islandBases.isEmpty() && Ecgberht.gs.islandBases.contains(ccBase)) {
                            Ecgberht.gs.islandCCs.put(ccBase, (CommandCenter)arg0);
                        } else {
                            Ecgberht.gs.CCs.put(ccBase, (CommandCenter)arg0);
                        }
                        if (Ecgberht.gs.getStrat().name.equals("BioMechGreedyFE") && Util.getNumberCCs() > 2) {
                            Ecgberht.gs.getStrat().raxPerCC = 3;
                        } else if (Ecgberht.gs.getStrat().name.equals("BioMechGreedyFE") && Util.getNumberCCs() < 3) {
                            Ecgberht.gs.getStrat().raxPerCC = 2;
                        }
                        gs.addNewResources(ccBase);
                        if (Ecgberht.gs.frameCount != 0 && Ecgberht.gs.firstExpand && ccBase.getArea().equals(Ecgberht.gs.naturalArea) && !Ecgberht.gs.defense) {
                            gs.workerTransfer();
                        }
                        if (Ecgberht.gs.frameCount != 0 && Ecgberht.gs.firstExpand) {
                            Ecgberht.gs.firstExpand = false;
                            if (Ecgberht.gs.getStrat().name.equals("14CC")) {
                                Ecgberht.gs.scipio.choose14CCTransition();
                                Ecgberht.transition();
                            }
                            if (Ecgberht.gs.naturalChoke != null) {
                                Ecgberht.gs.defendPosition = Ecgberht.gs.naturalChoke.getCenter().toPosition();
                            }
                        }
                        if (((CommandCenter)arg0).getAddon() != null && !Ecgberht.gs.CSs.contains(((CommandCenter)arg0).getAddon())) {
                            Ecgberht.gs.CSs.add((ComsatStation)((CommandCenter)arg0).getAddon());
                        }
                        if (Ecgberht.gs.frameCount == 0) {
                            Ecgberht.gs.mainCC = new MutablePair<Object, Unit>(ccBase, arg0);
                        }
                    }
                    if (type == UnitType.Terran_Comsat_Station) {
                        Ecgberht.gs.CSs.add((ComsatStation)arg0);
                    }
                    if (type == UnitType.Terran_Bunker) {
                        Ecgberht.gs.DBs.put((Bunker)arg0, new TreeSet());
                    }
                    if (type == UnitType.Terran_Engineering_Bay || type == UnitType.Terran_Academy) {
                        Ecgberht.gs.UBs.add((ResearchingFacility)arg0);
                    }
                    if (type == UnitType.Terran_Barracks) {
                        Ecgberht.gs.MBs.add((Barracks)arg0);
                    }
                    if (type == UnitType.Terran_Factory) {
                        Ecgberht.gs.Fs.add((Factory)arg0);
                    }
                    if (type == UnitType.Terran_Starport) {
                        Ecgberht.gs.Ps.add((Starport)arg0);
                    }
                    if (type == UnitType.Terran_Science_Facility) {
                        Ecgberht.gs.UBs.add((ResearchingFacility)arg0);
                    }
                    if (type == UnitType.Terran_Control_Tower) {
                        Ecgberht.gs.UBs.add((ResearchingFacility)arg0);
                    }
                    if (type == UnitType.Terran_Armory) {
                        Ecgberht.gs.UBs.add((ResearchingFacility)arg0);
                    }
                    if (type == UnitType.Terran_Supply_Depot) {
                        Ecgberht.gs.SBs.add((SupplyDepot)arg0);
                    }
                    if (type == UnitType.Terran_Machine_Shop) {
                        Ecgberht.gs.UBs.add((ResearchingFacility)arg0);
                    }
                    if (type == UnitType.Terran_Missile_Turret) {
                        Ecgberht.gs.Ts.add((MissileTurret)arg0);
                    }
                    for (Map.Entry entry : Ecgberht.gs.workerTask.entrySet()) {
                        if (!((Building)entry.getValue()).equals(arg0)) continue;
                        Ecgberht.gs.workerIdle.add((Worker)entry.getKey());
                        Ecgberht.gs.workerTask.remove(entry.getKey());
                        break block45;
                    }
                    break block45;
                }
                if (type.isWorker()) {
                    Ecgberht.gs.workerIdle.add((Worker)arg0);
                } else if (type == UnitType.Terran_Vulture && !Ecgberht.gs.getStrat().name.equals("TheNitekat") && !bw.getBWMap().mapHash().equals("666dd28cd3c85223ebc749a481fc281e58221e4a")) {
                    Ecgberht.gs.agents.put(arg0, new VultureAgent(arg0));
                } else if (type == UnitType.Terran_Dropship) {
                    DropShipAgent d = new DropShipAgent(arg0);
                    Ecgberht.gs.agents.put(arg0, d);
                } else if (type == UnitType.Terran_Science_Vessel) {
                    VesselAgent v = new VesselAgent(arg0);
                    Ecgberht.gs.agents.put(arg0, v);
                } else if (type == UnitType.Terran_Wraith) {
                    if (!Ecgberht.gs.getStrat().name.equals("PlasmaWraithHell")) {
                        String name = gs.pickShipName();
                        Ecgberht.gs.agents.put(arg0, new WraithAgent(arg0, name));
                    }
                } else {
                    Ecgberht.gs.myArmy.add(Ecgberht.gs.unitStorage.getAllyUnits().get(arg0));
                    if (Ecgberht.gs.enemyMainBase != null && Ecgberht.gs.silentCartographer.mapCenter.getDistance(Ecgberht.gs.enemyMainBase.getLocation()) < arg0.getTilePosition().getDistance(Ecgberht.gs.enemyMainBase.getLocation())) {
                        ((MobileUnit)arg0).move(Ecgberht.gs.silentCartographer.mapCenter.toPosition());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("onUnitComplete exception");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onUnitDestroy(Unit arg0) {
        block66: {
            try {
                ArrayList<Worker> aux;
                UnitType type = arg0.getType();
                if (type.isMineralField() && Ecgberht.gs.mineralsAssigned.containsKey(arg0)) {
                    Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, true);
                    Ecgberht.gs.testMap = Ecgberht.gs.map.clone();
                    aux = new ArrayList<Worker>();
                    for (Map.Entry<Worker, MineralPatch> entry : Ecgberht.gs.workerMining.entrySet()) {
                        if (!arg0.equals(entry.getValue())) continue;
                        entry.getKey().stop(false);
                        Ecgberht.gs.workerIdle.add(entry.getKey());
                        aux.add(entry.getKey());
                    }
                    for (Unit unit : aux) {
                        Ecgberht.gs.workerMining.remove(unit);
                    }
                    Ecgberht.gs.mineralsAssigned.remove(arg0);
                }
                if (!(type.isBuilding() || type.isRefinery() || type == UnitType.Resource_Vespene_Geyser || type == UnitType.Spell_Scanner_Sweep || this.first)) {
                    gs.playSound("first.mp3");
                    this.first = true;
                }
                if (type.isNeutral() || type.isSpecialBuilding() && !type.isRefinery()) break block66;
                if (arg0 instanceof ResourceDepot) {
                    Ecgberht.gs.baseManager.onDestroy((ResourceDepot)arg0);
                }
                if (arg0 instanceof PlayerUnit && ((PlayerUnit)arg0).getPlayer().isEnemy()) {
                    IntelligenceAgency.onDestroy(arg0, type);
                    if (arg0.equals(Ecgberht.gs.chosenUnitToHarass)) {
                        Ecgberht.gs.chosenUnitToHarass = null;
                    }
                    if (type.isBuilding()) {
                        if (!type.isResourceDepot()) {
                            Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, true);
                        }
                    } else {
                        Ecgberht.gs.initDefensePosition = arg0.getTilePosition();
                    }
                } else if (arg0 instanceof PlayerUnit && ((PlayerUnit)arg0).getPlayer().getId() == this.self.getId()) {
                    Iterator<Worker> ally;
                    if (Ecgberht.gs.ih.getFrameCount() > 0) {
                        Ecgberht.gs.supplyMan.onDestroy(arg0);
                    }
                    if (arg0 instanceof Worker) {
                        MutablePair<Integer, Integer> ccBase;
                        if ((Ecgberht.gs.getStrat().name.equals("ProxyBBS") || Ecgberht.gs.getStrat().name.equals("ProxyEightRax")) && (ally = Ecgberht.gs.unitStorage.getAllyUnits().get(arg0)) != null) {
                            Ecgberht.gs.myArmy.remove(ally);
                        }
                        for (SCV sCV : Ecgberht.gs.repairerTask.keySet()) {
                            if (!sCV.equals(arg0)) continue;
                            Ecgberht.gs.workerIdle.add((Worker)arg0);
                            Ecgberht.gs.repairerTask.remove(sCV);
                            break;
                        }
                        Ecgberht.gs.workerIdle.remove(arg0);
                        if (arg0.equals(Ecgberht.gs.naughtySCV)) {
                            Ecgberht.gs.naughtySCV = null;
                        }
                        if (arg0.equals(Ecgberht.gs.chosenScout)) {
                            Ecgberht.gs.chosenScout = null;
                        }
                        if (arg0.equals(Ecgberht.gs.chosenHarasser)) {
                            Ecgberht.gs.chosenHarasser = null;
                            Ecgberht.gs.chosenUnitToHarass = null;
                            Ecgberht.getGs().firstScout = false;
                        }
                        if (arg0.equals(Ecgberht.gs.chosenWorker)) {
                            Ecgberht.gs.chosenWorker = null;
                        }
                        if (arg0.equals(Ecgberht.gs.chosenRepairer)) {
                            Ecgberht.gs.chosenRepairer = null;
                        }
                        ally = Ecgberht.gs.workerDefenders.keySet().iterator();
                        while (ally.hasNext()) {
                            Worker worker = ally.next();
                            if (!arg0.equals(worker)) continue;
                            Ecgberht.gs.workerDefenders.remove(worker);
                            break;
                        }
                        if (Ecgberht.gs.workerMining.containsKey(arg0)) {
                            MineralPatch mineral = Ecgberht.gs.workerMining.get(arg0);
                            Ecgberht.gs.workerMining.remove(arg0);
                            if (Ecgberht.gs.mineralsAssigned.containsKey(mineral)) {
                                --Ecgberht.gs.mining;
                                Ecgberht.gs.mineralsAssigned.put(mineral, Ecgberht.gs.mineralsAssigned.get(mineral) - 1);
                            }
                        }
                        if (Ecgberht.gs.workerGas.containsKey(arg0)) {
                            aux = Ecgberht.gs.workerGas.get(arg0);
                            Integer n = Ecgberht.gs.refineriesAssigned.get(aux);
                            Ecgberht.gs.refineriesAssigned.put((GasMiningFacility)((Object)aux), n - 1);
                            Ecgberht.gs.workerGas.remove(arg0);
                        }
                        if (Ecgberht.gs.workerTask.containsKey(arg0)) {
                            if (!Ecgberht.gs.islandBases.isEmpty() && Ecgberht.gs.workerTask.get(arg0) instanceof CommandCenter && Ecgberht.gs.islandBases.contains(ccBase = Util.getClosestBaseLocation(Ecgberht.gs.workerTask.get(arg0).getPosition()))) {
                                Ecgberht.gs.islandExpand = false;
                            }
                            Ecgberht.gs.buildingLot.add(Ecgberht.gs.workerTask.get(arg0));
                            Ecgberht.gs.workerTask.remove(arg0);
                        }
                        if (Ecgberht.gs.workerBuild.containsKey(arg0) && Ecgberht.gs.workerBuild.get((Object)arg0).first == UnitType.Terran_Command_Center) {
                            if (this.bwem.getMap().getArea((TilePosition)Ecgberht.gs.workerBuild.get((Object)arg0).second).equals(Ecgberht.gs.naturalArea)) {
                                Bunker b = !Ecgberht.gs.DBs.isEmpty() ? Ecgberht.gs.DBs.keySet().iterator().next() : null;
                                Ecgberht.gs.defendPosition = b != null ? b.getPosition() : Ecgberht.gs.mainChoke.getCenter().toPosition();
                            }
                            if (!Ecgberht.gs.islandBases.isEmpty() && Ecgberht.gs.islandBases.contains(ccBase = Util.getClosestBaseLocation(arg0.getPosition()))) {
                                Ecgberht.gs.islandExpand = false;
                            }
                            ccBase = Ecgberht.gs.deltaCash;
                            ccBase.first = (Integer)ccBase.first - ((UnitType)Ecgberht.gs.workerBuild.get((Object)arg0).first).mineralPrice();
                            ccBase = Ecgberht.gs.deltaCash;
                            ccBase.second = (Integer)ccBase.second - ((UnitType)Ecgberht.gs.workerBuild.get((Object)arg0).first).gasPrice();
                            Ecgberht.gs.workerBuild.remove(arg0);
                        }
                    } else if (type.isBuilding()) {
                        if (type != UnitType.Terran_Command_Center) {
                            Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, true);
                        }
                        for (Map.Entry<SCV, Mechanical> entry : Ecgberht.gs.repairerTask.entrySet()) {
                            if (!entry.getValue().equals(arg0)) continue;
                            Ecgberht.gs.workerIdle.add(entry.getKey());
                            Ecgberht.gs.repairerTask.remove(entry.getKey());
                            break;
                        }
                        if (arg0.equals(Ecgberht.gs.proxyBuilding)) {
                            Ecgberht.gs.proxyBuilding = null;
                        }
                        for (Map.Entry<SCV, PlayerUnit> entry : Ecgberht.gs.workerTask.entrySet()) {
                            if (!((Building)entry.getValue()).equals(arg0)) continue;
                            if (entry.getValue() instanceof CommandCenter) {
                                Base base;
                                if (this.bwem.getMap().getArea(((Building)entry.getValue()).getTilePosition()).equals(Ecgberht.gs.naturalArea)) {
                                    Bunker bunker = Ecgberht.gs.DBs.keySet().iterator().next();
                                    Ecgberht.gs.defendPosition = bunker != null ? bunker.getPosition() : Ecgberht.gs.mainChoke.getCenter().toPosition();
                                }
                                if (!Ecgberht.gs.islandBases.isEmpty() && Ecgberht.gs.islandBases.contains(base = Util.getClosestBaseLocation(arg0.getPosition()))) {
                                    Ecgberht.gs.islandExpand = false;
                                }
                            }
                            Ecgberht.gs.workerTask.remove(entry.getKey());
                            Ecgberht.gs.workerIdle.add(entry.getKey());
                            break;
                        }
                        for (Unit unit : Ecgberht.gs.buildingLot) {
                            if (!unit.equals(arg0)) continue;
                            if (unit instanceof CommandCenter && this.bwem.getMap().getArea(unit.getTilePosition()).equals(Ecgberht.gs.naturalArea)) {
                                Bunker bunker = !Ecgberht.gs.DBs.isEmpty() ? Ecgberht.gs.DBs.keySet().iterator().next() : null;
                                Ecgberht.gs.defendPosition = bunker != null ? bunker.getPosition() : Ecgberht.gs.mainChoke.getCenter().toPosition();
                            }
                            Ecgberht.gs.buildingLot.remove(unit);
                            break;
                        }
                        block9: for (CommandCenter commandCenter : Ecgberht.gs.CCs.values()) {
                            if (!commandCenter.equals(arg0)) continue;
                            gs.removeResources(arg0);
                            if (commandCenter.getAddon() != null) {
                                Ecgberht.gs.CSs.remove(commandCenter.getAddon());
                            }
                            if (this.bwem.getMap().getArea(arg0.getTilePosition()).equals(Ecgberht.gs.naturalArea)) {
                                Ecgberht.gs.defendPosition = Ecgberht.gs.mainChoke.getCenter().toPosition();
                            }
                            Ecgberht.gs.CCs.remove(Util.getClosestBaseLocation(arg0.getPosition()));
                            if (!arg0.equals(Ecgberht.gs.mainCC.second)) break;
                            if (Ecgberht.gs.CCs.size() > 0) {
                                for (Unit unit : Ecgberht.gs.CCs.values()) {
                                    if (unit.equals(arg0)) continue;
                                    Ecgberht.gs.mainCC = new MutablePair<Base, CommandCenter>(Util.getClosestBaseLocation(commandCenter.getPosition()), commandCenter);
                                    break block9;
                                }
                                break;
                            }
                            Ecgberht.gs.mainCC = null;
                            break;
                        }
                        for (CommandCenter commandCenter : Ecgberht.gs.islandCCs.values()) {
                            if (!commandCenter.equals(arg0)) continue;
                            gs.removeResources(arg0);
                            if (commandCenter.getAddon() != null) {
                                Ecgberht.gs.CSs.remove(commandCenter.getAddon());
                            }
                            Ecgberht.gs.islandCCs.remove(Util.getClosestBaseLocation(arg0.getPosition()));
                            break;
                        }
                        Ecgberht.gs.CSs.remove(arg0);
                        Ecgberht.gs.Fs.remove(arg0);
                        Ecgberht.gs.MBs.remove(arg0);
                        if (arg0.equals(Ecgberht.gs.proxyBuilding)) {
                            Ecgberht.gs.proxyBuilding = null;
                            Ecgberht.gs.getStrat().trainUnits.remove(UnitType.Terran_Vulture);
                        }
                        if (arg0 instanceof ResearchingFacility) {
                            Ecgberht.gs.UBs.remove(arg0);
                        }
                        Ecgberht.gs.SBs.remove(arg0);
                        Ecgberht.gs.Ts.remove(arg0);
                        Ecgberht.gs.Ps.remove(arg0);
                        if (type == UnitType.Terran_Bunker && Ecgberht.gs.DBs.containsKey(arg0)) {
                            Ecgberht.gs.myArmy.addAll((Collection<UnitInfo>)Ecgberht.gs.DBs.get(arg0));
                            Ecgberht.gs.DBs.remove(arg0);
                        }
                        if (type.isRefinery() && Ecgberht.gs.refineriesAssigned.containsKey(arg0)) {
                            aux = new ArrayList<Worker>();
                            for (Map.Entry<Worker, GasMiningFacility> entry : Ecgberht.gs.workerGas.entrySet()) {
                                if (!arg0.equals(entry.getValue())) continue;
                                Ecgberht.gs.workerIdle.add(entry.getKey());
                                aux.add(entry.getKey());
                            }
                            for (Unit unit : aux) {
                                Ecgberht.gs.workerGas.remove(unit);
                            }
                            Ecgberht.gs.refineriesAssigned.remove(arg0);
                            for (VespeneGeyser vespeneGeyser : Ecgberht.gs.vespeneGeysers.keySet()) {
                                if (!vespeneGeyser.getTilePosition().equals(arg0.getTilePosition())) continue;
                                Ecgberht.gs.vespeneGeysers.put(vespeneGeyser, false);
                            }
                        }
                        Ecgberht.gs.testMap = Ecgberht.gs.map.clone();
                    } else if (type == UnitType.Terran_Vulture) {
                        Ecgberht.gs.agents.remove(arg0);
                    } else if (type == UnitType.Terran_Dropship) {
                        Ecgberht.gs.agents.remove(arg0);
                    } else if (type == UnitType.Terran_Science_Vessel) {
                        Ecgberht.gs.agents.remove(arg0);
                    } else if (type == UnitType.Terran_Wraith && !Ecgberht.gs.getStrat().name.equals("PlasmaWraithHell") && Ecgberht.gs.agents.containsKey(arg0)) {
                        String wraith = ((WraithAgent)Ecgberht.gs.agents.get((Object)arg0)).name;
                        Ecgberht.gs.shipNames.add(wraith);
                        Ecgberht.gs.agents.remove(arg0);
                    }
                    if ((ally = Ecgberht.gs.unitStorage.getAllyUnits().get(arg0)) != null) {
                        Ecgberht.gs.myArmy.remove(ally);
                    }
                }
                Ecgberht.gs.unitStorage.onUnitDestroy(arg0);
            }
            catch (Exception e) {
                System.err.println("OnUnitDestroy Exception");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onUnitMorph(Unit arg0) {
        block6: {
            try {
                UnitType type = arg0.getType();
                if (arg0 instanceof PlayerUnit && ((PlayerUnit)arg0).getPlayer().isEnemy()) {
                    Ecgberht.gs.unitStorage.onUnitMorph(arg0);
                    if (!type.isBuilding() && (type.canAttack() || type.isSpellcaster() || type.spaceProvided() > 0)) {
                        Ecgberht.gs.enemyCombatUnitMemory.add(arg0);
                    }
                }
                if (!(arg0 instanceof Refinery) || !((PlayerUnit)arg0).getPlayer().equals(this.self)) break block6;
                for (Map.Entry<GasMiningFacility, Integer> entry : Ecgberht.gs.refineriesAssigned.entrySet()) {
                    if (!entry.getKey().getTilePosition().equals(arg0.getTilePosition())) continue;
                    Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, false);
                    Ecgberht.gs.testMap = Ecgberht.gs.map.clone();
                    break;
                }
                for (Map.Entry<PlayerUnit, Object> entry : Ecgberht.gs.workerBuild.entrySet()) {
                    if (!((SCV)entry.getKey()).equals(((Building)arg0).getBuildUnit()) || ((MutablePair)entry.getValue()).first != type) continue;
                    Ecgberht.gs.workerBuild.remove(entry.getKey());
                    Ecgberht.gs.workerTask.put((SCV)entry.getKey(), (Building)arg0);
                    MutablePair<Integer, Integer> mutablePair = Ecgberht.gs.deltaCash;
                    mutablePair.first = (Integer)mutablePair.first - type.mineralPrice();
                    mutablePair = Ecgberht.gs.deltaCash;
                    mutablePair.second = (Integer)mutablePair.second - type.gasPrice();
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("onUnitMorph Exception");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onUnitDiscover(Unit arg0) {
    }

    @Override
    public void onUnitEvade(Unit arg0) {
    }

    @Override
    public void onUnitHide(Unit arg0) {
        Ecgberht.gs.enemyCombatUnitMemory.remove(arg0);
    }

    @Override
    public void onUnitRenegade(Unit arg0) {
        if (arg0 instanceof PlayerUnit && ((PlayerUnit)arg0).getPlayer().equals(this.self)) {
            Ecgberht.gs.unitStorage.onUnitComplete(arg0);
        }
    }

    @Override
    public void onUnitShow(Unit arg0) {
        try {
            this.cherryVisDumper.onUnitShow(arg0);
            if (arg0 instanceof MineralPatch || arg0 instanceof VespeneGeyser || arg0 instanceof SpecialBuilding || arg0 instanceof Critter || arg0 instanceof ScannerSweep) {
                return;
            }
            UnitType type = arg0.getType();
            Player p = ((PlayerUnit)arg0).getPlayer();
            if (p != null && p.isEnemy()) {
                Ecgberht.gs.unitStorage.onUnitShow(arg0);
                IntelligenceAgency.onShow(arg0, type);
                if (Ecgberht.gs.enemyRace == Race.Unknown && Ecgberht.getGs().getIH().enemies().size() == 1) {
                    Ecgberht.gs.enemyRace = type.getRace();
                    if (Ecgberht.gs.enemyRace == Race.Zerg && Ecgberht.gs.getStrat().trainUnits.contains(UnitType.Terran_Firebat)) {
                        Ecgberht.gs.maxBats = 3;
                    }
                }
                if (!type.isBuilding() && (type.canAttack() || type.isSpellcaster() || type.spaceProvided() > 0)) {
                    Ecgberht.gs.enemyCombatUnitMemory.add(arg0);
                }
                if (type.isBuilding() && !Ecgberht.gs.unitStorage.getEnemyUnits().containsKey(arg0)) {
                    Ecgberht.gs.map.updateMap(arg0.getTilePosition(), type, false);
                }
            }
        }
        catch (Exception e) {
            System.err.println("OnUnitShow Exception");
            e.printStackTrace();
        }
    }
}

