/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.Base;
import bwem.ChokePoint;
import bwem.Mineral;
import cameraModule.CameraModule;
import ecgberht.Agents.Agent;
import ecgberht.Agents.DropShipAgent;
import ecgberht.Agents.VesselAgent;
import ecgberht.Agents.VultureAgent;
import ecgberht.Agents.WorkerScoutAgent;
import ecgberht.Agents.WraithAgent;
import ecgberht.ConfigManager;
import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import ecgberht.Util.ColorUtil;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.List;
import java.util.Map;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.MapDrawer;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.GasMiningFacility;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.Worker;

public class DebugManager {
    private MapDrawer mapDrawer;
    private InteractionHandler iH;
    private CameraModule skycladObserver;

    DebugManager(MapDrawer mapDrawer, InteractionHandler iH, CameraModule skycladObserver) {
        this.mapDrawer = mapDrawer;
        this.iH = iH;
        this.skycladObserver = skycladObserver;
    }

    void keyboardInteraction(String text) {
        switch (text) {
            case "dt": {
                boolean setting = ConfigManager.getConfig().ecgConfig.debugText;
                Util.sendText(!setting ? "debugText enabled" : "debugText disabled");
                ConfigManager.getConfig().ecgConfig.debugText = !setting;
                break;
            }
            case "dc": {
                boolean setting = ConfigManager.getConfig().ecgConfig.debugConsole;
                Util.sendText(!setting ? "debugConsole enabled" : "debugConsole disabled");
                ConfigManager.getConfig().ecgConfig.debugConsole = !setting;
                break;
            }
            case "ds": {
                boolean setting = ConfigManager.getConfig().ecgConfig.debugScreen;
                Util.sendText(!setting ? "debugScreen enabled" : "debugScreen disabled");
                ConfigManager.getConfig().ecgConfig.debugScreen = !setting;
                break;
            }
            case "obs": {
                boolean setting = ConfigManager.getConfig().ecgConfig.enableSkyCladObserver;
                Util.sendText(!setting ? "Observer enabled" : "Observer disabled");
                ConfigManager.getConfig().ecgConfig.enableSkyCladObserver = !setting;
                this.skycladObserver.toggle();
                break;
            }
            case "sounds": {
                boolean setting = ConfigManager.getConfig().ecgConfig.sounds;
                Util.sendText(!setting ? "Sounds Effects enabled" : "Sounds Effects disabled");
                ConfigManager.getConfig().ecgConfig.sounds = !setting;
                break;
            }
            case "noattack": {
                boolean setting = ConfigManager.getConfig().ecgConfig.debugDisableAttack;
                Util.sendText(!setting ? "Debug Attack enabled" : "Debug Attack disabled");
                ConfigManager.getConfig().ecgConfig.debugDisableAttack = !setting;
            }
        }
    }

    private void debugScreen(GameState gameState) {
        try {
            if (!ConfigManager.getConfig().ecgConfig.debugScreen) {
                return;
            }
            if (gameState.naturalArea != null) {
                this.print(gameState.naturalArea.getTop().toTilePosition(), Color.RED);
                for (ChokePoint c : gameState.naturalArea.getChokePoints()) {
                    if (c.getGeometry().size() <= 2) continue;
                    this.mapDrawer.drawLineMap(c.getGeometry().get(0).toPosition(), c.getGeometry().get(c.getGeometry().size() - 1).toPosition(), Color.GREY);
                }
            }
            for (ChokePoint c : gameState.bwem.getMap().getChokePoints()) {
                if (c.getGeometry().size() <= 2) continue;
                this.mapDrawer.drawLineMap(c.getGeometry().get(0).toPosition(), c.getGeometry().get(c.getGeometry().size() - 1).toPosition(), Color.GREEN);
            }
            for (MineralPatch m : gameState.walkingMinerals) {
                this.print(m, Color.RED);
            }
            for (MineralPatch d : gameState.blockingMinerals.values()) {
                this.print(d, Color.RED);
            }
            int counter = 0;
            for (Base base : gameState.BLs) {
                this.mapDrawer.drawTextMap(Util.getUnitCenterPosition(base.getLocation().toPosition(), UnitType.Terran_Command_Center), ColorUtil.formatText(Integer.toString(counter), (byte)4));
                for (Mineral m : base.getBlockingMinerals()) {
                    this.print(m.getUnit(), Color.RED);
                }
                ++counter;
            }
            for (Building building : gameState.buildingLot) {
                this.print(building, Color.PURPLE);
            }
            for (Unit unit : gameState.enemyInBase) {
                this.print(unit, Color.RED);
            }
            for (Base base : gameState.islandBases) {
                this.mapDrawer.drawTextMap(base.getLocation().toPosition(), ColorUtil.formatText("Island", (byte)4));
            }
            for (Unit unit : gameState.islandCCs.values()) {
                this.print(unit, Color.YELLOW);
            }
            for (Agent agent : gameState.agents.values()) {
                if (agent instanceof VultureAgent) {
                    VultureAgent vulture = (VultureAgent)agent;
                    this.mapDrawer.drawTextMap(vulture.myUnit.getPosition(), ColorUtil.formatText(agent.statusToString(), (byte)4));
                    continue;
                }
                if (agent instanceof VesselAgent) {
                    VesselAgent vessel = (VesselAgent)agent;
                    this.mapDrawer.drawTextMap(vessel.myUnit.getPosition(), ColorUtil.formatText(agent.statusToString(), (byte)4));
                    if (vessel.follow == null) continue;
                    this.mapDrawer.drawLineMap(vessel.myUnit.getPosition(), vessel.follow.getSquadCenter(), Color.YELLOW);
                    continue;
                }
                if (agent instanceof WraithAgent) {
                    WraithAgent wraith = (WraithAgent)agent;
                    this.mapDrawer.drawTextMap(wraith.myUnit.getPosition().add(new Position(-16, UnitType.Terran_Wraith.dimensionUp())), ColorUtil.formatText(wraith.name, (byte)4));
                    continue;
                }
                if (agent instanceof DropShipAgent) {
                    DropShipAgent dropShip = (DropShipAgent)agent;
                    this.mapDrawer.drawTextMap(dropShip.myUnit.getPosition(), ColorUtil.formatText(agent.statusToString(), (byte)4));
                    continue;
                }
                if (!(agent instanceof WorkerScoutAgent)) continue;
                WorkerScoutAgent worker = (WorkerScoutAgent)agent;
                this.mapDrawer.drawTextMap(worker.myUnit.getPosition().add(new Position(-16, UnitType.Terran_SCV.dimensionUp())), ColorUtil.formatText(worker.statusToString(), (byte)4));
            }
            if (gameState.enemyStartBase != null) {
                this.mapDrawer.drawTextMap(gameState.enemyStartBase.getLocation().toPosition(), ColorUtil.formatText("EnemyStartBase", (byte)4));
            }
            if (gameState.disrupterBuilding != null) {
                this.mapDrawer.drawTextMap(gameState.disrupterBuilding.getPosition().add(new Position(0, -8)), ColorUtil.formatText("BM!", (byte)4));
            }
            if (gameState.enemyNaturalBase != null) {
                this.mapDrawer.drawTextMap(gameState.enemyNaturalBase.getLocation().toPosition(), ColorUtil.formatText("EnemyNaturalBase", (byte)4));
            }
            if (gameState.mainChoke != null) {
                this.mapDrawer.drawTextMap(gameState.mainChoke.getCenter().toPosition(), ColorUtil.formatText("MainChoke", (byte)4));
            }
            if (gameState.naturalChoke != null) {
                this.mapDrawer.drawTextMap(gameState.naturalChoke.getCenter().toPosition(), ColorUtil.formatText("NatChoke", (byte)4));
            }
            if (gameState.chosenHarasser != null) {
                this.mapDrawer.drawTextMap(gameState.chosenHarasser.getPosition(), ColorUtil.formatText("Harasser", (byte)4));
                this.print(gameState.chosenHarasser, Color.BLUE);
            }
            for (Map.Entry entry : gameState.workerBuild.entrySet()) {
                this.print((Unit)entry.getKey(), Color.TEAL);
                this.mapDrawer.drawTextMap(((SCV)entry.getKey()).getPosition(), ColorUtil.formatText("Building " + ((UnitType)((MutablePair)entry.getValue()).first).toString(), (byte)4));
                this.print((TilePosition)((MutablePair)entry.getValue()).second, (UnitType)((MutablePair)entry.getValue()).first, Color.TEAL);
                this.mapDrawer.drawLineMap(((SCV)entry.getKey()).getPosition(), Util.getUnitCenterPosition(((TilePosition)((MutablePair)entry.getValue()).second).toPosition(), (UnitType)((MutablePair)entry.getValue()).first), Color.RED);
            }
            if (gameState.chosenUnitToHarass != null) {
                this.print(gameState.chosenUnitToHarass, Color.RED);
                this.mapDrawer.drawTextMap(gameState.chosenUnitToHarass.getPosition(), ColorUtil.formatText("UnitToHarass", (byte)4));
            }
            for (Map.Entry entry : gameState.repairerTask.entrySet()) {
                this.print((Unit)entry.getKey(), Color.YELLOW);
                this.mapDrawer.drawTextMap(((SCV)entry.getKey()).getPosition(), ColorUtil.formatText("Repairer", (byte)4));
                if (entry.getValue() == null || !((Mechanical)entry.getValue()).exists()) continue;
                this.print((Unit)entry.getValue(), Color.YELLOW);
                this.mapDrawer.drawLineMap(((SCV)entry.getKey()).getPosition(), ((Mechanical)entry.getValue()).getPosition(), Color.YELLOW);
            }
            for (UnitInfo unitInfo : gameState.unitStorage.getEnemyUnits().values()) {
                this.mapDrawer.drawTextMap(unitInfo.lastPosition.add(new Position(0, 16)), ColorUtil.formatText(unitInfo.unitType.toString(), (byte)4));
                this.print(unitInfo.unit, Color.RED);
            }
            if (gameState.chosenScout != null) {
                this.mapDrawer.drawTextMap(gameState.chosenScout.getPosition(), ColorUtil.formatText("Scouter", (byte)4));
                this.print(gameState.chosenScout, Color.PURPLE);
            }
            if (gameState.chosenRepairer != null) {
                this.mapDrawer.drawTextMap(gameState.chosenRepairer.getPosition(), ColorUtil.formatText("ChosenRepairer", (byte)4));
            }
            for (ChokePoint chokePoint : gameState.bwem.getMap().getChokePoints()) {
                List<WalkPosition> sides = chokePoint.getGeometry();
                if (sides.size() != 3) continue;
                this.mapDrawer.drawLineMap(sides.get(1).toPosition(), sides.get(2).toPosition(), Color.GREEN);
            }
            for (Unit unit : gameState.CCs.values()) {
                this.print(unit, Color.YELLOW);
                this.mapDrawer.drawCircleMap(unit.getPosition(), 500, Color.ORANGE);
            }
            for (Unit unit : gameState.DBs.keySet()) {
                this.mapDrawer.drawCircleMap(unit.getPosition(), 300, Color.ORANGE);
            }
            for (Unit unit : gameState.workerIdle) {
                this.print(unit, Color.ORANGE);
            }
            for (Map.Entry entry : gameState.workerTask.entrySet()) {
                this.print((Unit)entry.getKey(), Color.TEAL);
                this.mapDrawer.drawTextMap(((SCV)entry.getKey()).getPosition(), ColorUtil.formatText("Tasked: " + ((Building)entry.getValue()).getType().toString(), (byte)4));
                this.print((Unit)entry.getValue(), Color.TEAL);
                this.mapDrawer.drawLineMap(((SCV)entry.getKey()).getPosition(), ((Building)entry.getValue()).getPosition(), Color.RED);
            }
            for (Worker worker : gameState.workerDefenders.keySet()) {
                this.print(worker, Color.PURPLE);
                this.mapDrawer.drawTextMap(worker.getPosition(), ColorUtil.formatText("SpartanSCV", (byte)4));
            }
            for (Map.Entry entry : gameState.workerMining.entrySet()) {
                this.print((Unit)entry.getKey(), Color.CYAN);
                this.mapDrawer.drawLineMap(((Worker)entry.getKey()).getPosition(), ((MineralPatch)entry.getValue()).getPosition(), Color.CYAN);
            }
            for (Map.Entry entry : gameState.workerGas.entrySet()) {
                if (((Worker)entry.getKey()).getOrder() == Order.HarvestGas) continue;
                this.print((Unit)entry.getKey(), Color.GREEN);
                this.mapDrawer.drawLineMap(((Worker)entry.getKey()).getPosition(), ((GasMiningFacility)entry.getValue()).getPosition(), Color.GREEN);
            }
            for (Map.Entry entry : gameState.vespeneGeysers.entrySet()) {
                this.print((Unit)entry.getKey(), Color.GREEN);
                if (!gameState.refineriesAssigned.containsKey(entry.getKey())) continue;
                int gas = gameState.refineriesAssigned.get(entry.getKey());
                this.mapDrawer.drawTextMap(((VespeneGeyser)entry.getKey()).getPosition(), ColorUtil.formatText(Integer.toString(gas), (byte)4));
            }
            gameState.sim.drawClusters();
            for (Squad squad : gameState.sqManager.squads.values()) {
                if (squad.status != Squad.Status.ATTACK || squad.attack == null) continue;
                this.mapDrawer.drawLineMap(squad.getSquadCenter(), squad.attack, Color.ORANGE);
            }
            for (Squad squad : gameState.sqManager.squads.values()) {
                if (squad.members.isEmpty()) continue;
                Position center = squad.getSquadCenter();
                this.mapDrawer.drawTextMap(center.add(new Position(0, UnitType.Terran_Marine.dimensionUp())), ColorUtil.formatText(squad.status.toString(), (byte)4));
                this.mapDrawer.drawTextMap(center.add(new Position(0, UnitType.Terran_Marine.dimensionUp() * 2)), ColorUtil.formatText(squad.lose ? "Lose" : "Win", (byte)4));
            }
            for (Map.Entry entry : gameState.mineralsAssigned.entrySet()) {
                this.print((Unit)entry.getKey(), Color.CYAN);
                if ((Integer)entry.getValue() == 0) continue;
                this.mapDrawer.drawTextMap(((MineralPatch)entry.getKey()).getPosition(), ColorUtil.formatText(((Integer)entry.getValue()).toString(), (byte)4));
            }
        }
        catch (Exception e) {
            System.err.println("debugScreen Exception");
            e.printStackTrace();
        }
    }

    private void debugText(GameState gameState) {
        try {
            if (!ConfigManager.getConfig().ecgConfig.debugText) {
                return;
            }
            this.mapDrawer.drawTextScreen(320, 5, ColorUtil.formatText(gameState.supplyMan.getSupplyUsed() + "/" + gameState.supplyMan.getSupplyTotal(), (byte)4));
            this.mapDrawer.drawTextScreen(320, 20, ColorUtil.formatText(gameState.getArmySize() + "/" + gameState.getStrat().armyForAttack, (byte)4));
            String defending = gameState.defense ? ColorUtil.formatText("Defense", (byte)7) : ColorUtil.formatText("Defense", (byte)6);
            this.mapDrawer.drawTextScreen(320, 35, defending);
            this.mapDrawer.drawTextScreen(320, 50, ColorUtil.formatText("I want to train: " + gameState.chosenUnit.toString(), (byte)4));
            this.mapDrawer.drawTextScreen(320, 65, ColorUtil.formatText("I want to build: " + gameState.chosenToBuild.toString(), (byte)4));
            this.mapDrawer.drawTextScreen(320, 80, ColorUtil.formatText("Max_Goliaths: " + gameState.maxGoliaths, (byte)4));
            this.mapDrawer.drawTextScreen(320, 95, ColorUtil.formatText("Max_Vessels: " + gameState.maxVessels, (byte)4));
            if (gameState.enemyRace == Race.Zerg) {
                this.mapDrawer.drawTextScreen(320, 110, ColorUtil.formatText("Max_Firebats: " + gameState.maxBats, (byte)4));
            }
            if (gameState.ih.allies().size() + gameState.ih.enemies().size() == 1) {
                this.mapDrawer.drawTextScreen(10, 5, ColorUtil.formatText(gameState.ih.self().getName(), ColorUtil.getColor(gameState.ih.self().getColor())) + ColorUtil.formatText(" vs ", (byte)4) + ColorUtil.formatText(gameState.ih.enemy().getName(), ColorUtil.getColor(gameState.ih.enemy().getColor())));
            }
            if (gameState.chosenScout != null) {
                this.mapDrawer.drawTextScreen(10, 20, ColorUtil.formatText("Scouting: ", (byte)4) + ColorUtil.formatText("Yes", (byte)7));
            } else {
                this.mapDrawer.drawTextScreen(10, 20, ColorUtil.formatText("Scouting: ", (byte)4) + ColorUtil.formatText("No", (byte)6));
            }
            if (gameState.enemyMainBase != null) {
                this.mapDrawer.drawTextScreen(10, 35, ColorUtil.formatText("Enemy Base Found: ", (byte)4) + ColorUtil.formatText("Yes", (byte)7));
            } else {
                this.mapDrawer.drawTextScreen(10, 35, ColorUtil.formatText("Enemy Base Found: ", (byte)4) + ColorUtil.formatText("No", (byte)6));
            }
            this.mapDrawer.drawTextScreen(10, 50, ColorUtil.formatText("Framecount: ", (byte)4) + ColorUtil.formatText(Integer.toString(gameState.frameCount), (byte)3));
            this.mapDrawer.drawTextScreen(10, 65, ColorUtil.formatText("FPS: ", (byte)4) + ColorUtil.formatText(Integer.toString(gameState.ih.getFPS()), (byte)3));
            this.mapDrawer.drawTextScreen(65, 65, ColorUtil.formatText("APM: ", (byte)4) + ColorUtil.formatText(Integer.toString(gameState.ih.getAPM()), (byte)3));
            this.mapDrawer.drawTextScreen(10, 80, ColorUtil.formatText("Strategy: ", (byte)4) + ColorUtil.formatText(gameState.getStrat().name, (byte)3));
            this.mapDrawer.drawTextScreen(10, 95, ColorUtil.formatText("EnemyStrategy: ", (byte)4) + ColorUtil.formatText(IntelligenceAgency.getEnemyStrat().toString(), (byte)3));
            this.mapDrawer.drawTextScreen(10, 110, ColorUtil.formatText("SimTime(ms): ", (byte)4) + ColorUtil.formatText(String.valueOf(gameState.sim.time), (byte)15));
            if (gameState.enemyRace == Race.Zerg && gameState.learningManager.isNaughty()) {
                this.mapDrawer.drawTextScreen(10, 125, ColorUtil.formatText("Naughty Zerg: ", (byte)4) + ColorUtil.formatText("yes", (byte)7));
            }
        }
        catch (Exception e) {
            System.err.println("debugText Exception");
            e.printStackTrace();
        }
    }

    private void print(Unit u, Color color) {
        this.mapDrawer.drawBoxMap(u.getLeft(), u.getTop(), u.getRight(), u.getBottom(), color);
    }

    private void print(TilePosition u, UnitType type, Color color) {
        Position leftTop = new Position(u.getX() * 32, u.getY() * 32);
        Position rightBottom = new Position(leftTop.getX() + type.tileWidth() * 32, leftTop.getY() + type.tileHeight() * 32);
        this.mapDrawer.drawBoxMap(leftTop, rightBottom, color);
    }

    private void print(TilePosition u, Color color) {
        Position leftTop = new Position(u.getX() * 32, u.getY() * 32);
        Position rightBottom = new Position(leftTop.getX() + 32, leftTop.getY() + 32);
        this.mapDrawer.drawBoxMap(leftTop, rightBottom, color);
    }

    public void onFrame(GameState gs) {
        this.debugScreen(gs);
        this.debugText(gs);
    }
}

