/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import ecgberht.Ecgberht;
import org.bk.ass.path.Jps;
import org.bk.ass.path.PPMap;
import org.bk.ass.path.Position;
import org.bk.ass.path.Result;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public class Cartographer {
    private int mapTileHeight;
    private int mapTileWidth;
    public TilePosition mapCenter;
    private boolean[][] walkableGrid = new boolean[1024][1024];
    private boolean[][] tileWalkableGrid;
    private Jps mapJPS;
    private Jps mapJPSTile;

    public Cartographer(int width, int height) {
        this.mapTileWidth = width;
        this.mapTileHeight = height;
        this.tileWalkableGrid = new boolean[this.mapTileWidth][this.mapTileHeight];
        this.mapCenter = new TilePosition(this.mapTileWidth / 2, this.mapTileHeight / 2);
        this.initWalkableGrids();
    }

    public Result getWalkablePath(WalkPosition start, WalkPosition end) {
        return this.mapJPS.findPath(new Position(start.getX(), start.getY()), new Position(end.getX(), end.getY()));
    }

    public Result getWalkablePath(TilePosition start, TilePosition end) {
        return this.mapJPS.findPath(new Position(start.getX(), start.getY()), new Position(end.getX(), end.getY()));
    }

    private void initWalkableGrids() {
        int jj;
        int ii;
        for (ii = 0; ii < this.mapTileWidth * 4; ++ii) {
            for (jj = 0; jj < this.mapTileHeight * 4; ++jj) {
                this.walkableGrid[ii][jj] = Ecgberht.getGs().getGame().getBWMap().isWalkable(ii, jj);
            }
        }
        for (ii = 0; ii < this.mapTileWidth; ++ii) {
            for (jj = 0; jj < this.mapTileHeight; ++jj) {
                this.tileWalkableGrid[ii][jj] = Ecgberht.getGs().getGame().getBWMap().isWalkable(ii * 4, jj * 4);
            }
        }
        this.mapJPS = new Jps(PPMap.fromBooleanArray(this.walkableGrid));
        this.mapJPSTile = new Jps(PPMap.fromBooleanArray(this.tileWalkableGrid));
    }

    static enum Resolution {
        TilePosition,
        WalkPosition;

    }
}

