/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Training;

import ecgberht.GameState;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.ControlTower;
import org.openbw.bwapi4j.unit.Dropship;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.ScienceFacility;
import org.openbw.bwapi4j.unit.Starport;
import org.openbw.bwapi4j.unit.Unit;

public class ChooseSituationalUnit
extends Action {
    public ChooseSituationalUnit(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            boolean dropship = true;
            if (!this.gameState.islandBases.isEmpty()) {
                for (Unit unit : this.gameState.getGame().getUnits(this.gameState.getPlayer())) {
                    if (!unit.exists() || !(unit instanceof Dropship)) continue;
                    dropship = false;
                    break;
                }
            } else {
                dropship = false;
            }
            boolean tower = false;
            if (dropship && !this.gameState.getStrat().name.equals("2PortWraith")) {
                for (ResearchingFacility u3 : this.gameState.UBs) {
                    if (!(u3 instanceof ControlTower)) continue;
                    tower = true;
                    break;
                }
                if (!tower) {
                    return BehavioralTree.State.FAILURE;
                }
                for (Starport s : this.gameState.Ps) {
                    if (s.getAddon() == null || !s.getAddon().isCompleted() || s.isTraining()) continue;
                    this.gameState.chosenUnit = UnitType.Terran_Dropship;
                    this.gameState.chosenTrainingFacility = s;
                    return BehavioralTree.State.SUCCESS;
                }
            }
            if (Util.countUnitTypeSelf(UnitType.Terran_Science_Vessel) > this.gameState.maxVessels || this.gameState.workerMining.isEmpty()) {
                return BehavioralTree.State.FAILURE;
            }
            if (Util.countUnitTypeSelf(UnitType.Terran_Science_Vessel) > 0 && !this.gameState.needToAttack()) {
                return BehavioralTree.State.FAILURE;
            }
            String string = this.gameState.getStrat().name;
            if (string.equals("FullMech") || string.equals("MechGreedyFE") && Util.getNumberCCs() + (int)this.gameState.workerTask.values().stream().filter(u -> u instanceof CommandCenter).count() < 3) {
                return BehavioralTree.State.FAILURE;
            }
            tower = false;
            boolean science = false;
            for (ResearchingFacility u4 : this.gameState.UBs) {
                if (u4 instanceof ControlTower) {
                    tower = true;
                } else if (u4 instanceof ScienceFacility) {
                    science = true;
                }
                if (!science || !tower) continue;
                break;
            }
            if (!tower || !science) {
                return BehavioralTree.State.FAILURE;
            }
            for (Starport s : this.gameState.Ps) {
                if (s.getAddon() == null || !s.getAddon().isCompleted() || s.isTraining()) continue;
                if (string.contains("Bio") && (Integer)this.gameState.getCash().second < UnitType.Terran_Science_Vessel.gasPrice() && (Integer)this.gameState.getCash().first >= UnitType.Terran_Science_Vessel.mineralPrice() + 50) {
                    for (Barracks b : this.gameState.MBs) {
                        if (b.isTraining()) continue;
                        this.gameState.chosenUnit = UnitType.Terran_Marine;
                        this.gameState.chosenTrainingFacility = b;
                        return BehavioralTree.State.SUCCESS;
                    }
                }
                this.gameState.chosenUnit = UnitType.Terran_Science_Vessel;
                this.gameState.chosenTrainingFacility = s;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

